/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.service;

import com.huawei.lego.core.base.thread.CommonThread;
import com.huawei.lego.core.sdk.base.ICacheService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.service.AbstractDiscoveryThread;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CleanDiscoveryCacheThread
extends CommonThread {
    private static final int VALUE_1000 = 1000;
    private static final int VALUE_60 = 60;
    private static final int VALUE_30 = 30;
    private static final int VALUE_30000 = 30000;
    private static final int VALUE_10000 = 10000;
    private static final Log LOGGER = LogFactory.getInstance(CleanDiscoveryCacheThread.class);
    private Map<Long, AbstractDiscoveryThread> activeDiscoveryThreadMap;
    private ICacheService<String, Object> cacheService = null;
    private List<Long> policyIdList = new ArrayList<Long>();

    public CleanDiscoveryCacheThread(Map<Long, AbstractDiscoveryThread> activeDiscoveryThreadMap, ICacheService<String, Object> cacheService) {
        this.activeDiscoveryThreadMap = activeDiscoveryThreadMap;
        this.cacheService = cacheService;
    }

    @Override
    public void execute() {
        while (true) {
            this.policyIdList.clear();
            long currentTimeLong = System.currentTimeMillis();
            try {
                this.search(currentTimeLong);
                for (Long policyId : this.policyIdList) {
                    LOGGER.info((Object)("the discovery caceh will be cleaned, policyId is : " + policyId), 1L);
                    this.activeDiscoveryThreadMap.remove(policyId);
                    this.cacheService.remove((Object)("discoveryPolicyId_" + policyId));
                }
                CommonUtil.sleep((long)30000L);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)("exception in CleanDiscoveryCacheThread" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                CommonUtil.sleep((long)10000L);
                continue;
            }
            break;
        }
    }

    private void search(long currentTimeLong) {
        for (Map.Entry<Long, AbstractDiscoveryThread> entry : this.activeDiscoveryThreadMap.entrySet()) {
            long endTimeLong;
            long timeIntervalInMinutes;
            DiscoveryPolicy policy;
            Timestamp endDiscoveryTime;
            AbstractDiscoveryThread discoveryThread = entry.getValue();
            if (!discoveryThread.isCancel() || (endDiscoveryTime = (policy = discoveryThread.getPolicy()).getEndDiscoveryTime()) == null || (timeIntervalInMinutes = (currentTimeLong - (endTimeLong = endDiscoveryTime.getTime())) / 1000L / 60L) < 30L) continue;
            this.policyIdList.add(policy.getDiscoveryPolicyId());
        }
    }
}

