/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.service;

import com.huawei.lego.cbb.resource.dao.IResourceDao;
import com.huawei.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.com.south.sdk.model.TelnetPara;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.ICacheService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.nem.discover.dao.IDiscoveryDao;
import com.huawei.lego.nem.discover.sdk.model.DeviceTypeAndUrl;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryResult;
import com.huawei.lego.nem.discover.sdk.model.DynamicFieldOfDiscovery;
import com.huawei.lego.nem.discover.sdk.model.ExtendAttribute;
import com.huawei.lego.nem.discover.sdk.model.ExtendProductAttribute;
import com.huawei.lego.nem.discover.sdk.model.ImportedDiscoveryItem;
import com.huawei.lego.nem.discover.sdk.model.ParaTemplateAndUrl;
import com.huawei.lego.nem.discover.sdk.model.ProtocolAndUrl;
import com.huawei.lego.nem.discover.sdk.service.IDeviceTypeFilter;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.lego.nem.discover.sdk.service.IManagementProtocolAndPageUrlHandler;
import com.huawei.lego.nem.discover.sdk.service.IManualNodeEditor;
import com.huawei.lego.nem.discover.sdk.service.INodeEditor;
import com.huawei.lego.nem.discover.service.AbstractDiscoveryThread;
import com.huawei.lego.nem.discover.service.AutoDiscoveryThread;
import com.huawei.lego.nem.discover.service.CleanDiscoveryCacheThread;
import com.huawei.lego.nem.discover.service.DiscoveryModuleUncaughtExceptionHandler;
import com.huawei.lego.nem.discover.service.DiscoveryServiceImplUtil;
import com.huawei.lego.nem.discover.service.IcmpDiscoveryThread;
import com.huawei.lego.nem.discover.service.ImportDiscoveryThread;
import com.huawei.lego.nem.discover.service.ProductDiscoveryServiceContainer;
import com.huawei.lego.nem.discover.util.DaoFactory;
import com.huawei.lego.nem.discover.util.PropertyUtil;
import com.huawei.lego.nem.discover.util.WatchUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.util.StringUtils;

@Service(Name="DiscoveryServiceImpl", Desc="", Interface=IDiscoveryService.class)
public class DiscoveryServiceImpl
extends BaseService
implements IDiscoveryService {
    private static final int VALUE_5 = 5;
    private static final int VALUE_100 = 100;
    private static final int VALUE_30 = 30;
    private static final int VALUE_60 = 60;
    private static final int VALUE_1000 = 1000;
    private static final int VALUE_3 = 3;
    private static boolean isClearBufTaskSubmitted = false;
    private static boolean cleanDiscoveryCacheThreadStarted = false;
    private static Log logger = LogFactory.getInstance(DiscoveryServiceImpl.class);
    private ICacheService<String, Object> cacheService = null;
    private IDiscoveryDao discoveryDao = null;
    private IMessageCenter messageCenter = null;
    private List<INodeEditor> nodeEditorList = new ArrayList<INodeEditor>();
    private List<IManualNodeEditor> manualNodeEditorList = new ArrayList<IManualNodeEditor>();
    private List<IDeviceTypeFilter> deviceTypeFilterList = new ArrayList<IDeviceTypeFilter>();
    private Map<String, Map<String, DynamicFieldOfDiscovery>> deviceTypeDynamicFieldMap = new HashMap<String, Map<String, DynamicFieldOfDiscovery>>();
    private Map<String, String> managementProtocolPageUrlMap = new HashMap<String, String>();
    private Map<String, String> managementProtocolCreatePageUrlMap = new HashMap<String, String>();
    private ExecutorService threadPool = Executors.newFixedThreadPool(5);
    private Map<Long, AbstractDiscoveryThread> activeDiscoveryThreadMap = new ConcurrentHashMap<Long, AbstractDiscoveryThread>();
    private Set<Long> lockedDeviceWhenRefresh = Collections.synchronizedSet(new HashSet());
    private Set<Long> lockedDeviceWhenDelete = Collections.synchronizedSet(new HashSet());
    private Set<Long> lockedDeviceWhenSyncAlarm = Collections.synchronizedSet(new HashSet());
    private DiscoveryServiceImplUtil dsiUtil = new DiscoveryServiceImplUtil();

    private static void setClearBufTaskSubmittedFlag(boolean flag) {
        isClearBufTaskSubmitted = flag;
    }

    private static boolean isCleaningBufferTaskSubmitted() {
        return isClearBufTaskSubmitted;
    }

    private static void setCleanDiscoveryCacheThreadStarted(boolean startFlag) {
        cleanDiscoveryCacheThreadStarted = startFlag;
    }

    private static boolean isCleaningDiscCacheThreadStarted() {
        return cleanDiscoveryCacheThreadStarted;
    }

    public synchronized BatchOperationResult deleteDeviceNewWithoutMsg(List<Long> moIdList) {
        logger.trace((Object)"deleteDeviceNewWithoutMsg");
        return this.dsiUtil.deleteDeviceNewWithoutMsg(this.cacheService, moIdList);
    }

    private DeviceTypeAndUrl filterDevice(DeviceTypeAndUrl deviceTypeAndUrl, Map<String, Set<String>> unmodifiableMainSubTypeMap) {
        HashMap<String, Set<String>> filteredMainSubTypeMap = new HashMap<String, Set<String>>();
        for (IDeviceTypeFilter deviceTypeFilter : this.deviceTypeFilterList) {
            Map productDeviceTypeMap = deviceTypeFilter.filterDeviceType(unmodifiableMainSubTypeMap);
            if (productDeviceTypeMap != null) {
                logger.info((Object)("filtered product device type map is : " + productDeviceTypeMap), 1L);
                this.addToFilteredMainSubTypeMap(productDeviceTypeMap, filteredMainSubTypeMap);
                continue;
            }
            logger.info((Object)"filtered product device type map is : null", 1L);
        }
        deviceTypeAndUrl.setMainSubTypeMap(filteredMainSubTypeMap);
        return deviceTypeAndUrl;
    }

    private void addToFilteredMainSubTypeMap(Map<String, Set<String>> productDeviceTypeMap, Map<String, Set<String>> filteredMainSubTypeMap) {
        for (Map.Entry<String, Set<String>> productDeviceTypeEntry : productDeviceTypeMap.entrySet()) {
            String productMainType = productDeviceTypeEntry.getKey();
            if (filteredMainSubTypeMap.containsKey(productMainType)) {
                filteredMainSubTypeMap.get(productMainType).addAll((Collection<String>)productDeviceTypeEntry.getValue());
                continue;
            }
            filteredMainSubTypeMap.put(productMainType, productDeviceTypeEntry.getValue());
        }
        logger.trace((Object)"addToFilteredMainSubTypeMap:completed");
    }

    public synchronized DeviceTypeAndUrl getDeviceTypeAndUrl() {
        DeviceTypeAndUrl deviceTypeAndUrl = new DeviceTypeAndUrl();
        String hql = "from DeviceTypeRelation";
        List<?> deviceTypeRelationList = this.discoveryDao.findByHql(hql);
        HashMap<String, Set<String>> mainSubTypeMap = new HashMap<String, Set<String>>();
        if (deviceTypeRelationList != null) {
            logger.info((Object)("the deviceTypeRelationList is : " + deviceTypeRelationList), 1L);
            HashMap<String, String> typeUrlMap = new HashMap<String, String>();
            for (DeviceTypeRelation typeRelation : deviceTypeRelationList) {
                this.processTypeUrlMap(mainSubTypeMap, typeRelation, typeUrlMap);
            }
            deviceTypeAndUrl.setTypeUrlMap(typeUrlMap);
        } else {
            logger.info((Object)"the deviceTypeRelationList is : null", 1L);
        }
        HashMap mapHasUnmodifiableSet = new HashMap();
        for (Map.Entry entry : mainSubTypeMap.entrySet()) {
            mapHasUnmodifiableSet.put(entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
        Map<String, Set<String>> unmodifiableMainSubTypeMap = Collections.unmodifiableMap(mapHasUnmodifiableSet);
        deviceTypeAndUrl = this.filterDevice(deviceTypeAndUrl, unmodifiableMainSubTypeMap);
        logger.info((Object)("the result deviceTypeAndUrl is : " + deviceTypeAndUrl), 1L);
        return deviceTypeAndUrl;
    }

    private void processTypeUrlMap(Map<String, Set<String>> mainSubTypeMap, DeviceTypeRelation typeRelation, Map<String, String> typeUrlMap) {
        String mainType = typeRelation.getParentType();
        String subType = typeRelation.getChildType();
        String pageUrl = typeRelation.getPageUrl();
        if (!mainSubTypeMap.containsKey(mainType)) {
            mainSubTypeMap.put(mainType, new HashSet());
        }
        if (StringUtils.hasText((String)subType)) {
            Set<String> subTypeSet = mainSubTypeMap.get(mainType);
            subTypeSet.add(subType);
            if (StringUtils.hasText((String)pageUrl)) {
                typeUrlMap.put(subType, pageUrl);
            }
        } else if (StringUtils.hasText((String)pageUrl)) {
            typeUrlMap.put(mainType, pageUrl);
        }
        logger.trace((Object)"processTypeUrlMap:completed");
    }

    public synchronized ParaTemplateAndUrl getParaTemplateAndUrl() {
        ParaTemplateAndUrl paraTemplateAndUrl = new ParaTemplateAndUrl();
        String hql = "from Protocol p where p.isTemplate = true";
        List<?> protocolList = this.discoveryDao.findByHql(hql);
        if (protocolList != null) {
            logger.info((Object)("the result protocolList is : " + protocolList), 1L);
            HashMap<String, List<Protocol>> templateTypeInstanceMap = new HashMap<String, List<Protocol>>();
            for (Protocol protocol : protocolList) {
                this.addToTemplateTypeInstanceMap(protocol, templateTypeInstanceMap);
            }
            paraTemplateAndUrl.setTemplateTypeInstanceMap(templateTypeInstanceMap);
            paraTemplateAndUrl.setTemplateTypeUrlMap(this.managementProtocolCreatePageUrlMap);
        } else {
            logger.info((Object)"the result protocolList is : null", 1L);
        }
        logger.info((Object)("the result paraTemplateAndUrl is : " + paraTemplateAndUrl), 1L);
        return paraTemplateAndUrl;
    }

    private void addToTemplateTypeInstanceMap(Protocol protocol, Map<String, List<Protocol>> templateTypeInstanceMap) {
        if (protocol.getIsTemplate() != null && protocol.getIsTemplate().booleanValue()) {
            String className = protocol.getClass().getName();
            if (!templateTypeInstanceMap.containsKey(className)) {
                templateTypeInstanceMap.put(className, new ArrayList());
            }
            templateTypeInstanceMap.get(className).add(protocol);
        }
        logger.trace((Object)"addToTemplateTypeInstanceMap:completed");
    }

    public synchronized Paging getDiscoveryPolicy(int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        logger.info((Object)("will getDiscoveryPolicy, firstRowIndex is : " + firstRowIndex + ", totalRow is : " + totalRow + ", orderByField is : " + orderByField + ", orderByAscend is : " + orderByAscend), 1L);
        Paging discoveryPolicyPaging = this.discoveryDao.getDiscoveryPolicy(firstRowIndex, totalRow, orderByField, orderByAscend);
        List policyList = discoveryPolicyPaging.getData();
        ArrayList<DiscoveryPolicy> policyListWithoutManualStopped = new ArrayList<DiscoveryPolicy>();
        ArrayList<DiscoveryPolicy> policyListWithManualStopped = new ArrayList<DiscoveryPolicy>();
        for (DiscoveryPolicy policys : policyList) {
            this.getDiscoveryPolicy(policyListWithoutManualStopped, policyListWithManualStopped, policys);
        }
        if (orderByField != null && "discoveryPercentStr".equals(orderByField.trim())) {
            this.sortPolicy(orderByAscend, policyList, policyListWithoutManualStopped, policyListWithManualStopped);
        }
        if (!DiscoveryServiceImpl.isCleaningBufferTaskSubmitted()) {
            ExecutionService.submitTask(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        DiscoveryServiceImpl.this.clearBuffer();
                    }
                }
            });
            DiscoveryServiceImpl.setClearBufTaskSubmittedFlag(true);
        }
        return discoveryPolicyPaging;
    }

    private void getDiscoveryPolicy(List<DiscoveryPolicy> policyListWithoutManualStopped, List<DiscoveryPolicy> policyListWithManualStopped, DiscoveryPolicy policys) {
        if (!policys.getFinished().booleanValue()) {
            String key = "discoveryPolicyId_" + policys.getDiscoveryPolicyId();
            Long finishedIpCount = (Long)this.cacheService.get((Object)key);
            long percent100s = 0L;
            if (finishedIpCount == null) {
                logger.warn((Object)("finishedIpCount is null in the cache, key is : " + key), 1L);
                percent100s = 100L;
            } else {
                percent100s = finishedIpCount * 100L / policys.getTotalIpCount();
            }
            policys.setDiscoveryPercentStr(percent100s + "%");
            policys.setDiscoveryPercentInt((int)percent100s);
        }
        if (policys.getManualStopped().booleanValue()) {
            policyListWithManualStopped.add(policys);
        } else {
            policyListWithoutManualStopped.add(policys);
        }
    }

    private void sortPolicy(boolean orderByAscend, List<DiscoveryPolicy> policyList, List<DiscoveryPolicy> policyListWithoutManualStopped, List<DiscoveryPolicy> policyListWithManualStopped) {
        if (orderByAscend) {
            Collections.sort(policyListWithoutManualStopped, new Comparator<DiscoveryPolicy>(){

                @Override
                public int compare(DiscoveryPolicy o1, DiscoveryPolicy o2) {
                    return o1.getDiscoveryPercentInt() - o2.getDiscoveryPercentInt();
                }
            });
            policyList.clear();
            policyList.addAll(policyListWithoutManualStopped);
            policyList.addAll(policyListWithManualStopped);
        } else {
            Collections.sort(policyListWithoutManualStopped, new Comparator<DiscoveryPolicy>(){

                @Override
                public int compare(DiscoveryPolicy o1, DiscoveryPolicy o2) {
                    return o2.getDiscoveryPercentInt() - o1.getDiscoveryPercentInt();
                }
            });
            policyList.clear();
            policyList.addAll(policyListWithManualStopped);
            policyList.addAll(policyListWithoutManualStopped);
        }
        logger.trace((Object)"sortPolicy:completed");
    }

    private synchronized void clearBuffer() {
        try {
            CommonUtil.sleep((long)1800000L);
            String hql = "select p.uuidForPerDiscovery from DiscoveryPolicy p where p.finished = true";
            List<?> uuidListForPerDiscovery = this.discoveryDao.findByHql(hql);
            if (uuidListForPerDiscovery != null) {
                for (String uuidForPerDiscovery : uuidListForPerDiscovery) {
                    String discUniqueUuidKey = "disc_unique_" + uuidForPerDiscovery;
                    if (!this.cacheService.containsKey((Object)discUniqueUuidKey)) continue;
                    this.cacheService.remove((Object)discUniqueUuidKey);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("exception when clean the mutiple ip cache" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    public synchronized DiscoveryPolicy getDiscoveryPolicy(Long discoveryPolicyId) {
        String hql;
        List<?> protocolList;
        List<DiscoveryPolicy> policyList = this.discoveryDao.findByHql("from DiscoveryPolicy policy where policy.discoveryPolicyId = " + discoveryPolicyId);
        if (this.checkPolicyListNull(policyList)) {
            logger.warn((Object)("the discovery policy does not exit, discoveryPolicyId is : " + discoveryPolicyId), 1L);
            throw new LegoCheckedException(1055L);
        }
        DiscoveryPolicy policy = policyList.get(0);
        if (!policy.getFinished().booleanValue()) {
            String key = "discoveryPolicyId_" + policy.getDiscoveryPolicyId();
            Long finishedIpCount = (Long)this.cacheService.get((Object)key);
            long percent100 = 0L;
            if (finishedIpCount == null) {
                logger.warn((Object)("finishedIpCount is null in the cache, key is : " + key), 1L);
                percent100 = 100L;
            } else {
                percent100 = finishedIpCount * 100L / policy.getTotalIpCount();
            }
            policy.setDiscoveryPercentStr(percent100 + "%");
            policy.setDiscoveryPercentInt((int)percent100);
        }
        if (policy.getDiscoveryStyle() == 0) {
            this.dealVSM(policy);
        }
        if ((protocolList = this.discoveryDao.findByHql(hql = "from Protocol p where p.discoveryPolicy.discoveryPolicyId = " + policy.getDiscoveryPolicyId())) != null) {
            for (Protocol protocol : protocolList) {
                policy.addManagementProtocol(protocol.getClass().getName(), protocol);
            }
            Map managementProtocolMap = policy.getManagementProtocolMap();
            if (managementProtocolMap != null) {
                policy.setSnmpPara((SnmpPara)managementProtocolMap.get(SnmpPara.class.getName()));
                policy.setTelnetPara((TelnetPara)managementProtocolMap.get(TelnetPara.class.getName()));
            }
        }
        return policy;
    }

    private boolean checkPolicyListNull(List<DiscoveryPolicy> policyList) {
        if (policyList == null || policyList.isEmpty()) {
            return true;
        }
        logger.trace((Object)"checkPolicyListNull:policyList is not null");
        return false;
    }

    private void dealVSM(DiscoveryPolicy policy) {
        Map ipRangeMap = policy.getIpRangeMap();
        String ipRangeString = policy.getIpRangeString();
        String[] ipRangeArr = ipRangeString.split(";");
        if (ipRangeArr != null) {
            for (String ipRange : ipRangeArr) {
                this.addToIpRangeMap(ipRange, ipRangeMap);
            }
        }
        logger.trace((Object)"dealVSM:completed");
    }

    private void addToIpRangeMap(String ipRange, Map<String, String> ipRangeMap) {
        String[] ipPair = ipRange.split("-");
        if (ipPair.length > 1) {
            if (ipPair[0].equals(ipPair[1])) {
                ipRangeMap.put(ipPair[0], null);
            } else {
                ipRangeMap.put(ipPair[0], ipPair[1]);
            }
        }
        logger.trace((Object)"addToIpRangeMap:completed");
    }

    public synchronized Paging getDiscoveryResult(Long discoveryPolicyId, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        logger.info((Object)("discoveryPolicyId is : " + discoveryPolicyId), 1L);
        if (discoveryPolicyId == null) {
            return new Paging();
        }
        if (this.discoveryDao.get(DiscoveryPolicy.class, discoveryPolicyId) == null) {
            logger.warn((Object)("the discovery policy does not exitttt, discoveryPolicyId is : " + discoveryPolicyId), 1L);
            throw new LegoCheckedException(1055L);
        }
        return this.discoveryDao.getDiscoveryResult(discoveryPolicyId, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    public synchronized Paging getImportedDiscoveryItem(Long discoveryPolicyId, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        logger.trace((Object)"getImportedDiscoveryItem");
        return this.discoveryDao.getImportedDiscoveryItem(discoveryPolicyId, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    public synchronized Long discoveryFromExcel(DiscoveryPolicy policy, List<ImportedDiscoveryItem> itemList) {
        if (itemList.isEmpty()) {
            logger.error((Object)"the itemList is empty", 1L);
            throw new LegoCheckedException(1054L);
        }
        logger.info((Object)("itemList size is : " + itemList.size()), 1L);
        logger.info((Object)"will begin discoveryFromExcel", 1L);
        policy.addManagementProtocol(SnmpPara.class.getName(), (Protocol)policy.getSnmpPara());
        if (policy.getTelnetPara() != null) {
            policy.addManagementProtocol(TelnetPara.class.getName(), (Protocol)policy.getTelnetPara());
        }
        policy.setDiscoveryStyle(1);
        policy.setBeginDiscoveryTime(new Timestamp(System.currentTimeMillis()));
        policy.setTotalIpCount(Long.valueOf((long)itemList.size() * 1L));
        policy.setDiscoveryPercentStr("0%");
        policy.setDiscoveryPercentInt(0);
        policy.setTopoElementId(policy.getTopoElementId());
        policy.setTopoElementName(policy.getTopoElementName());
        policy.setStartIP(itemList.get(0).getIpAddress());
        policy.setEndIP(itemList.get(itemList.size() - 1).getIpAddress());
        this.discoveryDao.save(policy);
        SnmpPara snmpPara = policy.getSnmpPara();
        snmpPara.setTemplateName(UUID.randomUUID().toString());
        snmpPara.setDiscoveryPolicy(policy);
        this.discoveryDao.save(snmpPara);
        TelnetPara telnetPara = policy.getTelnetPara();
        if (telnetPara != null) {
            telnetPara.setTemplateName(UUID.randomUUID().toString());
            telnetPara.setDiscoveryPolicy(policy);
            this.discoveryDao.save(policy.getTelnetPara());
        }
        HashMap<String, Long> ipDiscoveryResultMap = new HashMap<String, Long>();
        for (ImportedDiscoveryItem discoveryItem : itemList) {
            discoveryItem.setDiscoveryPolicy(policy);
            this.discoveryDao.save(discoveryItem);
            DiscoveryResult discoveryResult = new DiscoveryResult();
            discoveryResult.setDiscoveryPolicy(policy);
            discoveryResult.setIpAddress(discoveryItem.getIpAddress());
            this.discoveryDao.save(discoveryResult);
            ipDiscoveryResultMap.put(policy.getDiscoveryPolicyId() + "_" + discoveryItem.getIpAddress(), discoveryResult.getDiscoveryResultId());
        }
        this.cacheService.put((Object)("discoveryPolicyId_" + policy.getDiscoveryPolicyId()), (Object)0L);
        ImportDiscoveryThread discoveryThread = new ImportDiscoveryThread(policy, itemList, ipDiscoveryResultMap);
        this.activeDiscoveryThreadMap.put(policy.getDiscoveryPolicyId(), discoveryThread);
        this.threadPool.execute(discoveryThread);
        return policy.getDiscoveryPolicyId();
    }

    public synchronized Long discovery(DiscoveryPolicy policy) {
        logger.info((Object)"will begin auto discovery", 1L);
        policy.setDiscoveryStyle(0);
        policy.setBeginDiscoveryTime(new Timestamp(System.currentTimeMillis()));
        policy.addManagementProtocol(SnmpPara.class.getName(), (Protocol)policy.getSnmpPara());
        if (policy.getTelnetPara() != null) {
            policy.addManagementProtocol(TelnetPara.class.getName(), (Protocol)policy.getTelnetPara());
        }
        long totalIpCount = 0L;
        StringBuilder ipRangeStringBuilder = new StringBuilder();
        HashMap<String, String> tempSingleIpMap = new HashMap<String, String>();
        for (Map.Entry entrySet : policy.getIpRangeMap().entrySet()) {
            String startIp = (String)entrySet.getKey();
            String endIp = (String)entrySet.getValue();
            if (!StringUtils.hasText((String)endIp)) {
                endIp = startIp;
                tempSingleIpMap.put(startIp, endIp);
            }
            ipRangeStringBuilder.append(startIp).append("-").append(endIp).append(";");
            long startIpLong = WatchUtil.getAddrLong(startIp);
            long endIpLong = WatchUtil.getAddrLong(endIp);
            totalIpCount += endIpLong + 1L - startIpLong;
        }
        policy.getIpRangeMap().putAll(tempSingleIpMap);
        ipRangeStringBuilder.deleteCharAt(ipRangeStringBuilder.length() - 1);
        policy.setTotalIpCount(Long.valueOf(totalIpCount));
        policy.setIpRangeString(ipRangeStringBuilder.toString());
        policy.setDiscoveryPercentStr("0%");
        policy.setDiscoveryPercentInt(0);
        this.discoveryDao.save(policy);
        SnmpPara snmpParas = policy.getSnmpPara();
        snmpParas.setTemplateName(UUID.randomUUID().toString());
        snmpParas.setDiscoveryPolicy(policy);
        this.discoveryDao.save(snmpParas);
        TelnetPara telnetParas = policy.getTelnetPara();
        if (telnetParas != null) {
            telnetParas.setTemplateName(UUID.randomUUID().toString());
            telnetParas.setDiscoveryPolicy(policy);
            this.discoveryDao.save(policy.getTelnetPara());
        }
        this.cacheService.put((Object)("discoveryPolicyId_" + policy.getDiscoveryPolicyId()), (Object)0L);
        AutoDiscoveryThread autoDiscoveryThread = new AutoDiscoveryThread(policy);
        this.activeDiscoveryThreadMap.put(policy.getDiscoveryPolicyId(), autoDiscoveryThread);
        this.threadPool.execute(autoDiscoveryThread);
        return policy.getDiscoveryPolicyId();
    }

    public synchronized void updateDiscoveryResultAndPolicy(DiscoveryResult discoveryResult, boolean icmpPingSuccess) {
        logger.info((Object)("discovery result is : " + discoveryResult), 1L);
        DiscoveryPolicy discoveryPolicy = discoveryResult.getDiscoveryPolicy();
        if (discoveryPolicy.getDiscoveryStyle() == 1 && discoveryResult.getDiscoveryResultId() == null) {
            ImportDiscoveryThread importDiscoveryThread = (ImportDiscoveryThread)this.activeDiscoveryThreadMap.get(discoveryPolicy.getDiscoveryPolicyId());
            if (importDiscoveryThread == null) {
                logger.warn((Object)("the discovery policy may be stopped, discoveryPolicy is : " + discoveryPolicy), 1L);
                return;
            }
            String key = discoveryPolicy.getDiscoveryPolicyId() + "_" + discoveryResult.getIpAddress();
            Long discoveryResultId = importDiscoveryThread.getIpDiscoveryResultIdMap().get(key);
            if (discoveryResultId == null) {
                logger.error((Object)("can not find discoveryResultId from ipDiscoveryResult in updateDiscoveryPolicyAndResult, key is " + key + ", ipDiscoveryResultIdMap is : " + importDiscoveryThread.getIpDiscoveryResultIdMap()), 1L);
            }
            discoveryResult.setDiscoveryResultId(discoveryResultId);
        }
        if (discoveryPolicy.getDiscoveryStyle() == 1) {
            this.discoveryDao.update(discoveryResult);
        } else if (discoveryResult.getSuccess().booleanValue() || icmpPingSuccess) {
            this.discoveryDao.save(discoveryResult);
        }
        this.updateDiscoveryPolicy(discoveryPolicy, discoveryResult.getSuccess());
    }

    public synchronized void updateDiscoveryPolicy(DiscoveryPolicy policy, boolean discoverSuccess) {
        logger.info((Object)"will updateDiscoveryStatus", 1L);
        DiscoveryPolicy discoveryPolicy = (DiscoveryPolicy)this.discoveryDao.get(DiscoveryPolicy.class, Long.valueOf(policy.getDiscoveryPolicyId()));
        if (discoveryPolicy == null) {
            logger.warn((Object)"the discovery policy does not exist", 1L);
            return;
        }
        String key = "discoveryPolicyId_" + discoveryPolicy.getDiscoveryPolicyId();
        if (!this.cacheService.containsKey((Object)key)) {
            logger.warn((Object)"the discovery policy may finish or be stopped manually", 1L);
            return;
        }
        this.cacheService.increaseCachedDataCount(key);
        Long discoveredIpCount = (Long)this.cacheService.get((Object)key);
        Long totalIpCount = discoveryPolicy.getTotalIpCount();
        logger.info((Object)("discoveredIpCount is : " + discoveredIpCount + ", totalIpCount is : " + totalIpCount), 1L);
        if (discoveredIpCount >= totalIpCount) {
            this.cacheService.remove((Object)key);
            this.activeDiscoveryThreadMap.remove(discoveryPolicy.getDiscoveryPolicyId());
            discoveryPolicy.setFinished(Boolean.valueOf(true));
            discoveryPolicy.setEndDiscoveryTime(new Timestamp(System.currentTimeMillis()));
            discoveryPolicy.setDiscoveryPercentStr("100%");
            discoveryPolicy.setDiscoveryPercentInt(100);
        }
        this.discoveryDao.update(discoveryPolicy);
    }

    private void addProtocol(List<Protocol> protocolList, DiscoveryPolicy policy) {
        Protocol p;
        if (protocolList != null && !protocolList.isEmpty() && (p = protocolList.get(0)) instanceof SnmpPara) {
            policy.addManagementProtocol(SnmpPara.class.getName(), (Protocol)((SnmpPara)p));
        }
        logger.trace((Object)"addProtocol:completed");
    }

    private void addEndAttrParam(List<ExtendAttribute> extendAttributeList, Map<String, String> paramMap) {
        if (extendAttributeList != null && !extendAttributeList.isEmpty()) {
            for (ExtendAttribute ea : extendAttributeList) {
                paramMap.put(ea.getAttributeName(), ea.getAttributeValue());
            }
        }
        logger.trace((Object)"addEndAttrParam:completed");
    }

    public synchronized BatchOperationResult rediscovery(List<DiscoveryPolicy> policyList) {
        logger.info((Object)"begin rediscover.");
        ArrayList<BatchOperation> list = new ArrayList<BatchOperation>();
        int failCount = 0;
        for (DiscoveryPolicy policy : policyList) {
            BatchOperation operation;
            DiscoveryPolicy policyInDb = (DiscoveryPolicy)this.discoveryDao.get(DiscoveryPolicy.class, Long.valueOf(policy.getDiscoveryPolicyId()));
            if (policyInDb == null) {
                logger.info((Object)"the discovery policy does not exist.");
                ++failCount;
                operation = this.getBatchOperation(policy);
                operation.setErrorCode(1060L);
                list.add(operation);
                continue;
            }
            if (!policyInDb.getFinished().booleanValue()) {
                logger.info((Object)"the policy is discovering.");
                continue;
            }
            this.updatePolicyIntoDb(policy, policyInDb);
            this.executeRediscovery(policyInDb);
            operation = this.getBatchOperation(policy);
            list.add(operation);
        }
        logger.info((Object)"rediscovery finished.");
        BatchOperationResult batchOpResult = new BatchOperationResult();
        batchOpResult.setResult(list);
        batchOpResult.setFailCount(failCount);
        batchOpResult.setTotalCount(policyList.size());
        batchOpResult.setSucceedCount(policyList.size() - failCount);
        return batchOpResult;
    }

    private BatchOperation getBatchOperation(DiscoveryPolicy policy) {
        BatchOperation operation = new BatchOperation();
        if (this.checkEndipNotNull(policy)) {
            operation.setTargetName(policy.getStartIP() + "-" + policy.getEndIP());
        } else {
            operation.setTargetName(policy.getStartIP() + "-" + policy.getStartIP());
        }
        return operation;
    }

    private void updatePolicyIntoDb(DiscoveryPolicy policy, DiscoveryPolicy policyInDb) {
        policyInDb.setUuidForPerDiscovery(UUID.randomUUID().toString());
        policyInDb.setDiscoveryStyle(3);
        policyInDb.setBeginDiscoveryTime(new Timestamp(System.currentTimeMillis()));
        policyInDb.setDiscoveryPercentStr("0%");
        policyInDb.setDiscoveryPercentInt(0);
        policyInDb.setDiscoveredDeviceCount(Integer.valueOf(0));
        policyInDb.setFinished(Boolean.valueOf(false));
        policyInDb.setEndDiscoveryTime(null);
        policyInDb.setExceptionTerminated(Boolean.valueOf(false));
        policyInDb.setManualStopped(Boolean.valueOf(false));
        String hql = "from Protocol p where p.discoveryPolicy.discoveryPolicyId = " + policy.getDiscoveryPolicyId();
        List<Protocol> protocolList = this.discoveryDao.findByHql(hql);
        this.addProtocol(protocolList, policyInDb);
        long ipTotal = 1L;
        long startIpLong = WatchUtil.getAddrLong(policyInDb.getStartIP());
        if (StringUtils.hasText((String)policyInDb.getEndIP())) {
            long endIpLong = WatchUtil.getAddrLong(policyInDb.getEndIP());
            ipTotal = endIpLong + 1L - startIpLong;
        }
        policyInDb.setTotalIpCount(Long.valueOf(ipTotal));
        this.discoveryDao.update(policyInDb);
    }

    private void executeRediscovery(DiscoveryPolicy policyInDb) {
        String hql = "from ExtendAttribute ea where ea.discoveryPolicy.discoveryPolicyId = " + policyInDb.getDiscoveryPolicyId();
        List<ExtendAttribute> extendAttributeList = this.discoveryDao.findByHql(hql);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.addEndAttrParam(extendAttributeList, paramMap);
        policyInDb.setParamMap(paramMap);
        this.cacheService.put((Object)("discoveryPolicyId_" + policyInDb.getDiscoveryPolicyId()), (Object)0L);
        policyInDb.setLocation(this.decode(policyInDb.getLocation()));
        IcmpDiscoveryThread icmpDiscoveryThread = new IcmpDiscoveryThread(policyInDb, this.nodeEditorList);
        this.activeDiscoveryThreadMap.put(policyInDb.getDiscoveryPolicyId(), icmpDiscoveryThread);
        hql = "delete from DiscoveryResult dr where dr.discoveryPolicy.discoveryPolicyId = ?";
        Object[] param = new Object[]{policyInDb.getDiscoveryPolicyId()};
        this.discoveryDao.updateByHql(hql, param);
        this.threadPool.execute(icmpDiscoveryThread);
    }

    private boolean checkEndipNotNull(DiscoveryPolicy aPolicy) {
        if (aPolicy.getEndIP() != null && !aPolicy.getEndIP().equals("")) {
            logger.trace((Object)"checkEndipNotNull:endIP is not null");
            return true;
        }
        return false;
    }

    public synchronized Long icmpDiscovery(DiscoveryPolicy policy) {
        logger.info((Object)"begin icmp discovery.");
        this.setPolicyInfo(policy);
        policy = this.updateAndSavePolicy(policy);
        this.cacheService.put((Object)("discoveryPolicyId_" + policy.getDiscoveryPolicyId()), (Object)0L);
        policy.setLocation(this.decode(policy.getLocation()));
        IcmpDiscoveryThread icmpDiscoveryThread = new IcmpDiscoveryThread(policy, this.nodeEditorList);
        this.activeDiscoveryThreadMap.put(policy.getDiscoveryPolicyId(), icmpDiscoveryThread);
        this.threadPool.execute(icmpDiscoveryThread);
        logger.info((Object)"icmp discovery finished.");
        return policy.getDiscoveryPolicyId();
    }

    private DiscoveryPolicy updateAndSavePolicy(DiscoveryPolicy policy) {
        SnmpPara snmpPara;
        Map extendProductMap;
        policy = ProductDiscoveryServiceContainer.disSavePro(policy);
        this.validateDiscParam(policy);
        this.discoveryDao.save(policy);
        Map paramMap = policy.getParamMap();
        if (paramMap != null) {
            for (Map.Entry entry : paramMap.entrySet()) {
                String string = (String)entry.getKey();
                String paramValue = (String)entry.getValue();
                ExtendAttribute ea = new ExtendAttribute();
                ea.setAttributeName(string);
                ea.setAttributeValue(paramValue);
                ea.setDiscoveryPolicy(policy);
                this.discoveryDao.save(ea);
            }
        }
        if ((extendProductMap = policy.getExtendProductAttributeMap()) != null) {
            for (Map.Entry entry : extendProductMap.entrySet()) {
                String paramName = (String)entry.getKey();
                String paramValue = (String)entry.getValue();
                ExtendProductAttribute ea = new ExtendProductAttribute();
                ea.setAttributeName(paramName);
                ea.setAttributeValue(paramValue);
                ea.setDiscoveryPolicy(policy);
                this.discoveryDao.save(ea);
            }
        }
        if ((snmpPara = policy.getSnmpPara()) != null) {
            snmpPara.setTemplateName(UUID.randomUUID().toString());
            snmpPara.setDiscoveryPolicy(policy);
            this.discoveryDao.save(snmpPara);
        }
        return policy;
    }

    private void setPolicyInfo(DiscoveryPolicy policy) {
        policy.setUuidForPerDiscovery(UUID.randomUUID().toString());
        policy.setDiscoveryStyle(3);
        policy.setBeginDiscoveryTime(new Timestamp(System.currentTimeMillis()));
        policy.setDiscoveryPercentStr("0%");
        policy.setDiscoveryPercentInt(0);
        if (policy.getSnmpPara() != null) {
            policy.addManagementProtocol(SnmpPara.class.getName(), (Protocol)policy.getSnmpPara());
        }
        long startIpLong = 0L;
        if (WatchUtil.regexpMatchIp(policy.getStartIP())) {
            startIpLong = WatchUtil.getAddrLong(policy.getStartIP());
        }
        long totalIpCount = 1L;
        if (StringUtils.hasText((String)policy.getEndIP())) {
            long endIpLong = 0L;
            if (WatchUtil.regexpMatchIp(policy.getEndIP())) {
                endIpLong = WatchUtil.getAddrLong(policy.getEndIP());
            }
            totalIpCount = endIpLong + 1L - startIpLong;
        }
        policy.setTotalIpCount(Long.valueOf(totalIpCount));
    }

    private boolean validateDiscParam(DiscoveryPolicy policy) {
        logger.trace((Object)"validateDiscParam");
        return this.dsiUtil.validateDiscParam(policy);
    }

    public synchronized BatchOperationResult deleteDiscoveryPolicy(List<DiscoveryPolicy> discoveryPolicyList) {
        logger.info((Object)"will deleteDiscoveryPolicy ", 1L);
        BatchOperationResult batchOpResult = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int failCount = 0;
        int operCount = discoveryPolicyList.size();
        for (DiscoveryPolicy discoveryPolicy : discoveryPolicyList) {
            try {
                DiscoveryPolicy policyFromDB = (DiscoveryPolicy)this.discoveryDao.get(DiscoveryPolicy.class, Long.valueOf(discoveryPolicy.getDiscoveryPolicyId()));
                if (policyFromDB == null) {
                    ++failCount;
                    BatchOperation operation = new BatchOperation();
                    operation.setErrorCode(1027L);
                    operation.setTargetName(discoveryPolicy.getIpRangeString());
                    resultList.add(operation);
                    continue;
                }
                Object[] param = new Object[]{policyFromDB.getDiscoveryPolicyId()};
                String sql = "delete from T_extend_attribute where discovery_policy_id = ?";
                logger.info((Object)"delete T_extend_attribute data", 1L);
                this.discoveryDao.updateBySql(sql, param);
                sql = "delete from T_extend_productattribute where discovery_policy_id = ?";
                logger.info((Object)"delete T_extend_productattribute data,", 1L);
                this.discoveryDao.updateBySql(sql, param);
                this.discoveryDao.delete(policyFromDB);
                BatchOperation operation = new BatchOperation();
                operation.setTargetName(discoveryPolicy.getIpRangeString());
                resultList.add(operation);
            }
            catch (Exception e) {
                logger.error((Object)("exception when deleteDiscoveryPolicy, discoveryPolicy is : " + discoveryPolicy + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                ++failCount;
                this.addOperation(resultList, discoveryPolicy.getIpRangeString(), 0L, 1027L);
            }
        }
        batchOpResult.setResult(resultList);
        batchOpResult.setFailCount(failCount);
        batchOpResult.setTotalCount(operCount);
        batchOpResult.setSucceedCount(operCount - failCount);
        return batchOpResult;
    }

    public synchronized BatchOperationResult stopDiscovery(List<DiscoveryPolicy> discoveryPolicyList) {
        logger.info((Object)"will stopDiscovery", 1L);
        BatchOperationResult batchOpResult = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int failCount = 0;
        int operCount = discoveryPolicyList.size();
        for (DiscoveryPolicy discoveryPolicy : discoveryPolicyList) {
            AbstractDiscoveryThread discoveryThread = this.activeDiscoveryThreadMap.get(discoveryPolicy.getDiscoveryPolicyId());
            if (discoveryThread != null) {
                discoveryThread.stop();
                DiscoveryPolicy policyFromDB = (DiscoveryPolicy)this.discoveryDao.get(DiscoveryPolicy.class, Long.valueOf(discoveryPolicy.getDiscoveryPolicyId()));
                if (policyFromDB == null) {
                    ++failCount;
                    this.addOperation(resultList, discoveryPolicy.getIpRangeString(), 0L, 1027L);
                    logger.info((Object)"the discovery policy may have been deleted, policy is : ", 1L);
                    continue;
                }
                if (policyFromDB.getFinished().booleanValue()) {
                    ++failCount;
                    this.addOperation(resultList, discoveryPolicy.getIpRangeString(), 0L, 1026L);
                    logger.info((Object)"the discovery policy is finished and cannot stop the discovery policy.", 1L);
                    continue;
                }
                policyFromDB.setFinished(Boolean.valueOf(true));
                policyFromDB.setManualStopped(Boolean.valueOf(true));
                policyFromDB.setEndDiscoveryTime(new Timestamp(System.currentTimeMillis()));
                policyFromDB.setDiscoveryPercentStr("100%");
                policyFromDB.setDiscoveryPercentInt(100);
                ServiceProvider.getCommonService().update((Object)policyFromDB);
                BatchOperation operation = new BatchOperation();
                operation.setTargetName(discoveryPolicy.getIpRangeString());
                resultList.add(operation);
                continue;
            }
            ++failCount;
            this.addOperation(resultList, discoveryPolicy.getIpRangeString(), 0L, 1026L);
            logger.warn((Object)("can not find discoveryThread in activeDiscoveryThreadMap, discoveryPolicy is : " + discoveryPolicy), 1L);
        }
        if (!DiscoveryServiceImpl.isCleaningDiscCacheThreadStarted()) {
            DiscoveryServiceImpl.setCleanDiscoveryCacheThreadStarted(true);
            CleanDiscoveryCacheThread cleanDiscoveryCacheThread = new CleanDiscoveryCacheThread(this.activeDiscoveryThreadMap, this.cacheService);
            cleanDiscoveryCacheThread.setThreadName("clean discovery cache thread");
            cleanDiscoveryCacheThread.setExceptionHandler(new DiscoveryModuleUncaughtExceptionHandler());
            ExecutionService.submitTask(cleanDiscoveryCacheThread);
        }
        batchOpResult.setResult(resultList);
        batchOpResult.setFailCount(failCount);
        batchOpResult.setTotalCount(operCount);
        batchOpResult.setSucceedCount(operCount - failCount);
        return batchOpResult;
    }

    public synchronized BatchOperationResult deleteDevice(List<Long> moIdList) {
        logger.info((Object)("will deleteDevice, moIdList is : " + moIdList), 1L);
        IResourceDao resourceDao = DaoFactory.getInstance().getResourceDao();
        BatchOperationResult batchOpResult = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int failCount = 0;
        int operCount = moIdList.size();
        IResourceService resourceServiceTemp = this.dsiUtil.getResourceService();
        for (Long moId : moIdList) {
            logger.info((Object)("willllllll delete device moid is : " + moId), 1L);
            try {
                ManagedObject lmo = resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                logger.info((Object)("llllllllllllllmo is : " + lmo), 1L);
                HashMap<String, String> map = new HashMap<String, String>();
                failCount = this.checkFail(lmo, moId, failCount, resultList, map);
                if ("true".equals(map.get("flag"))) continue;
                resourceServiceTemp.deleteMo(moId);
            }
            catch (Exception e) {
                logger.error((Object)("delete device faileddddddd, moId is : " + moId + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                ++failCount;
                BatchOperation operation = new BatchOperation();
                operation.setErrorCode(1028L);
                ManagedObject lmo = resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                if (lmo != null) {
                    operation.setTargetName(lmo.getName());
                } else {
                    operation.setTargetName(String.valueOf(moId));
                }
                resultList.add(operation);
            }
        }
        batchOpResult.setResult(resultList);
        batchOpResult.setFailCount(failCount);
        batchOpResult.setTotalCount(operCount);
        batchOpResult.setSucceedCount(operCount - failCount);
        return batchOpResult;
    }

    private int checkFail(ManagedObject lmo, Long moId, int failCount, List<BatchOperation> resultList, Map<String, String> map) {
        if (lmo == null) {
            logger.warn((Object)("tttttthe device has been already deleted, moId is : " + moId), 1L);
            ++failCount;
            this.addOperation(resultList, "", moId, 1028L);
            map.put("flag", "true");
        } else {
            String keys = "mo_uuid_" + lmo.getUuid();
            if (this.cacheService.containsKey((Object)keys)) {
                logger.warn((Object)("the device is synchronizing data, moId is : " + moId), 1L);
                ++failCount;
                this.addOperation(resultList, "", moId, 1028L);
                map.put("flag", "true");
            }
        }
        return failCount;
    }

    public synchronized void checkOverLimitResourceQuantity(int addNum) {
        String hql = "select count(*) from DrResource";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        long existDrNum = this.discoveryDao.getTotalCount(hql, param);
        if (existDrNum + (long)addNum > 10000L) {
            logger.error((Object)"Over the resource quantity limit. current resource num:[%s]. add num:[%s]", new Object[]{existDrNum, addNum});
            throw new SpecCheckedException("discovery_resource_quantity", existDrNum + (long)addNum, 10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteNetworkEntity(List<Long> moIds) {
        logger.info((Object)("will deleteDeviceNewwwwwwwwww, bathOprLst size is : " + moIds.size()), 1L);
        IResourceDao resourceDao = DaoFactory.getInstance().getResourceDao();
        IResourceService resourceServiceTemp = this.dsiUtil.getResourceService();
        for (Long moId : moIds) {
            logger.info((Object)("will delete device moid is : " + moId), 1L);
            if (this.lockedDeviceWhenRefresh.contains(moId)) {
                logger.info((Object)("the mo is locked because the mo is in refresh, moId is : " + moId), 1L);
                throw new LegoCheckedException(1033L);
            }
            if (this.lockedDeviceWhenSyncAlarm.contains(moId)) {
                logger.info((Object)("the mo is locked because the mo is in synchrnonizing alarm, moId is : " + moId), 1L);
                throw new LegoCheckedException(1028L);
            }
            try {
                this.lockedDeviceWhenDelete.add(moId);
                ManagedObject lmo = resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                if (lmo == null) {
                    logger.warn((Object)("the device has been already deleted, moId is : " + moId), 1L);
                    throw new LegoCheckedException(201L);
                }
                String key = "mo_uuid_" + lmo.getUuid();
                if (this.cacheService.containsKey((Object)key)) {
                    logger.warn((Object)("the device is synchronizing data, moId is : " + moId), 1L);
                    throw new LegoCheckedException(1033L);
                }
                resourceServiceTemp.deleteMo(moId);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("delete device failed, moId is : " + moId), (long)1028L, null, (Log)logger);
            }
            finally {
                this.lockedDeviceWhenDelete.remove(moId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BatchOperationResult deleteDeviceNew(List<BatchOperation> bathOprLst) {
        logger.info((Object)("will deleteDeviceNewwwwwwwwww, bathOprLst size is : " + bathOprLst.size()), 1L);
        IResourceDao resourceDao = DaoFactory.getInstance().getResourceDao();
        BatchOperationResult batchOpResult = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int failCount = 0;
        int operCount = bathOprLst.size();
        IResourceService resourceServiceTemp = this.dsiUtil.getResourceService();
        for (BatchOperation op : bathOprLst) {
            Long moId = op.getTargetId();
            logger.info((Object)("will delete device moid is : " + moId), 1L);
            if (this.lockedDeviceWhenRefresh.contains(moId)) {
                logger.info((Object)("the mo is locked because the mo is in refresh, moId is : " + moId), 1L);
                ++failCount;
                this.addOperation(resultList, op.getTargetName(), moId, 1033L);
                continue;
            }
            if (this.lockedDeviceWhenSyncAlarm.contains(moId)) {
                logger.info((Object)("the mo is locked because the mo is in synchrnonizing alarm, moId is : " + moId), 1L);
                ++failCount;
                this.addOperation(resultList, op.getTargetName(), moId, 1033L);
                continue;
            }
            try {
                this.lockedDeviceWhenDelete.add(moId);
                ManagedObject lmo = resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                HashMap<String, String> map = new HashMap<String, String>();
                failCount = this.checkFailNew(lmo, failCount, moId, resultList, op, map);
                if ("true".equals(map.get("flag"))) continue;
                resourceServiceTemp.deleteMo(moId);
            }
            catch (Exception e) {
                logger.error((Object)("delete device failed, moId is : " + moId + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                ++failCount;
                this.addOperation(resultList, op.getTargetName(), moId, 1028L);
                continue;
            }
            finally {
                this.lockedDeviceWhenDelete.remove(moId);
                continue;
            }
            this.addOperation(resultList, op.getTargetName(), moId, 0L);
        }
        batchOpResult.setResult(resultList);
        batchOpResult.setFailCount(failCount);
        batchOpResult.setTotalCount(operCount);
        batchOpResult.setSucceedCount(operCount - failCount);
        return batchOpResult;
    }

    private void addOperation(List<BatchOperation> resultList, String targetName, long moId, long errorCode) {
        BatchOperation operation = new BatchOperation();
        operation.setErrorCode(errorCode);
        operation.setTargetName(targetName);
        operation.setTargetId(moId);
        resultList.add(operation);
    }

    private int checkFailNew(ManagedObject lmo, int failCount, Long moId, List<BatchOperation> resultList, BatchOperation op, Map<String, String> map) {
        if (lmo == null) {
            logger.warn((Object)("the device has been already deleted, moId is : " + moId), 1L);
            ++failCount;
            this.addOperation(resultList, op.getTargetName(), moId, 1028L);
            map.put("flag", "true");
        } else {
            String key = "mo_uuid_" + lmo.getUuid();
            if (this.cacheService.containsKey((Object)key)) {
                logger.warn((Object)("the device is synchronizing data, moId is : " + moId), 1L);
                ++failCount;
                this.addOperation(resultList, op.getTargetName(), moId, 1028L);
                map.put("flag", "true");
            }
        }
        return failCount;
    }

    public synchronized List<String> getLocation() {
        logger.trace((Object)"getLocation");
        String sql = "select location from T_locationinfo";
        return this.discoveryDao.findBySql(sql);
    }

    public Map<String, Map<String, DynamicFieldOfDiscovery>> getDeviceTypeDynamicFieldMap() {
        return this.deviceTypeDynamicFieldMap;
    }

    public synchronized void setCacheService(ICacheService<String, Object> cacheService) {
        this.cacheService = cacheService;
    }

    public synchronized void setDiscoveryDao(IDiscoveryDao discoveryDao) {
        this.discoveryDao = discoveryDao;
    }

    public void onBind(INodeEditor topoObjectEditor, Map<String, String> map) {
        this.nodeEditorList.add(topoObjectEditor);
        logger.info((Object)("topoObjectEditor size is : " + this.nodeEditorList.size()), 1L);
    }

    public void onUnbind(INodeEditor topoObjectEditor, Map<String, String> map) {
        logger.trace((Object)"onUnbind");
        this.nodeEditorList.remove(topoObjectEditor);
    }

    public void onStart(IManualNodeEditor manualNodeEditor, Map<String, String> map) {
        logger.trace((Object)"onStart");
        this.manualNodeEditorList.add(manualNodeEditor);
    }

    public void onStop(IManualNodeEditor manualNodeEditor, Map<String, String> map) {
        logger.trace((Object)"onStop");
        this.manualNodeEditorList.remove(manualNodeEditor);
    }

    public void onBinding(IDeviceTypeFilter deviceTypeFilter, Map<String, String> map) {
        logger.trace((Object)"onBinding");
        this.deviceTypeFilterList.add(deviceTypeFilter);
    }

    public void onUnbinding(IDeviceTypeFilter deviceTypeFilter, Map<String, String> map) {
        logger.trace((Object)"onUnbinding");
        this.deviceTypeFilterList.remove(deviceTypeFilter);
    }

    public void onStartup(IManagementProtocolAndPageUrlHandler managementProtocolAndPageUrlHandler, Map<String, String> map) {
        List protocolAndUrlList = managementProtocolAndPageUrlHandler.getManagementProtocolPageUrl();
        if (protocolAndUrlList != null) {
            logger.trace((Object)"onStartup:protocolAndUrlList is not null");
            for (ProtocolAndUrl protocolAndUrl : protocolAndUrlList) {
                this.managementProtocolPageUrlMap.put(protocolAndUrl.getPrococolFullClassName(), protocolAndUrl.getModifyPageUrl());
                this.managementProtocolCreatePageUrlMap.put(protocolAndUrl.getPrococolFullClassName(), protocolAndUrl.getCreatePageUrl());
            }
        }
    }

    public void onShutdown(IManagementProtocolAndPageUrlHandler managementProtocolAndPageUrlHandler, Map<String, String> map) {
        List protocolAndUrlList = managementProtocolAndPageUrlHandler.getManagementProtocolPageUrl();
        if (protocolAndUrlList != null) {
            logger.trace((Object)"onShutdown:protocolAndUrlList is not null");
            for (ProtocolAndUrl protocolAndUrl : protocolAndUrlList) {
                this.managementProtocolPageUrlMap.remove(protocolAndUrl.getPrococolFullClassName());
                this.managementProtocolCreatePageUrlMap.remove(protocolAndUrl.getPrococolFullClassName());
            }
        }
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    public synchronized void modifyManagementProtocol(Protocol protocol0) {
        SnmpPara snmpPara;
        SnmpPara snmpPara0;
        logger.info((Object)"will modifyManagementProtocol", 1L);
        Protocol protocol = (Protocol)this.discoveryDao.get(Protocol.class, protocol0.getId());
        if (protocol == null || protocol.getNode() == null) {
            logger.warn((Object)("in modifyManagementProtocol the protocol or the node does not exist, protocol is : " + protocol0));
            throw new LegoCheckedException(201L);
        }
        Node nod = protocol.getNode();
        this.discoveryDao.update(protocol0);
        this.updateSnmpVer(protocol0, this.discoveryDao);
        if (protocol0 instanceof SnmpPara && protocol instanceof SnmpPara && !(snmpPara0 = (SnmpPara)protocol0).equals((Object)(snmpPara = (SnmpPara)protocol))) {
            HashMap<String, SnmpPara> msgMap = new HashMap<String, SnmpPara>();
            msgMap.put(nod.getUuid(), snmpPara0);
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(114L);
            mu.setObj(msgMap);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(((Object)((Object)this)).getClass().getName());
            logger.info((Object)"when modifyManagementProtocol will send COMMAND_SNMP_PARA_CHANGED msg ", 1L);
            this.messageCenter.sendMessage(mu);
        }
    }

    private void updateSnmpVer(Protocol protocol0, IDiscoveryDao discoveryDao1) {
        logger.trace((Object)"updateSnmpVer");
        this.dsiUtil.updateSnmpVer(protocol0, discoveryDao1);
    }

    public synchronized void addManagementProtocol(Protocol protocol, Long devId) {
        logger.info((Object)("will add new Protocol, devId is : " + devId), 1L);
        Node dev = (Node)this.discoveryDao.get(Node.class, devId);
        if (dev == null) {
            logger.warn((Object)("the device does not exist, devId is : " + devId), 1L);
            throw new LegoCheckedException(201L);
        }
        Protocol curProtocol = dev.getManagementProtocol(protocol.getClass().getName());
        if (curProtocol != null) {
            logger.warn((Object)("the protocl exist, protocol is : " + curProtocol), 1L);
            throw new LegoCheckedException(1036L);
        }
        protocol.setNode(dev);
        this.discoveryDao.saveOrUpdate(protocol);
    }

    public Map<String, String> getManagementProtocolPageUrlMap() {
        return this.managementProtocolPageUrlMap;
    }

    public int getMaxImportedRow() {
        String maxImportedRow = PropertyUtil.getMaxImportedRow();
        logger.info((Object)("maxImportedRow is : " + maxImportedRow), 1L);
        return NumberUtil.convertToInteger((Object)maxImportedRow);
    }

    public synchronized void lockDeviceBeforeRefresh(Long moId) {
        logger.trace((Object)"lockDeviceBeforeRefresh");
        this.lockedDeviceWhenRefresh.add(moId);
    }

    public synchronized void unlockDeviceAfterRefresh(Long moId) {
        logger.trace((Object)"unlockDeviceAfterRefresh");
        this.lockedDeviceWhenRefresh.remove(moId);
    }

    public synchronized boolean isDeviceCanRefresh(Long moId) {
        logger.trace((Object)"isDeviceCanRefresh");
        return !this.lockedDeviceWhenDelete.contains(moId);
    }

    public synchronized void checkIfHasDiscovered(DiscoveryPolicy discoveryPolicy, String deviceUuid) {
        logger.trace((Object)"checkIfHasDiscovered");
        this.dsiUtil.checkIfHasDiscovered(this.cacheService, discoveryPolicy, deviceUuid);
    }

    public synchronized List<String> getUniqueDiscoveryLocation() {
        logger.trace((Object)"getUniqueDiscoveryLocation");
        return this.discoveryDao.getUniqueDiscoveryLocation();
    }

    private String decode(String encodedChar) {
        if (null == encodedChar) {
            logger.trace((Object)"decode:encodedChar is null");
            return "";
        }
        return encodedChar.replaceAll("&quot;", "\"").replaceAll("&#39;", "'").replaceAll("&#96;", "`").replaceAll("&#37;", "%").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&#40;", "\\(").replaceAll("&#41;", "\\)").replaceAll("&#58;", ":").replaceAll("&#46;", ".");
    }

    public synchronized void lockDeviceBeforeDelete(Long moId) {
        logger.trace((Object)"lockDeviceBeforeDelete");
        this.lockedDeviceWhenDelete.add(moId);
    }

    public synchronized void unlockDeviceAfterDelete(Long moId) {
        logger.trace((Object)"unlockDeviceAfterDelete");
        this.lockedDeviceWhenDelete.remove(moId);
    }

    public void lockDeviceBeforeSyncAlarm(Long moId) {
        logger.trace((Object)"lockDeviceBeforeSyncAlarm");
        this.lockedDeviceWhenSyncAlarm.add(moId);
    }

    public void unlockDeviceAfterSyncAlarm(Long moId) {
        logger.trace((Object)"unlockDeviceAfterSyncAlarm");
        this.lockedDeviceWhenSyncAlarm.remove(moId);
    }
}

