/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.service;

import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.com.south.sdk.model.TelnetPara;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.comm.internal.jms.core.MessageCenter;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.model.SnmpSyncParamInfo;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.model.SnmpSynchronizeParameter;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.util.SnmpSynchronizeUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryResult;
import com.huawei.lego.nem.discover.sdk.model.ImportedDiscoveryItem;
import com.huawei.lego.nem.discover.service.AbstractDiscoveryThread;
import com.huawei.lego.nem.discover.util.DiscoveryUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ImportDiscoveryThread
extends AbstractDiscoveryThread {
    private static final int VALUE_2 = 2;
    private static final int VALUE_2000 = 2000;
    private static final int VALUE_1000 = 1000;
    private static final Log LOGGER = LogFactory.getInstance(ImportDiscoveryThread.class);
    private Map<String, Long> ipDiscoveryResultIdMap = null;
    private List<ImportedDiscoveryItem> importedItemList = null;

    public ImportDiscoveryThread(DiscoveryPolicy policy) {
        super(policy);
    }

    public ImportDiscoveryThread(DiscoveryPolicy policy, List<ImportedDiscoveryItem> itemList, Map<String, Long> ipDiscoveryResultIdMap) {
        this(policy);
        this.importedItemList = itemList;
        this.ipDiscoveryResultIdMap = ipDiscoveryResultIdMap;
    }

    private void dealExcepthionWhenDiscover(String ip, Throwable e) {
        LOGGER.error((Object)("exception when import excel discovery" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        DiscoveryResult discoveryResult = new DiscoveryResult();
        String key = super.getPolicy().getDiscoveryPolicyId() + "_" + ip;
        Long discoveryResultId = this.ipDiscoveryResultIdMap.get(key);
        if (discoveryResultId == null) {
            LOGGER.error((Object)("can not find discoveryResultId from ipDiscoveryResult in catch, key is " + key + ", ipDiscoveryResultIdMap is : " + this.ipDiscoveryResultIdMap), 1L);
        }
        discoveryResult.setDiscoveryResultId(discoveryResultId);
        discoveryResult.setDiscoveryPolicy(super.getPolicy());
        discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
        discoveryResult.setIpAddress(ip);
        discoveryResult.setSuccess(Boolean.valueOf(false));
        if (e instanceof LegoCheckedException) {
            LegoCheckedException legoException = (LegoCheckedException)e;
            discoveryResult.setErrorCode(Long.valueOf(legoException.getErrorCode()));
        } else {
            discoveryResult.setErrorCode(Long.valueOf(1053L));
        }
        ServiceProvider.getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
    }

    @Override
    public void run() {
        for (ImportedDiscoveryItem discoveryItem : this.importedItemList) {
            if (super.isCancel()) {
                return;
            }
            String ip = discoveryItem.getIpAddress();
            try {
                this.buildDiscoveryResult(ip, discoveryItem);
            }
            catch (Exception e) {
                this.dealExcepthionWhenDiscover(ip, e);
            }
        }
    }

    private void buildDiscoveryResult(String ip, ImportedDiscoveryItem discoveryItem) {
        boolean icmpPingSuccess = true;
        if (DiscoveryUtil.checkIpDuplicate(ip)) {
            throw new LegoCheckedException(1056L);
        }
        if (super.isIpReachable(ip)) {
            this.checkIpReachable(ip, discoveryItem);
        } else {
            LOGGER.info((Object)("icmp ping failed, ip is : " + ip), 1L);
            DiscoveryResult discoveryResult = new DiscoveryResult();
            String key = super.getPolicy().getDiscoveryPolicyId() + "_" + ip;
            Long discoveryResultId = this.ipDiscoveryResultIdMap.get(key);
            if (discoveryResultId == null) {
                LOGGER.error((Object)("can not find discoveryResultId from ipDiscoveryResultMap, key is " + key + ", ipDiscoveryResultIdMap is : " + this.ipDiscoveryResultIdMap), 1L);
            }
            discoveryResult.setDiscoveryResultId(discoveryResultId);
            discoveryResult.setDiscoveryPolicy(super.getPolicy());
            discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
            discoveryResult.setIpAddress(ip);
            discoveryResult.setSuccess(Boolean.valueOf(false));
            discoveryResult.setErrorCode(Long.valueOf(1051L));
            icmpPingSuccess = false;
            ServiceProvider.getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, icmpPingSuccess);
        }
        CommonUtil.sleep((long)1000L);
    }

    private void checkIpReachable(String ip, ImportedDiscoveryItem discoveryItem) {
        if (ServiceProvider.getResourceService().snmpReadTest(ip, super.getPolicy().getSnmpPara())) {
            String[] targetOidArray = new String[]{".1.3.6.1.2.1.1.1", ".1.3.6.1.2.1.1.2", ".1.3.6.1.2.1.1.5"};
            SnmpSyncParamInfo param = new SnmpSyncParamInfo();
            param.setReferredAReferingOid(new String[]{null, null});
            param.setTargetOidList(null);
            SnmpSynchronizeParameter snmpSynchronizeParameter = new SnmpSynchronizeParameter(new String[]{ip, null}, super.getPolicy().getManagementProtocolMap(), new String[]{null, null, null, null}, null, null, param);
            List resultStringArrayList = SnmpSynchronizeUtil.getMibValueFromAgent(Arrays.asList(targetOidArray), (SnmpSynchronizeParameter)snmpSynchronizeParameter);
            if (resultStringArrayList == null || resultStringArrayList.isEmpty()) {
                LOGGER.warn((Object)("can not get system info from mib in import discovery, snmpSynchronizeParameter is : " + snmpSynchronizeParameter), 1L);
                throw new LegoCheckedException(1052L);
            }
            DiscoveryPolicy policy = super.getPolicy();
            String[] resultStringArray = (String[])resultStringArrayList.get(0);
            if (resultStringArray.length < 3) {
                return;
            }
            Node node = this.getNode(ip, discoveryItem, policy, resultStringArray);
            this.configSnmpPara(policy);
            this.configTelnetPara(policy);
            this.sendMessage(policy, node);
            CommonUtil.sleep((long)2000L);
        }
    }

    private Node getNode(String ip, ImportedDiscoveryItem discoveryItem, DiscoveryPolicy policy, String[] resultStringArray) {
        String sysDesc = resultStringArray[0];
        String sysObjectID = resultStringArray[1];
        String sysName = resultStringArray[2];
        Node node = new Node();
        node.setIpAddress(ip);
        node.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
        node.setSysDescr(sysDesc);
        node.setSysName(sysName);
        node.setName(discoveryItem.getDeviceName());
        node.addManagementProtocol(SnmpPara.class.getName(), (Protocol)policy.getSnmpPara());
        node.addManagementProtocol(TelnetPara.class.getName(), (Protocol)policy.getTelnetPara());
        sysObjectID = this.getSysobjectID(sysObjectID);
        node.setSysOid(sysObjectID);
        node.setLocation(policy.getLocation());
        return node;
    }

    private void configSnmpPara(DiscoveryPolicy policy) {
        SnmpPara snmpPara = policy.getSnmpPara();
        snmpPara.setTemplateName(UUID.randomUUID().toString());
        snmpPara.setDiscoveryPolicy(null);
        snmpPara.setId(null);
        snmpPara.setIsTemplate(Boolean.valueOf(false));
        snmpPara.setIsManagementProtocol(Boolean.valueOf(true));
    }

    private void configTelnetPara(DiscoveryPolicy policy) {
        TelnetPara telnetPara = policy.getTelnetPara();
        if (telnetPara != null) {
            telnetPara.setTemplateName(UUID.randomUUID().toString());
            telnetPara.setDiscoveryPolicy(null);
            telnetPara.setId(null);
            telnetPara.setIsTemplate(Boolean.valueOf(false));
            telnetPara.setIsManagementProtocol(Boolean.valueOf(true));
        }
    }

    private void sendMessage(DiscoveryPolicy policy, Node node) {
        HashMap<String, Object> messageBody = new HashMap<String, Object>();
        messageBody.put("snmpDiscoveredNode", node);
        messageBody.put("discoveryPolicy", policy);
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(101L);
        mu.setObj(messageBody);
        mu.setMt(MessageTopic.COMMAND);
        mu.setSourceAppName(this.getClass().getName());
        MessageCenter.getInstance().sendMessage(mu);
    }

    private String getSysobjectID(String sysObjectID) {
        if (sysObjectID != null && sysObjectID.contains(".iso.org.dod.internet.private.enterprises")) {
            sysObjectID = sysObjectID.replace(".iso.org.dod.internet.private.enterprises", ".1.3.6.1.4.1");
            LOGGER.info((Object)("converted sysObjectID is : " + sysObjectID), 1L);
        }
        return sysObjectID;
    }

    public Map<String, Long> getIpDiscoveryResultIdMap() {
        return this.ipDiscoveryResultIdMap;
    }
}

