/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.service;

import com.huawei.lego.cbb.resource.sdk.service.IProductDiscoveryService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProductDiscoveryServiceContainer {
    private static final Log logger = LogFactory.getInstance(ProductDiscoveryServiceContainer.class);
    private static List<IProductDiscoveryService> productDisServiceList = new ArrayList<IProductDiscoveryService>();

    public static DiscoveryPolicy disSavePro(DiscoveryPolicy dp) {
        if (null == productDisServiceList || productDisServiceList.isEmpty()) {
            return dp;
        }
        for (IProductDiscoveryService service : productDisServiceList) {
            dp = service.discoveryPolicySavePro(dp);
        }
        return dp;
    }

    public void onBind(IProductDiscoveryService service, Map<String, String> properties) {
        if (null != service) {
            productDisServiceList.add(service);
            logger.info((Object)("onBind:" + service.toString()), 1L);
        } else {
            logger.info((Object)"onBind,service is null.", 1L);
        }
    }

    public void onUnbind(IProductDiscoveryService service, Map<String, String> properties) {
        if (null != service) {
            productDisServiceList.remove(service);
            logger.info((Object)("onUnbind:" + service.toString()), 1L);
        } else {
            logger.info((Object)"onUnbind,service is null.", 1L);
        }
    }

    public static List<IProductDiscoveryService> getProductDisServiceList() {
        return productDisServiceList;
    }

    public static void setProductDisServiceList(List<IProductDiscoveryService> productDisServiceList) {
        ProductDiscoveryServiceContainer.productDisServiceList = productDisServiceList;
    }
}

