/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.util;

import com.huawei.lego.cbb.resource.service.CommonServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import org.springframework.util.StringUtils;

public class DiscoveryUtil {
    private static final int VALUE_65535 = 65535;
    private static final Log LOGGER = LogFactory.getInstance(DiscoveryUtil.class);
    private static final int CONNECT_TIMOUT = 3000;
    private static final int CONNECT_TIMOUT_THRESHOLD = 30000;
    private static final String KEY_CONNECT_TIMOUT = "disc.socket.connect.timeout";

    public static String getSysOidByDeviceType(String deviceMainType, String deviceSubType) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select dt.sysoid from T_device_type dt, T_device_type_relation dtr where ").append(" dt.tid = dtr.tid and dtr.parent_type = '").append(deviceMainType).append("'");
        if (StringUtils.hasText((String)deviceSubType)) {
            sqlBuilder.append(" and dtr.child_type = '").append(deviceSubType).append("'");
        }
        List sysoidList = ServiceProvider.getCommonService().findBySql(sqlBuilder.toString());
        String sysoid = "";
        if (sysoidList != null && !sysoidList.isEmpty()) {
            LOGGER.info((Object)("query result sysoidList is : " + sysoidList), 1L);
            sysoid = (String)sysoidList.get(0);
        } else {
            LOGGER.info((Object)"query result sysoidList is : null or empty", 1L);
        }
        return sysoid;
    }

    public static boolean checkIpDuplicate(String ip) {
        StringBuffer hql = new StringBuffer();
        hql.append("select count(node.moId) from Node node where node.ipAddress = ?");
        hql.append(" and (node.description is null or node.description <> 'manual')");
        CommonServiceImpl serviceImpl = (CommonServiceImpl)ServiceProvider.getCommonService();
        long count = (Long)serviceImpl.getCommonDao().getBaseHibernateTemplate().find(hql.toString(), (Object[])new String[]{ip}).listIterator().next();
        LOGGER.info((Object)("The ip is : " + ip + ", count is : " + count), 1L);
        return count != 0L;
    }

    public static boolean isSocketreachable(DiscoveryPolicy policy, String host) {
        String[] splits;
        String deviceType = policy.getDeviceType();
        String port = (String)policy.getParamMap().get("port");
        Boolean disablePing = Boolean.valueOf((String)policy.getParamMap().get("disablePing"));
        if (disablePing.booleanValue()) {
            LOGGER.info((Object)("Disable ping, deviceType=" + deviceType + ", host=" + host + ", port=" + port));
            return true;
        }
        if (null != port && !port.trim().isEmpty()) {
            return DiscoveryUtil.isSocketreachable(host, port);
        }
        String types = LegoProperties.getProperty((String)"disc.socket.test.deviceType", (String)"");
        if (!types.contains(deviceType)) {
            LOGGER.error((Object)("Device type is not configured for auto ping, deviceType=" + deviceType), 1L);
            return false;
        }
        String portStr = LegoProperties.getProperty((String)"disc.socket.test.ports", (String)"");
        if (portStr.trim().isEmpty()) {
            LOGGER.error((Object)"The auto ping ports config is empty", 1L);
            return false;
        }
        for (String split : splits = portStr.split(",")) {
            if (!DiscoveryUtil.isSocketreachable(host, split)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSocketreachable(String host, String portStr) {
        int port = DiscoveryUtil.getPort(portStr);
        int timeout = 3000;
        if (port < 0) {
            LOGGER.error((Object)("error port: " + portStr), 1L);
            return false;
        }
        timeout = DiscoveryUtil.getTimeout(timeout);
        Socket st = null;
        try {
            InetSocketAddress sa = new InetSocketAddress(host, port);
            st = new Socket();
            st.connect(sa, timeout);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Socket ping failed, ip=" + host + ", port=" + port + ", errMsg=" + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
            boolean bl = false;
            return bl;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Socket ping failed, ip=" + host + ", port=" + port + ", errMsg=" + e.getMessage()), 1L);
                }
            }
        }
        return true;
    }

    private static int getPort(String portStr) {
        try {
            int port = Integer.parseInt(portStr);
            if (port > 65535 || port < 0) {
                return -1;
            }
            return port;
        }
        catch (NumberFormatException nex) {
            LOGGER.error((Object)("the port format error: " + portStr), 1L);
            return -1;
        }
    }

    private static int getTimeout(int timeout) {
        String timeoutStr = LegoProperties.getProperty((String)KEY_CONNECT_TIMOUT, (String)String.valueOf(3000));
        try {
            timeout = Integer.parseInt(timeoutStr);
            if (timeout > 30000) {
                timeout = 30000;
            }
        }
        catch (NumberFormatException nex) {
            LOGGER.error((Object)("the timeout format error:" + timeoutStr), (Throwable)nex, 1L);
        }
        return timeout;
    }
}

