/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.backup;

import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.file.util.FileZip;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.DateFormatUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.nem.fault.backup.BackupUtil;
import com.huawei.lego.nem.fault.product.EventBackUpServiceContainer;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.service.IFaultBackupService;
import com.huawei.lego.nem.syslog.sdk.service.ISyslogBackupService;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Service(Name="faultBackupService", Desc="", Interface=IFaultBackupService.class)
public class FaultBackupServiceImpl
extends BaseService
implements IFaultBackupService {
    private static final int VALUE_2 = 2;
    private static final int MAX_NUM = 5000;
    private static final int MAX_STORAGE_NUM = 200000;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-ms");
    private BackupUtil backUtil;
    private Log logger = LogFactory.getInstance(FaultBackupServiceImpl.class);

    public String transferAlarm(String fileType, long endTime, String lang, String filePath) {
        return this.transferAlarm(fileType, endTime, lang, filePath, true);
    }

    public String transferAlarm(String fileType, long endTime, String lang, String filePath, boolean isAutoTransfer) {
        int exportNum;
        int totalNum;
        Date endDate = new Date(endTime);
        this.logger.info((Object)("start to backup alarm, endTime: " + endDate + ", time value: " + endTime), 1L);
        int eventNum = 0;
        if (filePath.contains("currentAlarm")) {
            exportNum = totalNum = this.backUtil.getCurrentAlarmCount(Alarm.class);
        } else {
            exportNum = totalNum = this.backUtil.getTotalCount(Alarm.class, endTime);
            eventNum = this.backUtil.getTotalCount(Event.class, endTime);
            exportNum += eventNum;
        }
        if (isAutoTransfer) {
            return this.autoTransfer(fileType, endTime, lang, filePath, totalNum, exportNum);
        }
        String[] tranInfo = new String[]{fileType, lang, filePath};
        return this.transferOverfullAlarm(tranInfo, endTime, totalNum, eventNum, exportNum);
    }

    private String transferOverfullAlarm(String[] tranInfo, long endTime, int totalNum, int eventNum, int exportNum) {
        String fileType = tranInfo[0];
        String lang = tranInfo[1];
        String filePath = tranInfo[2];
        if (exportNum > 200000) {
            Date date = new Date();
            String tempfileName = DateFormatUtil.format((DateFormat)this.dateFormat, (Date)date);
            tempfileName = tempfileName + "transfer";
            String currentPath = LegoProperties.getStorageFilePath();
            File datastorage = new File(currentPath + File.separator + "datastorage");
            this.mkdir(datastorage, true);
            currentPath = currentPath + filePath;
            File file = new File(currentPath);
            this.mkdir(file, true);
            File tempFileDir = new File(currentPath + File.separator + tempfileName);
            this.mkdir(tempFileDir, false);
            int overfullNum = exportNum - 200000;
            if (0 != eventNum) {
                if (overfullNum >= eventNum) {
                    this.transferEvent(fileType, endTime, lang, filePath, tempFileDir);
                } else {
                    this.transferEvent(fileType, endTime, lang, tempFileDir, eventNum - overfullNum);
                }
            }
            if ((overfullNum -= eventNum) <= 0) {
                this.compressFileAndOptLog(endTime, exportNum, tempfileName, currentPath, tempFileDir);
                return tempfileName + ".zip";
            }
            if (0 != totalNum) {
                if (overfullNum >= totalNum) {
                    this.transAlarm(fileType, endTime, lang, totalNum, tempFileDir);
                } else {
                    this.transAlarm(fileType, endTime, lang, overfullNum, tempFileDir);
                }
            }
            this.compressFileAndOptLog(endTime, exportNum, tempfileName, currentPath, tempFileDir);
            return tempfileName + ".zip";
        }
        return "";
    }

    private void transAlarm(String fileType, long endTime, String lang, int totalNum, File tempFileDir) {
        Date date = new Date();
        String tempfileName = DateFormatUtil.format((DateFormat)this.dateFormat, (Date)date);
        int count = totalNum / 5000;
        if (0 != totalNum % 5000) {
            ++count;
        }
        if (totalNum > 5000) {
            for (int ii = 0; ii < count; ++ii) {
                try {
                    CommonUtil.sleep((long)100L);
                    List<Alarm> alarmLists = this.backUtil.queryFaults(Alarm.class, endTime, "modTime", false, 0, 5000);
                    this.exportFaultData(fileType, lang, tempfileName, tempFileDir, ii, alarmLists);
                    this.backUtil.deleteFaults(Alarm.class, alarmLists);
                    continue;
                }
                catch (Exception ex) {
                    this.logger.error((Object)("" + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
                }
            }
        } else {
            try {
                CommonUtil.sleep((long)100L);
                List<Alarm> alarmListx = this.backUtil.queryFaults(Alarm.class, endTime, "modTime", false, 0, 5000);
                this.exportFaultData(fileType, lang, tempfileName, tempFileDir, 0, alarmListx);
                this.backUtil.deleteFaults(Alarm.class, alarmListx);
            }
            catch (Exception ex) {
                this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex), 1L);
            }
        }
    }

    private String autoTransfer(String fileType, long endTime, String lang, String filePath, int totalNum, int exportNum) {
        int count = totalNum / 5000;
        if (0 != totalNum % 5000) {
            ++count;
        }
        Date date = new Date();
        String tempfileName = DateFormatUtil.format((DateFormat)this.dateFormat, (Date)date);
        String currentPath = LegoProperties.getStorageFilePath();
        File datastorage = new File(currentPath + File.separator + "datastorage");
        this.mkdir(datastorage, true);
        currentPath = currentPath + filePath;
        File file = new File(currentPath);
        this.mkdir(file, true);
        File tempFileDir = null;
        if (filePath.contains("currentAlarm")) {
            tempfileName = "currentAlarm";
            tempFileDir = file;
        } else {
            tempFileDir = new File(currentPath + File.separator + tempfileName);
            this.mkdir(tempFileDir, false);
        }
        if (totalNum > 5000) {
            for (int i = 0; i < count; ++i) {
                try {
                    if (filePath.contains("currentAlarm")) {
                        this.exportCurrenAlarm(fileType, lang, tempfileName, tempFileDir, i);
                        continue;
                    }
                    CommonUtil.sleep((long)100L);
                    List<Alarm> alarmList = null;
                    alarmList = this.backUtil.queryFaults(Alarm.class, endTime, "modTime", false, 0, 5000);
                    this.exportFaultData(fileType, lang, tempfileName, tempFileDir, i, alarmList);
                    this.backUtil.deleteFaults(Alarm.class, alarmList);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
                }
            }
        } else {
            try {
                if (filePath.contains("currentAlarm")) {
                    this.exportCurrenAlarm(fileType, lang, tempfileName, tempFileDir, 0);
                }
                this.exportHistoryAlarm(fileType, endTime, lang, tempfileName, tempFileDir);
            }
            catch (Exception e) {
                this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            }
        }
        if (filePath.contains("currentAlarm")) {
            return tempfileName;
        }
        this.eventBackup(fileType, endTime, lang, filePath, tempFileDir);
        this.compressFileAndOptLog(endTime, exportNum, tempfileName, currentPath, tempFileDir);
        return tempfileName + ".zip";
    }

    private void exportHistoryAlarm(String fileType, long endTime, String lang, String tempfileName, File tempFileDir) {
        List<Alarm> alarmListcv = null;
        CommonUtil.sleep((long)100L);
        alarmListcv = this.backUtil.queryFaults(Alarm.class, endTime, "modTime", false, 0, 5000);
        this.exportFaultData(fileType, lang, tempfileName, tempFileDir, 0, alarmListcv);
        this.backUtil.deleteFaults(Alarm.class, alarmListcv);
    }

    private void eventBackup(String fileType, long endTime, String lang, String filePath, File tempFileDir) {
        if (EventBackUpServiceContainer.isEventBackUp()) {
            this.transferEvent(fileType, endTime, lang, filePath, tempFileDir);
            this.transferSyslog(fileType, endTime, lang, filePath, tempFileDir);
        }
    }

    private void exportCurrenAlarm(String fileType, String lang, String tempfileName, File tempFileDir, int i) {
        List<Alarm> alarmList = this.backUtil.queryCurrentAlarms(Alarm.class, "modTime", false, 0, 5000);
        this.exportFaultData(fileType, lang, tempfileName, tempFileDir, i, alarmList);
    }

    private void exportFaultData(String fileType, String lang, String tempfileName, File tempFileDir, int i, List<Alarm> alarmList) {
        String[] fileInfo = new String[]{fileType, lang, tempfileName};
        this.backUtil.exportFaultData(alarmList, fileInfo, 1, tempFileDir, i);
    }

    private void compressFileAndOptLog(long endTime, int exportNum, String tempfileName, String currentPath, File tempFileDir) {
        try {
            CommonUtil.sleep((long)100L);
            this.logger.info((Object)"[FaultBackupServiceImpl] begin to start compressfile.", 1L);
            FileZip.zip((String)(currentPath + File.separator + tempfileName), (String)(currentPath + File.separator + tempfileName + ".zip"), (String)tempfileName);
            FileZip.deleteFile((File)tempFileDir);
        }
        catch (Exception e) {
            this.logger.error((Object)"zip file error", 1L);
        }
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setDate(new Date());
        oOptLog.setDetail("lego.ver.storage.event");
        oOptLog.setLevel(1);
        oOptLog.setModule("lego.dic.module.system");
        oOptLog.setOperation("lego.lab.storage.event");
        oOptLog.setResult(1);
        oOptLog.setOperator("system");
        oOptLog.setTerminalIp("127.0.0.1");
        Date da = new Date(endTime);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dt = df.format(da);
        String filePathTemp = currentPath + File.separator + tempfileName + ".zip";
        filePathTemp = filePathTemp.replace("\\", File.separator);
        String[] para = new String[]{dt, String.valueOf(exportNum), filePathTemp};
        oOptLog.setDetailPara(para);
        oOptLog.setOperator("system");
        this.logger.info((Object)"fault back up success.", 1L);
    }

    private void transferSyslog(String fileType, long endTime, String lang, String filePath, File tempFileDir) {
        try {
            ISyslogBackupService backupSrv = (ISyslogBackupService)ServiceContext.getInstance().lookup("syslog/syslogBackupService");
            if (null != backupSrv) {
                backupSrv.transferSyslog(fileType, endTime, lang, filePath, tempFileDir);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("transferSyslog failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    private void mkdir(File file, boolean checkDirectory) {
        boolean result = false;
        if (checkDirectory) {
            if (!file.isDirectory()) {
                result = file.mkdir();
            }
        } else {
            result = file.mkdir();
        }
        if (!result) {
            this.logger.error((Object)"mkdir failed.", 1L);
        }
    }

    private void transferEvent(String fileType, long endTime, String lang, File tempFileDir, int firstRowNum) {
        this.logger.info((Object)("start to backup event, endTime: " + new Date(endTime) + ", time value: " + endTime), 1L);
        int totalNum = this.backUtil.getTotalCount(Event.class, endTime);
        int count = totalNum / 5000;
        if (0 != totalNum % 5000) {
            ++count;
        }
        Date date = new Date();
        String tempfileName = DateFormatUtil.format((DateFormat)this.dateFormat, (Date)date);
        if (totalNum > 5000) {
            for (int i = 0; i < count; ++i) {
                try {
                    CommonUtil.sleep((long)100L);
                    List<Event> eventList = this.backUtil.queryFaults(Event.class, endTime, "time", false, firstRowNum, 5000);
                    String[] fileInfo = new String[]{fileType, lang, tempfileName};
                    this.backUtil.exportFaultData(eventList, fileInfo, 2, tempFileDir, i);
                    this.backUtil.deleteFaults(Event.class, eventList);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
                }
            }
        } else {
            try {
                List<Event> eventListxv = this.backUtil.queryFaults(Event.class, endTime, "time", false, firstRowNum, 5000);
                String[] fileInfo = new String[]{fileType, lang, tempfileName};
                this.backUtil.exportFaultData(eventListxv, fileInfo, 2, tempFileDir, 0);
                this.backUtil.deleteFaults(Event.class, eventListxv);
            }
            catch (Exception e) {
                this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            }
        }
    }

    public void transferEvent(String fileType, long endTime, String lang, String filePath, File tempFileDir) {
        this.transferEvent(fileType, endTime, lang, tempFileDir, 0);
    }

    public BackupUtil getBackUtil() {
        return this.backUtil;
    }

    public void setBackUtil(BackupUtil backUtil) {
        this.backUtil = backUtil;
    }
}

