/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.dao.impl;

import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.dao.IAlertExperienceDAO;
import com.huawei.lego.nem.fault.sdk.model.AlertExperience;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class AlertExperienceDAOImpl
extends HibernateDaoSupportWrapper
implements IAlertExperienceDAO {
    private static final String QUERY_SQL = "from AlertExperience where alertId = ";
    private static final String COUNT_SQL = "select count(*) from AlertExperience where alertId = ";
    private static final String TOTAL_COUNT_SQL = "select count(*) from AlertExperience";
    private Log logger = LogFactory.getInstance(AlertExperienceDAOImpl.class);

    @Override
    public Long addAlertExperience(AlertExperience alertExperience) {
        try {
            return (Long)super.getHibernateTemplate().save((Object)alertExperience);
        }
        catch (DataAccessException e) {
            throw new LegoCheckedException(101L, (Throwable)e);
        }
    }

    @Override
    public AlertExperience deleteAlertExperience(long id) {
        try {
            AlertExperience alertExperience = (AlertExperience)super.getHibernateTemplate().get(AlertExperience.class.getName(), (Serializable)Long.valueOf(id));
            if (null == alertExperience) {
                throw new LegoCheckedException(1539L);
            }
            super.getHibernateTemplate().delete((Object)alertExperience);
            return alertExperience;
        }
        catch (DataAccessException e) {
            throw new LegoCheckedException(101L, (Throwable)e);
        }
    }

    @Override
    public boolean deleteAlertExperience(AlertExperience alertExperience) {
        try {
            super.getHibernateTemplate().delete((Object)alertExperience);
            return true;
        }
        catch (DataAccessException e) {
            throw new LegoCheckedException(101L, (Throwable)e);
        }
    }

    @Override
    public List<AlertExperience> deleteAlertExperiences(String alertId) {
        List<AlertExperience> alertExperienceList = null;
        try {
            alertExperienceList = this.getAlertExperiences(alertId);
            if (null != alertExperienceList) {
                super.getHibernateTemplate().deleteAll(alertExperienceList);
            }
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"", (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return alertExperienceList;
    }

    @Override
    public AlertExperience getAlertExperience(long id) {
        try {
            AlertExperience alertExperience = (AlertExperience)super.getHibernateTemplate().get(AlertExperience.class, (Serializable)Long.valueOf(id));
            if (null == alertExperience) {
                throw new LegoCheckedException(1539L);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            alertExperience.setTimeStr(sdf.format(new Date(alertExperience.getTime())));
            return alertExperience;
        }
        catch (DataAccessException e) {
            throw new LegoCheckedException(101L, (Throwable)e);
        }
    }

    @Override
    public List<AlertExperience> getAlertExperiences(String alertId) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(QUERY_SQL);
            sb.append("? order by time desc");
            List alertExperienceList = super.getHibernateTemplate().find(sb.toString(), new Object[]{alertId});
            for (AlertExperience alertExperience : alertExperienceList) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                alertExperience.setTimeStr(sdf.format(new Date(alertExperience.getTime())));
            }
            return alertExperienceList;
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"", (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        catch (Exception ex) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex), 1L);
            return null;
        }
    }

    @Override
    public long getCountByAlertID(String alertId) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(COUNT_SQL);
            sb.append("?");
            List list = super.getHibernateTemplate().find(sb.toString(), new Object[]{alertId});
            return (Long)list.get(0);
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            return 0L;
        }
    }

    @Override
    public long getTotalCount() {
        try {
            List list = super.getHibernateTemplate().find(TOTAL_COUNT_SQL, new Object[0]);
            return (Long)list.get(0);
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            return 0L;
        }
    }

    @Override
    public boolean modifyAlertExperience(long id, String userName, String experience) {
        try {
            AlertExperience alertExperience = this.getAlertExperience(id);
            if (alertExperience == null) {
                throw new LegoCheckedException(1539L);
            }
            alertExperience.setExperience(experience);
            alertExperience.setUserName(userName);
            alertExperience.setTime(new Date().getTime());
            super.getHibernateTemplate().update((Object)alertExperience);
            return true;
        }
        catch (DataAccessException e) {
            throw new LegoCheckedException(101L, (Throwable)e);
        }
    }
}

