/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.dao.impl;

import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.dao.IFaultDao;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.service.FaultQueryInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;

public final class FaultDaoImpl
extends HibernateDaoSupportWrapper
implements IFaultDao {
    private static final int VALUE_1000 = 1000;
    private static final int MAX_SIZE_BATCH = 100;
    private static Object lockObject = new Object();
    private static Log logger = LogFactory.getInstance(FaultDaoImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> queryFaults(Class<?> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard, FaultQueryInfo queryInfo) {
        int firstRowIndex = queryInfo.getFirstRowIndex();
        int totalRow = queryInfo.getTotalRow();
        String orderByField = queryInfo.getOrderByField();
        boolean orderByAscend = queryInfo.isOrderByAscend();
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(faultType);
            this.setPage(firstRowIndex, totalRow, criteria);
            this.processDefaultOrder(orderByField, orderByAscend, criteria);
            this.processIndexOrder(faultType, orderByField, orderByAscend, criteria);
            if (null == condition) {
                criteria.setLockMode(LockMode.NONE);
                List list = criteria.list();
                return list;
            }
            List<?> list = this.getFaults(faultType, condition, isFaultNameNeedWildcard, criteria);
            return list;
        }
        catch (Exception e) {
            logger.error((Object)("queryFaults exception, query condition is : " + condition + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    private <T> void processIndexOrder(Class<T> faultType, String orderByField, boolean orderByAscend, Criteria criteria) {
        if (!"id".equals(orderByField) && Annotation.class.getSimpleName().equals(faultType.getSimpleName())) {
            this.extracted(orderByAscend, criteria);
        } else if (!"entity".equals(orderByField) && Alarm.class.getSimpleName().equals(faultType.getSimpleName())) {
            if (orderByAscend) {
                criteria.addOrder(Order.asc((String)"entity"));
            } else {
                criteria.addOrder(Order.desc((String)"entity"));
            }
        } else if (!"id".equals(orderByField) && Event.class.getSimpleName().equals(faultType.getSimpleName())) {
            this.extracted(orderByAscend, criteria);
        }
    }

    private void extracted(boolean orderByAscend, Criteria criteria) {
        if (orderByAscend) {
            criteria.addOrder(Order.asc((String)"id"));
        } else {
            criteria.addOrder(Order.desc((String)"id"));
        }
    }

    private void processDefaultOrder(String orderByField, boolean orderByAscend, Criteria criteria) {
        if (orderByAscend) {
            criteria.addOrder(Order.asc((String)orderByField));
        } else {
            criteria.addOrder(Order.desc((String)orderByField));
        }
    }

    private void setPage(int firstRowIndex, int totalRow, Criteria criteria) {
        if (firstRowIndex >= 0) {
            criteria.setFirstResult(firstRowIndex);
        }
        if (totalRow >= 0) {
            criteria.setMaxResults(totalRow);
        }
    }

    private <T> List<T> getFaults(Class<T> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard, Criteria criteria) {
        String nmsIp;
        String projectId;
        String moName = condition.get("moName");
        if (this.isNotNullAndNotEmpty(moName)) {
            String convertStr = ConverterUtil.convertString(moName.trim(), true);
            criteria.add(Restrictions.ilike((String)"moName", (Object)convertStr));
        }
        if (!VerifyUtil.isEmpty((String)(projectId = condition.get("project_id")))) {
            criteria.add((Criterion)Restrictions.eq((String)"projectId", (Object)projectId));
        }
        this.getDetailCondition(faultType, condition, criteria);
        String loc = condition.get("location");
        if (this.isNotNullAndNotEmpty(loc)) {
            criteria.add(this.getConbyLoc(loc));
        }
        if (this.isNotNullAndNotEmpty(nmsIp = condition.get("nmsIp"))) {
            criteria.add((Criterion)Restrictions.eq((String)"nmsIp", (Object)nmsIp));
        }
        if (Alarm.class.getSimpleName().equals(faultType.getSimpleName())) {
            this.processAlarm(condition, isFaultNameNeedWildcard, criteria);
        } else {
            this.processEvent(condition, isFaultNameNeedWildcard, criteria);
        }
        criteria.setLockMode(LockMode.NONE);
        return criteria.list();
    }

    private <T> void getDetailCondition(Class<T> faultType, Map<String, String> condition, Criteria criteria) {
        if (Annotation.class.getSimpleName().equals(faultType.getSimpleName())) {
            String entity = condition.get("entity");
            if (this.isNotNullAndNotEmpty(entity)) {
                criteria.add((Criterion)Restrictions.eq((String)"entity", (Object)entity));
            }
        } else {
            String source = condition.get("source");
            if (this.isNotNullAndNotEmpty(source)) {
                this.dealSource(source, criteria);
            }
        }
    }

    private void dealSource(String source, Criteria criteria) {
        if (source.contains(",")) {
            String[] moIdStrs = source.split(",");
            Object[] moIds = new Long[moIdStrs.length];
            for (int i = 0; i < moIdStrs.length; ++i) {
                try {
                    moIds[i] = Long.parseLong(moIdStrs[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)("Moid is not number, moid is " + moIdStrs[i]), 1L);
                }
            }
            criteria.add(Restrictions.in((String)"moId", (Object[])moIds));
        } else {
            try {
                criteria.add((Criterion)Restrictions.eq((String)"moId", (Object)Long.parseLong(source)));
            }
            catch (NumberFormatException ex) {
                logger.error((Object)("Source is not number, souce is " + source), 1L);
            }
        }
    }

    private <T> void getFaultsCount(Class<T> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String projectId;
        String moNames = condition.get("moName");
        if (this.isNotNullAndNotEmpty(moNames)) {
            String convertStrs = ConverterUtil.convertString(moNames.trim(), true);
            hqlBuffer.append(" and lower(alarm.moName) like lower(?)");
            param.put(param.size(), convertStrs);
        }
        String simpleName = faultType.getSimpleName();
        this.processAnnotationDetail(hqlBuffer, param, simpleName, condition);
        String locs = condition.get("location");
        this.getHqlByloc(hqlBuffer, locs, param);
        String nmsIps = condition.get("nmsIp");
        if (this.isNotNullAndNotEmpty(nmsIps)) {
            hqlBuffer.append(" and alarm.nmsIp = ?");
            param.put(param.size(), nmsIps);
        }
        if (!VerifyUtil.isEmpty((String)(projectId = condition.get("project_id")))) {
            hqlBuffer.append(" and alarm.projectId = ?");
            param.put(param.size(), projectId);
        }
        if (Alarm.class.getSimpleName().equals(faultType.getSimpleName())) {
            this.processAlarm(condition, isFaultNameNeedWildcard, hqlBuffer, param);
        } else {
            this.processEvent(condition, isFaultNameNeedWildcard, hqlBuffer);
        }
    }

    private void processAnnotationDetail(StringBuffer hqlBuffer, Map<Integer, String> param, String simpleName, Map<String, String> condition) {
        if (Annotation.class.getSimpleName().equals(simpleName)) {
            String entitys = condition.get("entity");
            if (this.isNotNullAndNotEmpty(entitys)) {
                hqlBuffer.append(" and alarm.entity = ?");
                param.put(param.size(), entitys);
            }
        } else {
            String moIds = condition.get("source");
            if (this.isNotNullAndNotEmpty(moIds)) {
                if (moIds.contains(",")) {
                    this.processMoId(hqlBuffer, moIds, param);
                } else {
                    hqlBuffer.append(" and alarm.moId = ?");
                    param.put(param.size(), moIds);
                }
            }
        }
    }

    private void processEvent(Map<String, String> condition, boolean isFaultNameNeedWildcard, Criteria criteria) {
        String eventType;
        String endTime;
        String startTime;
        String eventName = condition.get("eventName");
        if (this.isNotNullAndNotEmpty(eventName)) {
            if (isFaultNameNeedWildcard) {
                String convertStr = ConverterUtil.convertString(eventName, true);
                criteria.add(Restrictions.ilike((String)"eventName", (Object)convertStr));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"eventName", (Object)eventName));
            }
        }
        if (this.isNotNullAndNotEmpty(startTime = condition.get("createTimeStart"))) {
            criteria.add((Criterion)Restrictions.ge((String)"time", (Object)NumberUtil.convertToLong((Object)startTime)));
        }
        if (this.isNotNullAndNotEmpty(endTime = condition.get("createTimeEnd"))) {
            long temp = NumberUtil.convertToLong((Object)endTime) + 1000L;
            criteria.add((Criterion)Restrictions.lt((String)"time", (Object)temp));
        }
        if (this.isNotNullAndNotEmpty(eventType = condition.get("eventType")) && !"0".equalsIgnoreCase(eventType.trim())) {
            criteria.add((Criterion)Restrictions.eq((String)"eventType", (Object)NumberUtil.convertToInteger((Object)eventType)));
        }
    }

    private Criterion getConbyLoc(String loc) {
        String convertStr = ConverterUtil.convertString(loc.trim(), true);
        Criterion cti = Restrictions.ilike((String)"location", (Object)convertStr);
        return cti;
    }

    private void processEvent(Map<String, String> condition, boolean isFaultNameNeedWildcard, StringBuffer hqlBuffer) {
        String eventType;
        String endTime;
        String startTime;
        String eventName = condition.get("eventName");
        if (this.isNotNullAndNotEmpty(eventName)) {
            if (isFaultNameNeedWildcard) {
                String convertStr = ConverterUtil.convertString(eventName, true);
                hqlBuffer.append(" and lower(alarm.eventName) like lower('");
                hqlBuffer.append(convertStr);
                hqlBuffer.append("')");
            } else {
                hqlBuffer.append(" and alarm.eventName = '");
                hqlBuffer.append(eventName);
                hqlBuffer.append('\'');
            }
        }
        if (this.isNotNullAndNotEmpty(startTime = condition.get("createTimeStart"))) {
            hqlBuffer.append(" and alarm.time >= ");
            hqlBuffer.append(NumberUtil.convertToLong((Object)startTime));
        }
        if (this.isNotNullAndNotEmpty(endTime = condition.get("createTimeEnd"))) {
            long temp = NumberUtil.convertToLong((Object)endTime) + 1000L;
            hqlBuffer.append(" and alarm.time < ");
            hqlBuffer.append(temp);
        }
        if (this.isNotNullAndNotEmpty(eventType = condition.get("eventType")) && !"0".equalsIgnoreCase(eventType.trim())) {
            hqlBuffer.append(" and alarm.eventType = '");
            hqlBuffer.append(eventType);
            hqlBuffer.append('\'');
        }
    }

    private void processAlarm(Map<String, String> condition, boolean isFaultNameNeedWildcard, Criteria criteria) {
        String endTime;
        String startTime;
        String alarmName = condition.get("alarmName");
        if (this.isNotNullAndNotEmpty(alarmName)) {
            if (isFaultNameNeedWildcard) {
                String convertStr = ConverterUtil.convertString(alarmName, true);
                criteria.add(Restrictions.ilike((String)"alarmName", (Object)convertStr));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"alarmName", (Object)alarmName));
            }
        }
        if (this.isNotNullAndNotEmpty(startTime = condition.get("createTimeStart"))) {
            criteria.add((Criterion)Restrictions.ge((String)"modTime", (Object)NumberUtil.convertToLong((Object)startTime)));
        }
        if (this.isNotNullAndNotEmpty(endTime = condition.get("createTimeEnd"))) {
            long temp = NumberUtil.convertToLong((Object)endTime) + 1000L;
            criteria.add((Criterion)Restrictions.lt((String)"modTime", (Object)temp));
        }
        this.processAlarm2(condition, criteria);
    }

    private StringBuffer getHqlByloc(StringBuffer hqlBuffer, String loc, Map<Integer, String> param) {
        if (this.isNotNullAndNotEmpty(loc)) {
            String convertStr = ConverterUtil.convertString(loc.trim(), true);
            hqlBuffer.append(" and lower(alarm.location) like lower(?");
            param.put(param.size(), convertStr);
            hqlBuffer.append(')');
        }
        return hqlBuffer;
    }

    private void processAlarm(Map<String, String> condition, boolean isFaultNameNeedWildcard, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String endTimes;
        String startTimes;
        String alarmNames = condition.get("alarmName");
        if (this.isNotNullAndNotEmpty(alarmNames)) {
            if (isFaultNameNeedWildcard) {
                String convertStrs = ConverterUtil.convertString(alarmNames, true);
                hqlBuffer.append(" and lower(alarm.alarmName) like lower(?)");
                param.put(param.size(), convertStrs);
            } else {
                hqlBuffer.append(" and alarm.alarmName = ?");
                param.put(param.size(), alarmNames);
            }
        }
        if (this.isNotNullAndNotEmpty(startTimes = condition.get("createTimeStart"))) {
            hqlBuffer.append(" and alarm.modTime >= ?");
            param.put(param.size(), startTimes);
        }
        if (this.isNotNullAndNotEmpty(endTimes = condition.get("createTimeEnd"))) {
            long temp = NumberUtil.convertToLong((Object)endTimes) + 1000L;
            hqlBuffer.append(" and alarm.modTime < ?");
            param.put(param.size(), String.valueOf(temp));
        }
        this.processAlarm2(condition, hqlBuffer, param);
    }

    private void processAlarm2(Map<String, String> condition, Criteria criteria) {
        String alarmType;
        String confirmStatus;
        String severity = condition.get("severity");
        if (this.isNotNullAndNotEmpty(severity)) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < severity.length(); ++i) {
                list.add(NumberUtil.convertToInteger((Object)String.valueOf(severity.charAt(i))));
            }
            criteria.add(Restrictions.in((String)"severity", list));
        }
        if (this.isNotNullAndNotEmpty(confirmStatus = condition.get("confirmStatus")) && !String.valueOf(0).equals(confirmStatus.trim())) {
            int status = NumberUtil.convertToInteger((Object)confirmStatus);
            criteria.add((Criterion)Restrictions.eq((String)"confirmStatus", (Object)NumberUtil.convertToInteger((Object)(status - 1))));
        }
        if (this.isNotNullAndNotEmpty(alarmType = condition.get("alarmType"))) {
            int type = NumberUtil.convertToInteger((Object)alarmType);
            criteria.add((Criterion)Restrictions.eq((String)"alarmType", (Object)type));
        }
        this.processClearStatus(condition, criteria);
    }

    private void processClearStatus(Map<String, String> condition, Criteria criteria) {
        String clearStatus = condition.get("clearStatus");
        if (this.isNotNullAndNotEmpty(clearStatus)) {
            criteria.add((Criterion)Restrictions.eq((String)"clearStatus", (Object)NumberUtil.convertToInteger((Object)clearStatus)));
            if (String.valueOf(0).equals(clearStatus)) {
                String filterForThirdDevice = condition.get("isFilterForThirdDevice");
                if (this.isNotNullAndNotEmpty(filterForThirdDevice) && "1".equals(filterForThirdDevice)) {
                    criteria.add((Criterion)Restrictions.eq((String)"isFilterForThirdDevice", (Object)"1"));
                } else {
                    criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"isFilterForThirdDevice", (Object)"0"), (Criterion)Restrictions.isNull((String)"isFilterForThirdDevice")));
                }
            }
        }
    }

    private void processAlarm2(Map<String, String> condition, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String alarmTypex;
        String confirmStatuses;
        String severitys = condition.get("severity");
        if (this.isNotNullAndNotEmpty(severitys)) {
            hqlBuffer.append(" and alarm.severity in (");
            for (int i = 0; i < severitys.length(); ++i) {
                hqlBuffer.append("?,");
                param.put(param.size(), String.valueOf(severitys.charAt(i)));
            }
            hqlBuffer.append("'-1')");
        }
        if (this.isNotNullAndNotEmpty(confirmStatuses = condition.get("confirmStatus")) && !String.valueOf(0).equals(confirmStatuses.trim())) {
            int status = NumberUtil.convertToInteger((Object)confirmStatuses);
            hqlBuffer.append(" and alarm.confirmStatus = ?");
            param.put(param.size(), String.valueOf(status - 1));
        }
        if (this.isNotNullAndNotEmpty(alarmTypex = condition.get("alarmType"))) {
            hqlBuffer.append(" and alarm.alarmType = ?");
            param.put(param.size(), alarmTypex);
        }
        this.processClearStatus(condition, hqlBuffer, param);
    }

    private void processClearStatus(Map<String, String> condition, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String clearStatuses = condition.get("clearStatus");
        if (this.isNotNullAndNotEmpty(clearStatuses)) {
            hqlBuffer.append(" and alarm.clearStatus = ?");
            param.put(param.size(), clearStatuses);
            if (String.valueOf(0).equals(clearStatuses)) {
                String filterForThirdDevices = condition.get("isFilterForThirdDevice");
                if (this.isNotNullAndNotEmpty(filterForThirdDevices) && "1".equals(filterForThirdDevices)) {
                    hqlBuffer.append(" and alarm.isFilterForThirdDevice = '");
                    hqlBuffer.append("1'");
                } else {
                    hqlBuffer.append(" and (alarm.isFilterForThirdDevice is null or alarm.isFilterForThirdDevice != '");
                    hqlBuffer.append("1')");
                }
            }
        }
    }

    @Override
    public int getFaultCount(Class<?> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard) {
        int count = this.getFaultCount2(faultType, condition, isFaultNameNeedWildcard);
        if (-1 == count) {
            count = this.getFaultCount2(faultType, condition, isFaultNameNeedWildcard);
        }
        if (count < 0) {
            count = 0;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> int getFaultCount2(Class<T> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            StringBuffer hqlBuffer = new StringBuffer("select count(alarm) from ");
            String typeName = faultType.getName();
            hqlBuffer = this.constructAlarmType(hqlBuffer, typeName);
            hqlBuffer.append("as alarm where 0=0");
            if (null == condition) {
                Query query = session.createQuery(hqlBuffer.toString());
                Object object = query.uniqueResult();
                if (null == object) {
                    int n = 0;
                    return n;
                }
                int n = ((Long)object).intValue();
                return n;
            }
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            this.getFaultsCount(faultType, condition, isFaultNameNeedWildcard, hqlBuffer, param);
            Query query = session.createQuery(hqlBuffer.toString());
            Set entrys = param.entrySet();
            for (Map.Entry entry : entrys) {
                query.setString(((Integer)entry.getKey()).intValue(), (String)entry.getValue());
            }
            Object object = query.uniqueResult();
            if (null == object) {
                int n = 0;
                return n;
            }
            int n = ((Long)object).intValue();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("queryFault exception, query condition is : " + condition + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return -1;
    }

    private StringBuffer constructAlarmType(StringBuffer hqlBuffer, String typeName) {
        if (null != typeName) {
            if (typeName.indexOf("Alarm") >= 0) {
                hqlBuffer.append("Alarm ");
            } else if (typeName.indexOf("Event") >= 0) {
                hqlBuffer.append("Event ");
            } else if (typeName.indexOf("Annotation") >= 0) {
                hqlBuffer.append("Annotation ");
            }
        }
        return hqlBuffer;
    }

    private void processMoId(StringBuffer hqlBuffer, String moId, Map<Integer, String> param) {
        String[] moIds = moId.split(",");
        StringBuffer bufx = new StringBuffer();
        for (int i = 0; i < moIds.length; ++i) {
            if ("".equals(moIds[i].trim())) continue;
            bufx.append('?');
            param.put(param.size(), moIds[i].trim());
            if (i == moIds.length - 1) continue;
            bufx.append(',');
        }
        if (!"".equals(bufx.toString())) {
            hqlBuffer.append(" and alarm.moId in (");
            hqlBuffer.append(bufx.toString() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> getFaultsByIds(Class<?> faultType, List<String> ids, String orderField, boolean orderByAscend) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(faultType);
            if (null == ids || ids.isEmpty()) {
                List list = criteria.list();
                return list;
            }
            criteria.add(Restrictions.in((String)"entity", ids));
            this.processDefaultOrder(orderField, orderByAscend, criteria);
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            logger.error((Object)("getFaultsByIds exception, ids is : " + ids + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFaultsByCondition(Class<?> className, Map<String, String> condition) {
        Object object = lockObject;
        synchronized (object) {
            Session session = null;
            Transaction transaction = null;
            try {
                session = super.getSessionFactory().openSession();
                transaction = session.beginTransaction();
                StringBuffer sql = new StringBuffer();
                String tableName = "T_alarm";
                sql = this.construtSQL(sql, condition, className, tableName);
                session.createSQLQuery(sql.toString()).executeUpdate();
                transaction.commit();
            }
            catch (Exception e) {
                logger.error((Object)("delete alarm or event." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                this.rollbackTransaction(transaction);
            }
            finally {
                this.closeSession(session);
            }
        }
    }

    private StringBuffer construtSQL(StringBuffer sql, Map<String, String> condition, Class<?> className, String tableName) {
        if ("Event".equals(className.getSimpleName())) {
            tableName = "T_event";
        }
        if (null == condition) {
            logger.debug((Object)"construtSQL:condition is null");
            sql.append("delete from " + tableName);
        } else {
            String entity;
            sql.append("delete from " + tableName + " where ");
            String moId = condition.get("source");
            if (this.isNotNullAndNotEmpty(moId)) {
                sql.append(" mo_id = '" + moId + "'");
                sql.append(" and ");
            }
            if (this.isNotNullAndNotEmpty(entity = condition.get("entity"))) {
                sql.append(" entity = '" + entity + "'");
                sql.append(" and ");
            }
            String startTime = condition.get("createTimeStart");
            String endTime = condition.get("createTimeEnd");
            String faultTime = "";
            faultTime = this.extractMethod(className);
            String ttime = condition.get("ttime");
            if (this.isNotNullAndNotEmpty(ttime)) {
                sql.append(faultTime + " = " + ttime);
                sql.append(" and ");
            }
            if (this.isNotNullAndNotEmpty(startTime)) {
                sql.append(faultTime + " > " + startTime);
                sql.append(" and ");
            }
            if (this.isNotNullAndNotEmpty(endTime)) {
                sql.append(faultTime + " < " + endTime);
                sql.append(" and ");
            }
            sql.append("0=0 ");
        }
        return sql;
    }

    private String extractMethod(Class<?> className) {
        String faultTime = Event.class.getSimpleName().equals(className.getSimpleName()) ? "time" : "mod_time";
        logger.debug((Object)"extractMethod:completed");
        return faultTime;
    }

    private boolean isNotNullAndNotEmpty(String str) {
        return null != str && !"".equals(str.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFaults(Class<?> clazz, List<?> faultList) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = super.getSessionFactory().openSession();
            int count = 0;
            transaction = session.beginTransaction();
            for (Object fault : faultList) {
                session.delete(fault);
                if (++count % 100 != 0) continue;
                session.flush();
                session.clear();
            }
            transaction.commit();
        }
        catch (Exception e) {
            logger.error((Object)("delete alarm or event." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            this.rollbackTransaction(transaction);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteHistorys(Class<?> clazz, List<?> faultList) {
        Session sessionn = null;
        Transaction transaction = null;
        try {
            sessionn = super.getSessionFactory().openSession();
            HashSet<String> tmpKeys = new HashSet<String>();
            StringBuffer buf = new StringBuffer();
            for (Object alarm : faultList) {
                String key = ConverterUtil.convertString(((Alarm)alarm).getEntity(), false);
                if (tmpKeys.contains(key)) continue;
                tmpKeys.add(key);
                buf.append('\'');
                buf.append(key);
                buf.append('\'');
                buf.append(',');
            }
            String keys = buf.toString();
            transaction = sessionn.beginTransaction();
            if (!"".equals(keys)) {
                StringBuffer sql = new StringBuffer();
                sql.append("delete from T_annotation where entity in (" + keys.substring(0, keys.length() - 1) + ")");
                sessionn.createSQLQuery(sql.toString()).executeUpdate();
            }
            transaction.commit();
        }
        catch (Exception eu) {
            logger.error((Object)("delete alarm or event." + ExceptionUtil.getErrorMessage((Throwable)eu)), 1L);
            this.rollbackTransaction(transaction);
        }
        finally {
            this.closeSession(sessionn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteHistoryByCondition(Map<String, String> condition) {
        Object object = lockObject;
        synchronized (object) {
            Session session = null;
            Transaction transaction = null;
            try {
                session = super.getSessionFactory().openSession();
                transaction = session.beginTransaction();
                StringBuffer sql = new StringBuffer();
                sql.append("delete from T_annotation");
                String moId = condition.get("source");
                if (this.isNotNullAndNotEmpty(moId)) {
                    sql.append(" where entity in ( ");
                    sql.append("select entity from T_alarm where mo_id = '" + moId);
                    sql.append(" ') ");
                }
                session.createSQLQuery(sql.toString()).executeUpdate();
                transaction.commit();
            }
            catch (Exception e) {
                logger.error((Object)("delete alarm or event." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                this.rollbackTransaction(transaction);
            }
            finally {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteHistoryOfflineByCondition(Map<String, String> condition) {
        Object object = lockObject;
        synchronized (object) {
            Session sessiond = null;
            Transaction transaction = null;
            try {
                sessiond = super.getSessionFactory().openSession();
                transaction = sessiond.beginTransaction();
                StringBuffer sql = new StringBuffer();
                sql.append("delete from T_annotation");
                String entity = condition.get("entity");
                if (this.isNotNullAndNotEmpty(entity)) {
                    sql.append(" where entity ='");
                    sql.append(entity);
                    sql.append("' ");
                }
                sessiond.createSQLQuery(sql.toString()).executeUpdate();
                transaction.commit();
            }
            catch (Exception ea) {
                logger.error((Object)("delete alarm or event." + ExceptionUtil.getErrorMessage((Throwable)ea)), 1L);
                this.rollbackTransaction(transaction);
            }
            finally {
                this.closeSession(sessiond);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> getEventsByIds(Class<?> faultType, List<Integer> ids, String orderField, boolean orderByAscend) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(faultType);
            if (ids == null || ids.isEmpty()) {
                List list = criteria.list();
                return list;
            }
            ArrayList<Long> longIds = new ArrayList<Long>();
            for (Integer id : ids) {
                longIds.add(NumberUtil.convertToLong((Object)String.valueOf(id)));
            }
            criteria.add(Restrictions.in((String)"id", longIds));
            this.processDefaultOrder(orderField, orderByAscend, criteria);
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            logger.error((Object)("getEventsByIds exception, ids is : " + ids + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteAlarmAndEventByMoID(List<Long> moIdList) {
        Object object = lockObject;
        synchronized (object) {
            StringBuffer logBuffer = new StringBuffer();
            logBuffer.append("product call deleteAlarmAndEventByMoID,moId is ");
            if (null == moIdList || moIdList.isEmpty()) {
                logBuffer.append("empty.");
                logger.info((Object)logBuffer.toString(), 1L);
                return false;
            }
            StringBuffer buffercv = new StringBuffer();
            int len = moIdList.size();
            for (int i = 0; i < len; ++i) {
                buffercv.append('\'');
                buffercv.append(moIdList.get(i));
                buffercv.append('\'');
                if (i == len - 1) continue;
                buffercv.append(',');
            }
            if ("".equals(buffercv.toString())) {
                logBuffer.append("null.");
                logger.info((Object)logBuffer.toString(), 1L);
                return false;
            }
            String moIds = buffercv.toString();
            if (moIds.endsWith(",")) {
                moIds = moIds.substring(0, moIds.length() - 1);
            }
            logBuffer.append(moIds);
            logger.info((Object)logBuffer.toString(), 1L);
            Session session = null;
            Transaction transaction = null;
            try {
                session = super.getSessionFactory().openSession();
                transaction = session.beginTransaction();
                String historySql = "delete from T_annotation where entity in (select entity from T_alarm where mo_id in (" + moIds + "))";
                int annotationCount = session.createSQLQuery(historySql).executeUpdate();
                logger.info((Object)("delete annotation count:" + annotationCount), 1L);
                String alarmSql = "delete from T_alarm where mo_id in (" + moIds + ")";
                int alarmCount = session.createSQLQuery(alarmSql).executeUpdate();
                logger.info((Object)("delete alarm count:" + alarmCount), 1L);
                String eventSql = "delete from T_event where mo_id in (" + moIds + ")";
                int eventCount = session.createSQLQuery(eventSql).executeUpdate();
                logger.info((Object)("delete event counts:" + eventCount), 1L);
                transaction.commit();
                boolean bl = true;
                return bl;
            }
            catch (Exception em) {
                logger.error((Object)("delete alarm or event,moId:" + moIds + ExceptionUtil.getErrorMessage((Throwable)em)), 1L);
                this.rollbackTransaction(transaction);
            }
            finally {
                this.closeSession(session);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteAlarmAndEventBySourceId(List<String> sourceIdList) {
        Object object = lockObject;
        synchronized (object) {
            StringBuffer logBuffer = new StringBuffer();
            logBuffer.append("low Nms call deleteAlarmAndEventBySourceId,sourceId is ");
            if (null == sourceIdList || sourceIdList.isEmpty()) {
                logBuffer.append("empty.");
                logger.info((Object)logBuffer.toString(), 1L);
                return false;
            }
            StringBuffer buffer = new StringBuffer();
            int len = sourceIdList.size();
            for (int i = 0; i < len; ++i) {
                buffer.append('\'');
                buffer.append(sourceIdList.get(i));
                buffer.append('\'');
                if (i == len - 1) continue;
                buffer.append(',');
            }
            if ("".equals(buffer.toString())) {
                logBuffer.append("null.");
                logger.info((Object)logBuffer.toString(), 1L);
                return false;
            }
            String ids = buffer.toString();
            if (ids.endsWith(",")) {
                ids = ids.substring(0, ids.length() - 1);
            }
            logBuffer.append(ids);
            logger.info((Object)logBuffer.toString(), 1L);
            Session session = null;
            Transaction transaction = null;
            try {
                session = super.getSessionFactory().openSession();
                transaction = session.beginTransaction();
                String historySql = "delete from T_annotation where entity in (select entity from T_alarm where source_id in (:ids) and mo_id = 1)";
                int annotationCount = session.createSQLQuery(historySql).setParameterList("ids", sourceIdList).executeUpdate();
                logger.info((Object)("delete nms annotation by uuid count:" + annotationCount), 1L);
                String alarmSql = "delete from T_alarm where source_id in (:ids) and mo_id = 1";
                int alarmCount = session.createSQLQuery(alarmSql).setParameterList("ids", sourceIdList).executeUpdate();
                logger.info((Object)("delete nms alarm by uuid count:" + alarmCount), 1L);
                transaction.commit();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                logger.error((Object)("delete lowNms alarm or event,uuIds:" + ids + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                this.rollbackTransaction(transaction);
            }
            finally {
                this.closeSession(session);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRedundanceInfo(List<Long> moIdList) {
        StringBuffer logBuffers = new StringBuffer();
        logBuffers.append("deleteRedundanceInfo,moId is ");
        if (null == moIdList || moIdList.isEmpty()) {
            logBuffers.append("empty.");
            logger.info((Object)logBuffers.toString(), 1L);
            return false;
        }
        StringBuffer buffers = new StringBuffer();
        if ("".equals((buffers = this.processBuffer(moIdList, buffers)).toString())) {
            logBuffers.append("null.");
            logger.info((Object)logBuffers.toString(), 1L);
            return false;
        }
        String moIds = buffers.toString();
        if (moIds.endsWith(",")) {
            moIds = moIds.substring(0, moIds.length() - 1);
        }
        logBuffers.append(moIds);
        logger.info((Object)logBuffers.toString(), 1L);
        Session session = null;
        Transaction transaction = null;
        try {
            session = super.getSessionFactory().openSession();
            transaction = session.beginTransaction();
            String historySql = "delete from T_annotation where entity in (select entity from T_alarm where mo_id not in (:moIds))";
            int annotationCount = session.createSQLQuery(historySql).setParameterList("moIds", moIdList).executeUpdate();
            logger.info((Object)("delete annotation count:" + annotationCount), 1L);
            String alarmSql = "delete from T_alarm where mo_id not in (:moIds)";
            int alarmCount = session.createSQLQuery(alarmSql).setParameterList("moIds", moIdList).executeUpdate();
            logger.info((Object)("delete alarm count:" + alarmCount), 1L);
            String eventSql = "delete from T_event where mo_id not in (:moIds)";
            int eventCount = session.createSQLQuery(eventSql).setParameterList("moIds", moIdList).executeUpdate();
            logger.info((Object)("delete event count:" + eventCount), 1L);
            transaction.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)("delete alarm or event,moId:" + moIds + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            this.rollbackTransaction(transaction);
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    private StringBuffer processBuffer(List<Long> moIdList, StringBuffer buffers) {
        int lens = moIdList.size();
        for (int i = 0; i < lens; ++i) {
            buffers.append('\'');
            buffers.append(moIdList.get(i));
            buffers.append('\'');
            if (i == lens - 1) continue;
            buffers.append(',');
        }
        return buffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateChildFault(String oldName, String newName, String moId) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = super.getSessionFactory().openSession();
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(Alarm.class);
            criteria.add((Criterion)Restrictions.eq((String)"moId", (Object)NumberUtil.convertToLong((Object)moId)));
            criteria.add((Criterion)Restrictions.eq((String)"moName", (Object)oldName));
            List alarmList = criteria.list();
            for (Alarm alarm : alarmList) {
                alarm.setMoName(newName);
                session.saveOrUpdate((Object)alarm);
            }
            Criteria criteriaEvent = session.createCriteria(Event.class);
            criteriaEvent.add((Criterion)Restrictions.eq((String)"moId", (Object)NumberUtil.convertToLong((Object)moId)));
            criteriaEvent.add((Criterion)Restrictions.eq((String)"moName", (Object)oldName));
            List eventList = criteriaEvent.list();
            for (Event event : eventList) {
                event.setMoName(newName);
                session.saveOrUpdate((Object)event);
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)("update moId :" + moId + ",oldName:" + oldName + ",newName:" + newName + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            this.rollbackTransaction(transaction);
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateFaultMoName(String moId, String name) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = super.getSessionFactory().openSession();
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(Alarm.class);
            criteria.add((Criterion)Restrictions.eq((String)"moId", (Object)NumberUtil.convertToLong((Object)moId)));
            List alarmList = criteria.list();
            for (Alarm alarm : alarmList) {
                alarm.setMoName(name);
                session.saveOrUpdate((Object)alarm);
            }
            Criteria criteriaEvent = session.createCriteria(Event.class);
            criteriaEvent.add((Criterion)Restrictions.eq((String)"moId", (Object)NumberUtil.convertToLong((Object)moId)));
            List eventList = criteriaEvent.list();
            for (Event event : eventList) {
                event.setMoName(name);
                session.saveOrUpdate((Object)event);
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)("update moId :" + moId + ",Name:" + name + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            this.rollbackTransaction(transaction);
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long queryMaxOrMinSyncNo(boolean isMax) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(Annotation.class);
            if (isMax) {
                criteria.setProjection((Projection)Projections.max((String)"id"));
            } else {
                criteria.setProjection((Projection)Projections.min((String)"id"));
                criteria.add((Criterion)Restrictions.eq((String)"clearStatus", (Object)FaultEnum.ClearState.UNCLEARED.getValue()));
            }
            List result = criteria.list();
            if (null != result && !result.isEmpty()) {
                Long l = (Long)result.get(0);
                return l;
            }
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Annotation> syncAlarmByAaid(long minSynNo, long maxSyncNo) {
        Session session = null;
        ArrayList<Annotation> detailList = new ArrayList();
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(Annotation.class);
            criteria.add((Criterion)Restrictions.ge((String)"id", (Object)minSynNo));
            criteria.add((Criterion)Restrictions.le((String)"id", (Object)maxSyncNo));
            detailList = criteria.list();
        }
        catch (Exception e) {
            logger.error((Object)(new StringBuilder().append("syncAlarmByAaid error, minSynNo: ").append(minSynNo).append(", maxSyncNo: ").append(maxSyncNo) + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return detailList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Alarm> queryAlarms(List<Annotation> detailList) {
        HashMap<String, Alarm> alertMap = new HashMap<String, Alarm>();
        Session session = null;
        try {
            HashSet<String> entityList = new HashSet<String>();
            for (Annotation detail : detailList) {
                entityList.add(detail.getEntity());
            }
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(Alarm.class);
            criteria.add(Restrictions.in((String)"entity", entityList));
            List alertList = criteria.list();
            if (null != alertList && !alertList.isEmpty()) {
                for (Alarm alert : alertList) {
                    alertMap.put(alert.getEntity(), alert);
                }
            }
            this.closeSession(session);
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return alertMap;
    }

    private void closeSession(Session session) {
        HibernateUtil.closeSession(session);
    }

    private void rollbackTransaction(Transaction transaction) {
        if (null != transaction) {
            logger.debug((Object)"rollbackTransaction:transaction is not null");
            transaction.rollback();
        }
    }
}

