/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.dao.impl;

import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.dao.IFaultDefineDAO;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public class FaultDefineDAOImpl
extends HibernateDaoSupportWrapper
implements IFaultDefineDAO {
    private static final int VALUE_10000 = 10000;
    private Log logger = LogFactory.getInstance(FaultDefineDAOImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addFaultDefine(List<FaultDefine> faultDefines) {
        Session session = null;
        Transaction transaction = null;
        try {
            int i;
            session = this.getSessionFactory().openSession();
            transaction = session.beginTransaction();
            for (i = 0; i < faultDefines.size(); ++i) {
                FaultDefine faultDefine = faultDefines.get(i);
                session.save((Object)faultDefine);
                if (i % 10000 != 0) continue;
                session.flush();
                session.clear();
            }
            transaction.commit();
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            this.logger.error((Object)("addFaultDefine error." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            HibernateUtil.rollbackSession(session);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return false;
    }

    @Override
    public boolean deleteAllFaultDefine() {
        Session session = null;
        try {
            session = this.getSessionFactory().openSession();
            session.beginTransaction();
            session.createSQLQuery("truncate table T_alarm_faultdefine").executeUpdate();
            session.getTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            HibernateUtil.rollbackSession(session);
            this.logger.error((Object)("deleteAllFaultDefine fail." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    @Override
    public List<FaultDefine> getFaultDefineList(String moMainType, String moSubType, FaultEnum.AlarmType faultType) {
        ArrayList<FaultDefine> faultDefines = new ArrayList<FaultDefine>();
        Session session = null;
        try {
            session = this.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(FaultDefine.class);
            criteria.add((Criterion)Restrictions.eq((String)"moMainType", (Object)moMainType));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"moSubType", (Object)moSubType), (Criterion)Restrictions.ilike((String)"moSubType", (Object)"all")));
            criteria.add((Criterion)Restrictions.eq((String)"faultType", (Object)faultType.getValue()));
            criteria.add((Criterion)Restrictions.eq((String)"relateId", (Object)""));
            List list = criteria.list();
            for (Object obj : list) {
                if (null == obj) continue;
                faultDefines.add((FaultDefine)obj);
            }
        }
        catch (DataAccessException e) {
            this.logger.error((Object)new StringBuilder().append("get FaultDefine List error, moMainType: ").append(moMainType).append(", moSubType: ").append(moSubType).append(", faultType: ").append(faultType.getValue()), (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        catch (HibernateException e) {
            this.logger.error((Object)new StringBuilder().append("get FaultDefine List error, moMainType: ").append(moMainType).append(", moSubType: ").append(moSubType).append(", faultType: ").append(faultType.getValue()), (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        return faultDefines;
    }

    private void closeSession(Session session) {
        HibernateUtil.closeSession(session);
    }

    @Override
    public List<FaultDefine> getFaultDefineList(String moMainType, String moSubType, FaultEnum.AlarmSeverity[] severities) {
        ArrayList<FaultDefine> faultDefines = new ArrayList<FaultDefine>();
        Session sessionxx = null;
        try {
            sessionxx = this.getSessionFactory().openSession();
            Criteria criteria = sessionxx.createCriteria(FaultDefine.class);
            if (this.checkMainTypeNotNull(moMainType)) {
                criteria.add((Criterion)Restrictions.eq((String)"moMainType", (Object)moMainType));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"moMainType", (Object)moSubType));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"moSubType", (Object)moSubType), (Criterion)Restrictions.ilike((String)"moSubType", (Object)"all")));
            ArrayList<Integer> severityList = new ArrayList<Integer>();
            for (FaultEnum.AlarmSeverity severity : severities) {
                severityList.add(severity.getValue());
            }
            criteria.add(Restrictions.in((String)"faultLevel", severityList));
            List list = criteria.list();
            for (Object obj : list) {
                if (null == obj) continue;
                faultDefines.add((FaultDefine)obj);
            }
        }
        catch (DataAccessException e) {
            this.logger.error((Object)new StringBuilder().append("get FaultDefine List error, moMainType: ").append(moMainType).append(", moSubType: ").append(moSubType).append(", severities: ").append(Arrays.toString(severities)), (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        catch (HibernateException e) {
            this.logger.error((Object)new StringBuilder().append("get FaultDefine List error, moMainType: ").append(moMainType).append(", moSubType: ").append(moSubType).append(", severities: ").append(Arrays.toString(severities)), (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        finally {
            this.closeSession(sessionxx);
        }
        return faultDefines;
    }

    @Override
    public List<FaultDefine> getFaultDefineList(String moMainType, String moSubType, FaultEnum.AlarmSeverity[] severities, FaultEnum.TrapType[] trapTypes) {
        ArrayList<FaultDefine> faultDefines = new ArrayList<FaultDefine>();
        Session session = null;
        try {
            session = this.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(FaultDefine.class);
            criteria.addOrder(Order.asc((String)"faultLevel"));
            if (this.checkMainTypeNotNull(moMainType)) {
                criteria.add((Criterion)Restrictions.eq((String)"moMainType", (Object)moMainType));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"moMainType", (Object)moSubType));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"moSubType", (Object)moSubType), (Criterion)Restrictions.eq((String)"moSubType", (Object)"all")));
            ArrayList<Integer> severityList = new ArrayList<Integer>();
            for (FaultEnum.AlarmSeverity severity : severities) {
                severityList.add(severity.getValue());
            }
            criteria.add(Restrictions.in((String)"faultLevel", severityList));
            ArrayList<Integer> trapTypeList = new ArrayList<Integer>();
            for (FaultEnum.TrapType trapType : trapTypes) {
                trapTypeList.add(trapType.getValue());
            }
            criteria.add(Restrictions.in((String)"trapType", trapTypeList));
            List lists = criteria.list();
            for (Object objs : lists) {
                if (null == objs) continue;
                faultDefines.add((FaultDefine)objs);
            }
        }
        catch (DataAccessException ex) {
            this.logger.error((Object)new StringBuilder().append("get FaultDefine List error, moMainType: ").append(moMainType).append(", moSubType: ").append(moSubType).append(", severities: ").append(Arrays.toString(severities)), (Throwable)ex, 1L);
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
        catch (HibernateException ee) {
            this.logger.error((Object)new StringBuilder().append("get FaultDefine List error, moMainType: ").append(moMainType).append(", moSubType: ").append(moSubType).append(", severities: ").append(Arrays.toString(severities)), (Throwable)ee, 1L);
            throw LegoExceptionTranslator.convert((Throwable)ee);
        }
        finally {
            this.closeSession(session);
        }
        return faultDefines;
    }

    private boolean checkMainTypeNotNull(String moMainType) {
        return null != moMainType && !"".equals(moMainType);
    }

    @Override
    public boolean checkFaultIsExist(String[] alarmInfo) {
        int alarmtype;
        int level;
        if (alarmInfo.length < 4) {
            this.logger.error((Object)("invalid alarmInfo length: " + alarmInfo.length + ", excepted 4."), 1L);
            throw new LegoCheckedException(250L);
        }
        try {
            level = Integer.parseInt(alarmInfo[0]);
            alarmtype = Integer.parseInt(alarmInfo[3]);
        }
        catch (NumberFormatException e) {
            throw new LegoCheckedException(250L, (Throwable)e);
        }
        String alarmid = alarmInfo[1];
        String alarmname = alarmInfo[2];
        Session session = null;
        try {
            session = this.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(FaultDefine.class);
            criteria.add((Criterion)Restrictions.eq((String)"faultId", (Object)alarmid));
            criteria.add((Criterion)Restrictions.eq((String)"faultName", (Object)alarmname));
            criteria.add((Criterion)Restrictions.eq((String)"faultLevel", (Object)level));
            criteria.add((Criterion)Restrictions.eq((String)"faultType", (Object)alarmtype));
            List list = criteria.list();
            boolean bl = !list.isEmpty();
            return bl;
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"get fault define error", 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        catch (HibernateException e) {
            this.logger.error((Object)"get fault define error", 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }
}

