/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.dao.impl;

import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.nem.fault.dao.IFaultUserDao;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.service.FaultQueryInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class FaultUserDaoImpl
extends HibernateDaoSupportWrapper
implements IFaultUserDao {
    private static final int VALUE_1000 = 1000;
    private Log logger = LogFactory.getInstance(FaultUserDaoImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> queryFaults(Class<?> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard, FaultQueryInfo queryInfo, long userId) {
        int firstRowIndex = queryInfo.getFirstRowIndex();
        int totalRow = queryInfo.getTotalRow();
        String orderByField = queryInfo.getOrderByField();
        boolean orderByAscend = queryInfo.isOrderByAscend();
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            StringBuffer order = new StringBuffer();
            this.processDefultOrder(orderByField, orderByAscend, order);
            this.processIndexOrder(faultType, orderByField, orderByAscend, order);
            StringBuffer hqlBuffer = new StringBuffer("select alarm");
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            this.getFaultHql(faultType, condition, isFaultNameNeedWildcard, userId, hqlBuffer, param);
            hqlBuffer.append(' ');
            hqlBuffer.append(order.toString());
            Query query = session.createQuery(hqlBuffer.toString());
            if (null != param) {
                Set entrys = param.entrySet();
                for (Map.Entry entry : entrys) {
                    query.setString(((Integer)entry.getKey()).intValue(), (String)entry.getValue());
                }
            }
            if (firstRowIndex >= 0) {
                query.setFirstResult(firstRowIndex);
            }
            if (totalRow >= 0) {
                query.setMaxResults(totalRow);
            }
            List list = query.list();
            return list;
        }
        catch (Exception e) {
            this.logger.error((Object)("queryFaults exception, query condition is : " + condition + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    private void processIndexOrder(Class<?> faultType, String orderByField, boolean orderByAscend, StringBuffer order) {
        if (!"id".equals(orderByField) && Annotation.class.getSimpleName().equals(faultType.getSimpleName())) {
            this.extractSort(orderByAscend, order);
        } else if (!"entity".equals(orderByField) && Alarm.class.getSimpleName().equals(faultType.getSimpleName())) {
            if (orderByAscend) {
                order.append(",alarm.entity asc");
            } else {
                order.append(",alarm.entity desc");
            }
        } else if (!"id".equals(orderByField) && Event.class.getSimpleName().equals(faultType.getSimpleName())) {
            this.extractSort(orderByAscend, order);
        }
    }

    private void extractSort(boolean orderByAscend, StringBuffer order) {
        if (orderByAscend) {
            order.append(",alarm.id asc");
        } else {
            order.append(",alarm.id desc");
        }
    }

    private void processDefultOrder(String orderByField, boolean orderByAscend, StringBuffer order) {
        if (orderByAscend) {
            order.append("order by alarm.");
            order.append(orderByField);
            order.append(" asc");
        } else {
            order.append("order by alarm.");
            order.append(orderByField);
            order.append(" desc");
        }
    }

    @Override
    public int getFaultCount(Class<?> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard, long userId) {
        int count = this.getFaultCount2(faultType, condition, isFaultNameNeedWildcard, userId);
        if (-1 == count) {
            count = this.getFaultCount2(faultType, condition, isFaultNameNeedWildcard, userId);
        }
        if (count < 0) {
            count = 0;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFaultCount2(Class<?> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard, long userId) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            StringBuffer hqlBuffer = new StringBuffer("select");
            String typeName = faultType.getName();
            hqlBuffer = this.constructAlarmType(hqlBuffer, typeName);
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            this.getFaultHql(faultType, condition, isFaultNameNeedWildcard, userId, hqlBuffer, param);
            if (null == condition) {
                Query query = session.createQuery(hqlBuffer.toString());
                Object object = query.uniqueResult();
                if (null == object) {
                    int n = 0;
                    return n;
                }
                int n = ((Long)object).intValue();
                return n;
            }
            Query querys = session.createQuery(hqlBuffer.toString());
            Set entryses = param.entrySet();
            for (Map.Entry entry : entryses) {
                querys.setString(((Integer)entry.getKey()).intValue(), (String)entry.getValue());
            }
            Object objects = querys.uniqueResult();
            if (null == objects) {
                int n = 0;
                return n;
            }
            int n = ((Long)objects).intValue();
            return n;
        }
        catch (Exception ex) {
            this.logger.error((Object)("queryFault exception, query condition is : " + condition + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return -1;
    }

    private StringBuffer constructAlarmType(StringBuffer hqlBuffer, String typeName) {
        if (null != typeName) {
            if (typeName.indexOf("Alarm") >= 0) {
                hqlBuffer.append(" count(alarm.entity)");
            } else if (typeName.indexOf("Event") >= 0) {
                hqlBuffer.append(" count(alarm.id)");
            } else if (typeName.indexOf("Annotation") >= 0) {
                hqlBuffer.append(" count(alarm.id)");
            }
        }
        return hqlBuffer;
    }

    private void closeSession(Session session) {
        HibernateUtil.closeSession(session);
    }

    private void getFaultHql(Class<?> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard, long userId, StringBuffer hqlBuffer, Map<Integer, String> param) {
        try {
            if (faultType.getName().indexOf("Alarm") >= 0) {
                hqlBuffer.append(" from Alarm as alarm where ");
                hqlBuffer.append(" ((alarm.sourceType = '");
                hqlBuffer.append(FaultEnum.AlarmResourceType.UNDEFINED.getValue());
                hqlBuffer.append("')");
                hqlBuffer.append(" or (alarm.sourceType = '");
                hqlBuffer.append(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
                hqlBuffer.append("' and alarm.sourceId in (select uuid from ManagedObject where moId in (select tu.id.moId from UserRelMoInfo as tu where tu.id.userIdx = ?)))");
                hqlBuffer.append(" or (alarm.sourceType = '");
                hqlBuffer.append(FaultEnum.AlarmResourceType.DRMOBJECT.getValue());
                hqlBuffer.append("' and alarm.sourceId in (select tiu.objectId from UserBizObject as tiu where tiu.userId = ?))) ");
                param.put(param.size(), String.valueOf(userId));
                param.put(param.size(), String.valueOf(userId));
            } else if (faultType.getName().indexOf("Event") >= 0) {
                hqlBuffer.append(" from UserRelMoInfo as relation,Event ");
                hqlBuffer.append("as alarm where alarm.moId=relation.id.moId and relation.id.userIdx=?");
                param.put(param.size(), String.valueOf(userId));
            } else if (faultType.getName().indexOf("Annotation") >= 0) {
                hqlBuffer.append(" from Annotation as alarm where 0=0");
            }
            if (null == condition) {
                return;
            }
            this.getFaultHql(faultType, condition, isFaultNameNeedWildcard, hqlBuffer, param);
        }
        catch (Exception e) {
            this.logger.error((Object)("queryFault exception, query condition is : " + condition + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    private void getFaultHql(Class<?> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String moName = condition.get("moName");
        if (this.isNotNullAndNotEmpty(moName)) {
            String convertStr = ConverterUtil.convertString(moName.trim(), true);
            hqlBuffer.append(" and lower(alarm.moName) like lower(?)");
            param.put(param.size(), convertStr);
        }
        this.processAnnotationDetail(condition, hqlBuffer, param, faultType.getSimpleName());
        String loc = condition.get("location");
        this.getHqlByloc(hqlBuffer, loc, param);
        String nmsIp = condition.get("nmsIp");
        if (this.isNotNullAndNotEmpty(nmsIp)) {
            hqlBuffer.append(" and alarm.nmsIp = ?");
            param.put(param.size(), nmsIp);
        }
        if (Alarm.class.getSimpleName().equals(faultType.getSimpleName())) {
            this.processAlarm(condition, isFaultNameNeedWildcard, hqlBuffer, param);
        } else {
            this.processEvent(condition, isFaultNameNeedWildcard, hqlBuffer, param);
        }
    }

    private void processAnnotationDetail(Map<String, String> condition, StringBuffer hqlBuffer, Map<Integer, String> param, String simpleName) {
        if (Annotation.class.getSimpleName().equals(simpleName)) {
            String entity = condition.get("entity");
            if (this.isNotNullAndNotEmpty(entity)) {
                hqlBuffer.append(" and alarm.entity = ?");
                param.put(param.size(), entity);
            }
        } else {
            String moId = condition.get("source");
            if (this.isNotNullAndNotEmpty(moId)) {
                if (moId.contains(",")) {
                    this.processMoId(hqlBuffer, moId, param);
                } else {
                    hqlBuffer.append(" and alarm.moId = ?");
                    param.put(param.size(), moId);
                }
            }
        }
    }

    private StringBuffer getHqlByloc(StringBuffer hqlBuffer, String loc, Map<Integer, String> param) {
        if (this.isNotNullAndNotEmpty(loc)) {
            String convertStr = ConverterUtil.convertString(loc.trim(), true);
            hqlBuffer.append(" and lower(alarm.location) like lower(?");
            param.put(param.size(), convertStr);
            hqlBuffer.append(')');
        }
        return hqlBuffer;
    }

    private boolean isNotNullAndNotEmpty(String str) {
        return null != str && !"".equals(str.trim());
    }

    private void processMoId(StringBuffer hqlBuffer, String moId, Map<Integer, String> param) {
        String[] moIds = moId.split(",");
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < moIds.length; ++i) {
            if ("".equals(moIds[i].trim())) continue;
            buf.append('?');
            param.put(param.size(), moIds[i].trim());
            if (i == moIds.length - 1) continue;
            buf.append(',');
        }
        if (!"".equals(buf.toString())) {
            hqlBuffer.append(" and alarm.moId in (");
            hqlBuffer.append(buf.toString() + ")");
        }
    }

    private void processAlarm(Map<String, String> condition, boolean isFaultNameNeedWildcard, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String endTime;
        String startTime;
        String alarmName = condition.get("alarmName");
        if (this.isNotNullAndNotEmpty(alarmName)) {
            if (isFaultNameNeedWildcard) {
                String convertStr = ConverterUtil.convertString(alarmName, true);
                hqlBuffer.append(" and lower(alarm.alarmName) like lower(?)");
                param.put(param.size(), convertStr);
            } else {
                hqlBuffer.append(" and alarm.alarmName = ?");
                param.put(param.size(), alarmName);
            }
        }
        if (this.isNotNullAndNotEmpty(startTime = condition.get("createTimeStart"))) {
            hqlBuffer.append(" and alarm.modTime >= ?");
            param.put(param.size(), startTime);
        }
        if (this.isNotNullAndNotEmpty(endTime = condition.get("createTimeEnd"))) {
            long temp = NumberUtil.convertToLong((Object)endTime) + 1000L;
            hqlBuffer.append(" and alarm.modTime < ?");
            param.put(param.size(), String.valueOf(temp));
        }
        this.processAlarm2(condition, hqlBuffer, param);
    }

    private void processAlarm2(Map<String, String> condition, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String alarmType;
        String confirmStatus;
        String severity = condition.get("severity");
        if (this.isNotNullAndNotEmpty(severity)) {
            hqlBuffer.append(" and alarm.severity in (");
            for (int i = 0; i < severity.length(); ++i) {
                hqlBuffer.append("?,");
                param.put(param.size(), String.valueOf(severity.charAt(i)));
            }
            hqlBuffer.append("'-1')");
        }
        if (this.isNotNullAndNotEmpty(confirmStatus = condition.get("confirmStatus")) && !String.valueOf(0).equals(confirmStatus.trim())) {
            int status = NumberUtil.convertToInteger((Object)confirmStatus);
            hqlBuffer.append(" and alarm.confirmStatus = ?");
            param.put(param.size(), String.valueOf(status - 1));
        }
        if (this.isNotNullAndNotEmpty(alarmType = condition.get("alarmType"))) {
            hqlBuffer.append(" and alarm.alarmType = ?");
            param.put(param.size(), alarmType);
        }
        this.processClearStatus(condition, hqlBuffer, param);
    }

    private void processClearStatus(Map<String, String> condition, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String clearStatus = condition.get("clearStatus");
        if (this.isNotNullAndNotEmpty(clearStatus)) {
            hqlBuffer.append(" and alarm.clearStatus = ?");
            param.put(param.size(), clearStatus);
            if (String.valueOf(0).equals(clearStatus)) {
                String filterForThirdDevice = condition.get("isFilterForThirdDevice");
                if (this.isNotNullAndNotEmpty(filterForThirdDevice) && "1".equals(filterForThirdDevice)) {
                    hqlBuffer.append(" and alarm.isFilterForThirdDevice = '");
                    hqlBuffer.append("1'");
                } else {
                    hqlBuffer.append(" and (alarm.isFilterForThirdDevice is null or  alarm.isFilterForThirdDevice !='");
                    hqlBuffer.append("1')");
                }
            }
        }
    }

    private void processEvent(Map<String, String> condition, boolean isFaultNameNeedWildcard, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String eventType;
        String endTime;
        String startTime;
        String eventName = condition.get("eventName");
        if (this.isNotNullAndNotEmpty(eventName)) {
            if (isFaultNameNeedWildcard) {
                String convertStr = ConverterUtil.convertString(eventName, true);
                hqlBuffer.append(" and lower(alarm.eventName) like lower(?)");
                param.put(param.size(), convertStr);
            } else {
                hqlBuffer.append(" and alarm.eventName = ?");
                param.put(param.size(), eventName);
            }
        }
        if (this.isNotNullAndNotEmpty(startTime = condition.get("createTimeStart"))) {
            hqlBuffer.append(" and alarm.time >= ?");
            param.put(param.size(), startTime);
        }
        if (this.isNotNullAndNotEmpty(endTime = condition.get("createTimeEnd"))) {
            long temp = NumberUtil.convertToLong((Object)endTime) + 1000L;
            hqlBuffer.append(" and alarm.time < ?");
            param.put(param.size(), String.valueOf(temp));
        }
        if (this.isNotNullAndNotEmpty(eventType = condition.get("eventType")) && !"0".equalsIgnoreCase(eventType.trim())) {
            hqlBuffer.append(" and alarm.eventType = ?");
            param.put(param.size(), eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> queryAllMoIds() {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            String hql = "select distinct alarm.moId,alarm.moName from Alarm as alarm group by alarm.moId,alarm.moName";
            Query query = session.createQuery(hql);
            List list = query.list();
            return list;
        }
        catch (Exception e) {
            this.logger.error((Object)("ueryAllMoIds failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> queryAllAlarmCount(String columnName, Object columnValue) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            String hql = "select alarm.moId,alarm.moName,alarm.severity,count(alarm.entity) from Alarm as alarm where alarm.clearStatus = 0 and (alarm.isFilterForThirdDevice is null or alarm.isFilterForThirdDevice !='1')";
            Query query = null;
            if (!columnName.equals("clearStatus")) {
                hql = hql + " and alarm." + columnName + " = :columnValue group by alarm.moId,alarm.moName,alarm.severity";
                query = session.createQuery(hql).setParameter("columnValue", columnValue);
                List list = query.list();
                return list;
            }
            hql = hql + " group by alarm.moId,alarm.moName,alarm.severity";
            query = session.createQuery(hql);
            List list = query.list();
            return list;
        }
        catch (Exception e) {
            this.logger.error((Object)("queryUnClearCount failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> queryLowNmsAlarmTotal(long userId, String columnName, Object columnValue) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            StringBuffer hqlBuffer = new StringBuffer("select alarm.severity,count(alarm.entity) from Alarm as alarm");
            hqlBuffer.append(" where ((alarm.sourceType = '");
            hqlBuffer.append(FaultEnum.AlarmResourceType.UNDEFINED.getValue());
            hqlBuffer.append("')");
            hqlBuffer.append(" or (alarm.sourceType='");
            hqlBuffer.append(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
            hqlBuffer.append("' and alarm.sourceId in (select uuid from ManagedObject where moId in (select tu.id.moId from UserRelMoInfo as tu where tu.id.userIdx = '" + userId + "')))");
            hqlBuffer.append(" or (alarm.sourceType='");
            hqlBuffer.append(FaultEnum.AlarmResourceType.DRMOBJECT.getValue());
            hqlBuffer.append("' and alarm.sourceId in (select tiu.objectId from UserBizObject as tiu where tiu.userId = '" + userId + "'))");
            hqlBuffer.append(") and alarm.clearStatus = 0 and (alarm.isFilterForThirdDevice is null or alarm.isFilterForThirdDevice != '1')");
            Query query = null;
            if (!columnName.equals("clearStatus")) {
                hqlBuffer.append(" and alarm." + columnName + "= :columnValue");
                hqlBuffer.append(" group by alarm.severity");
                query = session.createQuery(hqlBuffer.toString()).setParameter("columnValue", columnValue);
                List list = query.list();
                return list;
            }
            hqlBuffer.append(" group by alarm.severity");
            String hql = hqlBuffer.toString();
            query = session.createQuery(hql);
            List list = query.list();
            return list;
        }
        catch (Exception e) {
            this.logger.error((Object)("queryLowNmsAlarmTotal failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean queryAlarmMO(String type, long userid, String[] alarmEntity) {
        Session session = null;
        try {
            String hql;
            session = super.getSessionFactory().openSession();
            Query query = null;
            if ("Alarm".equals(type)) {
                hql = "select distinct alarm.moId from Alarm as alarm where alarm.entity in( :entitylist )";
                query = session.createQuery(hql);
                query.setParameterList("entitylist", (Object[])alarmEntity);
            } else if ("Event".equals(type)) {
                hql = "select distinct event.moId from Event as event where event.id in( :entitylist )";
                query = session.createQuery(hql);
                query.setParameterList("entitylist", (Object[])alarmEntity);
            } else {
                boolean hql2 = true;
                return hql2;
            }
            List molist = query.list();
            if (this.checkMoListEmpty(molist)) {
                boolean bl = false;
                return bl;
            }
            for (Object tempmo : molist) {
                if (this.checkMOIsSystem(tempmo)) continue;
                StringBuffer hqlBuffer = new StringBuffer();
                hqlBuffer.append("FROM UserRelMoInfo where id.userIdx = ?");
                hqlBuffer.append("and id.moId = ?");
                Query tempquery = session.createQuery(hqlBuffer.toString()).setParameter(0, (Object)userid).setParameter(1, tempmo);
                List userMo = tempquery.list();
                if (!this.extractMethod(userMo)) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("query mo failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return true;
    }

    private boolean checkMOIsSystem(Object tempmo) {
        return "0".equals(String.valueOf(tempmo)) || "1".equals(String.valueOf(tempmo));
    }

    private boolean checkMoListEmpty(List<?> molist) {
        return null == molist || molist.isEmpty();
    }

    private boolean extractMethod(List<?> userMo) {
        return null == userMo || userMo.isEmpty();
    }
}

