/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.decorator;

import com.huawei.lego.nem.fault.sdk.decorator.IFaultDecorator;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Event;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

public class FaultDecoratorMgr {
    private static FaultDecoratorMgr sInstance = null;
    private Map<String, IFaultDecorator> decorators = new Hashtable<String, IFaultDecorator>();

    private FaultDecoratorMgr() {
    }

    public static synchronized FaultDecoratorMgr getInstance() {
        if (null == sInstance) {
            sInstance = new FaultDecoratorMgr();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFaultDecorator getDecorator(Alarm alarm) {
        Map<String, IFaultDecorator> map = this.decorators;
        synchronized (map) {
            Collection<IFaultDecorator> decoratorList = this.decorators.values();
            for (IFaultDecorator decorator : decoratorList) {
                if (!decorator.isMyAlarm(alarm)) continue;
                return decorator;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFaultDecorator getDecorator(Event event) {
        Map<String, IFaultDecorator> map = this.decorators;
        synchronized (map) {
            Collection<IFaultDecorator> decoratorList = this.decorators.values();
            for (IFaultDecorator decorator : decoratorList) {
                if (!decorator.isMyEvent(event)) continue;
                return decorator;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBind(IFaultDecorator decorator, Map<String, String> properties) {
        Map<String, IFaultDecorator> map = this.decorators;
        synchronized (map) {
            if (null != decorator) {
                this.decorators.put(decorator.toString(), decorator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnbind(IFaultDecorator decorator, Map<String, String> properties) {
        Map<String, IFaultDecorator> map = this.decorators;
        synchronized (map) {
            if (null != decorator) {
                this.decorators.remove(decorator.toString());
            }
        }
    }
}

