/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.jms.handler;

import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.nem.fault.jms.IFaultMsgHandler;
import com.huawei.lego.nem.fault.launcher.impl.AlarmSyncLauncher;

public class AlarmSyncMsgHandler
implements IFaultMsgHandler {
    private static final String KEY_IS_TRAP = "isTrap";
    private Log logger = LogFactory.getInstance(AlarmSyncMsgHandler.class);

    @Override
    public long getMsgType() {
        return 5001L;
    }

    @Override
    public void handleMsg(MessageUnit mu) {
        String isTrapStr = LegoProperties.getProperty((String)KEY_IS_TRAP, (String)Boolean.FALSE.toString());
        if (isTrapStr.equals(Boolean.FALSE.toString())) {
            this.logger.info((Object)"The Alarm Sync is forbidden", 1L);
            return;
        }
        try {
            TopoObject mo = (TopoObject)mu.getObj();
            this.logger.info((Object)("recv a COMMAND_ALARM_SYNCHRONIZE message: " + mo), 1L);
            long moId = mo.getMoId();
            String moIP = mo.getIpAddress();
            String moName = mo.getName();
            AlarmSyncLauncher.getSynchronizer().launchSyncTask(moId, moIP, moName);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"product throw LegoCheckedException.", 1L);
        }
        catch (Exception e) {
            this.logger.error((Object)("deal with COMMAND_ALARM_SYNCHRONIZE failed: " + mu.getObj() + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }
}

