/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.jms.handler;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.jms.IFaultMsgHandler;
import com.huawei.lego.nem.fault.launcher.impl.AlarmSyncLauncher;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.Map;

public class ResAddMsgHandler
implements IFaultMsgHandler {
    private Log logger = LogFactory.getInstance(ResAddMsgHandler.class);

    @Override
    public long getMsgType() {
        return 103L;
    }

    @Override
    public void handleMsg(MessageUnit mu) {
        Map msgObj = (Map)mu.getObj();
        this.logger.info((Object)("recv a COMMAND_RES_ADD message, moIds: " + msgObj.keySet()), 1L);
        Collection moList = msgObj.values();
        for (ManagedObject mo : moList) {
            if (!(mo instanceof TopoObject)) {
                this.logger.info((Object)"MO is not TopoObject.", 1L);
                continue;
            }
            try {
                TopoObject topoObj = (TopoObject)mo;
                String ipAddress = topoObj.getIpAddress();
                if (null == ipAddress) {
                    this.logger.info((Object)"ipAddress is null.", 1L);
                    continue;
                }
                AlarmSyncLauncher.getSynchronizer().createSyncTask(topoObj.getMoId(), topoObj.getName(), ipAddress, FaultEnum.AlarmSyncType.MANU_SYNC);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("start alarmsync task failed after adding a topoobject: " + mo), (Throwable)e, 1L);
            }
            catch (Exception e) {
                this.logger.error((Object)("proccess COMMAND_RES_ADD exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }
}

