/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.jms.handler;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.nem.fault.dao.IFaultDao;
import com.huawei.lego.nem.fault.jms.IFaultMsgHandler;
import com.huawei.lego.nem.fault.jms.handler.UserMoContainer;
import com.huawei.lego.nem.fault.product.DelAlarmServiceContainer;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.service.FaultQueryInfo;
import com.huawei.lego.nem.fault.sdk.service.IAlarmSyncService;
import com.huawei.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import com.huawei.lego.nem.fault.util.FaultUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ResDeleteMsgHandler
implements IFaultMsgHandler {
    private static final int VALUE_3000 = 3000;
    private Log logger = LogFactory.getInstance(ResDeleteMsgHandler.class);
    private IFaultDao faultDao = null;
    private IAlarmSyncService alarmSyncService = null;
    private IRemoteNotifyRuleService remoteNotifyRuleService = null;

    @Override
    public long getMsgType() {
        return 105L;
    }

    @Override
    public void handleMsg(MessageUnit mu) {
        HashMap msgObj = (HashMap)mu.getObj();
        this.logger.info((Object)("receive COMMAND_RES_DEL message, moIds: " + msgObj.keySet()), 1L);
        Collection moList = msgObj.values();
        if (null != moList && !moList.isEmpty()) {
            CommonUtil.sleep((long)3000L);
            for (ManagedObject mo : moList) {
                if (!(mo instanceof TopoObject)) continue;
                TopoObject topoMo = (TopoObject)mo;
                this.deleteFaults(mo.getMoId());
                this.delOfflineAlarm(topoMo);
                this.deleteAlarmSync(topoMo);
                this.deleteAlarmNority(topoMo);
            }
            UserMoContainer.getInstance().notifyDeleteMo(msgObj.keySet());
        }
    }

    private void delOfflineAlarm(TopoObject mo) {
        String offalarmid = "0x000803220005";
        String entity = "1" + offalarmid + mo.getUuid();
        HashMap<String, String> condition = new HashMap<String, String>();
        entity = FaultUtil.replaceEntity(entity);
        condition.put("entity", entity);
        this.faultDao.deleteFaultsByCondition(Alarm.class, condition);
        this.faultDao.deleteHistoryOfflineByCondition(condition);
    }

    private void deleteFaults(long moId) {
        this.logger.info((Object)("start to delete event and alarm in NemDeleteSubscriber, moId: " + moId), 1L);
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("source", String.valueOf(moId));
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(-1);
        queryInfo.setTotalRow(-1);
        queryInfo.setOrderByField("alarmId");
        queryInfo.setOrderByAscend(false);
        List<Alarm> alarmList = this.faultDao.queryFaults(Alarm.class, condition, false, queryInfo);
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        for (Alarm alarm : alarmList) {
            HashMap<String, String> conditionAnnotation = new HashMap<String, String>();
            conditionAnnotation.put("entity", alarm.getEntity());
            FaultQueryInfo queryInfo1 = new FaultQueryInfo();
            queryInfo1.setFirstRowIndex(0);
            queryInfo1.setTotalRow(Integer.MAX_VALUE);
            queryInfo1.setOrderByField("id");
            queryInfo1.setOrderByAscend(false);
            List<?> detailList = this.faultDao.queryFaults(Annotation.class, conditionAnnotation, false, queryInfo1);
            if (!detailList.isEmpty()) {
                annotationList.add((Annotation)detailList.get(0));
                continue;
            }
            this.logger.error((Object)"deal with annotation error", 1L);
            annotationList.add(new Annotation());
        }
        DelAlarmServiceContainer.delAlarmSendMessage(alarmList, annotationList);
        this.faultDao.deleteHistoryByCondition(condition);
        this.faultDao.deleteFaultsByCondition(Alarm.class, condition);
        this.faultDao.deleteFaultsByCondition(Event.class, condition);
    }

    private void deleteAlarmSync(TopoObject topoMo) {
        this.alarmSyncService.deleteTaskByMoId(topoMo.getMoId().longValue());
    }

    private void deleteAlarmNority(TopoObject topoMo) {
        long moId = topoMo.getMoId();
        if (moId == 0L) {
            this.logger.error((Object)"moId is 0, can not delete resource in notify or shield.", 1L);
        } else {
            boolean result2 = this.remoteNotifyRuleService.deleteResourceItem(String.valueOf(moId));
            this.logger.info((Object)("delete a resource " + result2 + " in notify rule, moId: " + moId), 1L);
        }
    }

    public void setFaultDao(IFaultDao faultDao) {
        this.faultDao = faultDao;
    }

    public void setAlarmSyncService(IAlarmSyncService alarmSyncService) {
        this.alarmSyncService = alarmSyncService;
    }

    public void setRemoteNotifyRuleService(IRemoteNotifyRuleService remoteNotifyRuleService) {
        this.remoteNotifyRuleService = remoteNotifyRuleService;
    }
}

