/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.jms.handler;

import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.jms.IFaultMsgHandler;
import com.huawei.lego.nem.fault.jms.SubscriberUtil;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.util.FaultUtil;
import java.util.Map;
import java.util.Set;

public class ResOnlineMsgHandler
implements IFaultMsgHandler {
    private static final int VALUE_2 = 2;
    private static final long SPECIAL_MOID = -1L;
    private Log logger = LogFactory.getInstance(ResOnlineMsgHandler.class);

    @Override
    public long getMsgType() {
        return 110L;
    }

    @Override
    public void handleMsg(MessageUnit mu) {
        Map msgObj = (Map)mu.getObj();
        Set moIds = msgObj.keySet();
        this.logger.info((Object)("recv a COMMAND_RES_ONLINE message, moIds: " + moIds), 1L);
        for (Long moId : moIds) {
            try {
                if (-1L == moId) continue;
                TopoObject mo = SubscriberUtil.getTopoObjectById(moId);
                Alarm alarm = new Alarm();
                alarm.setAlarmId("0x000803220005");
                alarm.setMoIP(mo.getIpAddress());
                alarm.setMoId(moId.longValue());
                alarm.setMoName(mo.getName());
                long alarmTime = System.currentTimeMillis();
                alarm.setModTime(alarmTime);
                String[] param = new String[]{mo.getName(), mo.getIpAddress()};
                alarm.setParamList(param);
                alarm.setParams(param[0] + "\t" + param[1]);
                alarm.setSeverity(FaultEnum.AlarmSeverity.CRITICAL.getValue());
                alarm.setClearStatus(FaultEnum.ClearState.CLEARED.getValue());
                alarm.setClearTime(alarmTime);
                alarm.setClearUser("system");
                alarm.setMoUuid(mo.getUuid());
                LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
                SubscriberUtil.getFaultGenerateService().generateRestoreAlarm(legoAlarm);
            }
            catch (Exception e) {
                this.logger.error((Object)("generateAlarm failed in ResOnlineSubscriber of Fault Module, moId:" + moId + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }
}

