/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.jms.handler;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.jms.IFaultMsgHandler;
import com.huawei.lego.nem.fault.sdk.service.IAlarmSyncService;
import com.huawei.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import java.util.Collection;
import java.util.HashMap;

public class ResUpdateMsgHandler
implements IFaultMsgHandler {
    private Log logger = LogFactory.getInstance(ResUpdateMsgHandler.class);
    private IAlarmSyncService alarmSyncService = null;
    private IRemoteNotifyRuleService remoteNotifyRuleService = null;

    @Override
    public long getMsgType() {
        return 107L;
    }

    @Override
    public void handleMsg(MessageUnit mu) {
        HashMap msgObj = (HashMap)mu.getObj();
        this.logger.info((Object)("receive COMMAND_RES_UPDATE message, moIds: " + msgObj.keySet()), 1L);
        Collection moList = msgObj.values();
        for (ManagedObject mo : moList) {
            if (!(mo instanceof TopoObject)) continue;
            TopoObject topoMo = (TopoObject)mo;
            this.updateAlarmSync(topoMo);
            this.updateAlarmNority(topoMo);
        }
    }

    private void updateAlarmSync(TopoObject topoMo) {
        this.alarmSyncService.updateTaskMoName(topoMo.getMoId().longValue(), topoMo.getName(), topoMo.getIpAddress());
        this.alarmSyncService.updateAlarmLocation(topoMo.getMoId().longValue(), topoMo.getLocation());
    }

    private void updateAlarmNority(TopoObject topoMo) {
        long moId = topoMo.getMoId();
        String moIP = topoMo.getIpAddress();
        if (moId == 0L) {
            this.logger.error((Object)"moId is 0, can not update resource in notify.", 1L);
        } else {
            this.remoteNotifyRuleService.updateResourceItem(String.valueOf(moId), topoMo.getName(), moIP, topoMo.getMainType(), topoMo.getSubType());
        }
    }

    public void setAlarmSyncService(IAlarmSyncService alarmSyncService) {
        this.alarmSyncService = alarmSyncService;
    }

    public void setRemoteNotifyRuleService(IRemoteNotifyRuleService remoteNotifyRuleService) {
        this.remoteNotifyRuleService = remoteNotifyRuleService;
    }
}

