/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.jms.sender;

import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.base.thread.CommonThread;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.launcher.impl.MsgSubscribeLauncher;
import com.huawei.lego.nem.fault.msg.listener.AlarmStatisticListener;
import com.huawei.lego.nem.fault.sdk.model.AlarmStatistic;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AlarmStatisticSender {
    private static final int SEND_PERIOD = 15;
    private static Log logger = LogFactory.getInstance(AlarmStatisticSender.class);
    private boolean isContinueRunning = true;

    public void start() {
        final AlarmStatisticSender sender = this;
        CommonThread thread = new CommonThread(){

            @Override
            protected void execute() {
                sender.execute();
            }
        };
        thread.setThreadName("alarm statistic send thread");
        ExecutionService.submitTask(thread);
    }

    public void stop() {
        this.isContinueRunning = false;
    }

    public void execute() {
        while (this.isContinueRunning) {
            try {
                TimeUnit.SECONDS.sleep(15L);
                Map<Long, AlarmStatistic> statisticMap = AlarmStatisticListener.getAllStatistic();
                logger.debug((Object)("send Alarm Statistic Message: " + statisticMap), 1L);
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(5002L);
                mu.setObj(statisticMap);
                mu.setMt(MessageTopic.DATA);
                mu.setSourceAppName(this.getClass().getName());
                MsgSubscribeLauncher.getMc().sendMessage(mu);
            }
            catch (InterruptedException e) {
                logger.info((Object)"interrupt Thread[alarm statistic send thread].", 1L);
                break;
            }
            catch (Exception e) {
                logger.error((Object)("Throwable was caught when in Thread[alarm statistic send thread]." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }
}

