/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.launcher;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.launcher.IFaultLauncher;
import com.huawei.lego.nem.fault.persistence.FaultDBAPI;
import java.util.ArrayList;
import java.util.List;

public class FaultLauncher {
    private static FaultLauncher sInstance = null;
    private Log logger = LogFactory.getInstance(FaultLauncher.class);
    private List<IFaultLauncher> launchers = new ArrayList<IFaultLauncher>();
    private FaultDBAPI faultApi = null;

    public static FaultLauncher getInstance() {
        if (null == sInstance) {
            sInstance = new FaultLauncher();
        }
        return sInstance;
    }

    public void start() {
        this.logger.info((Object)"===============begin to start Fault Module===============", 1L);
        for (IFaultLauncher launcher : this.launchers) {
            launcher.start();
        }
        this.logger.info((Object)"===============end to start Fault Module===============", 1L);
    }

    public void stop() {
        this.logger.info((Object)"===============begin to stop Fault Module===============", 1L);
        for (IFaultLauncher launcher : this.launchers) {
            launcher.stop();
        }
    }

    public void setLaunchers(List<IFaultLauncher> launchers) {
        this.launchers = launchers;
    }

    public FaultDBAPI getFaultApi() {
        return this.faultApi;
    }

    public void setFaultApi(FaultDBAPI faultApi) {
        this.faultApi = faultApi;
    }
}

