/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.launcher.impl;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.launcher.IFaultLauncher;
import com.huawei.lego.nem.fault.sdk.service.IAlarmSyncService;
import com.huawei.lego.nem.fault.sdk.service.IAlarmSynchronize;
import com.huawei.lego.nem.fault.sync.AlarmSynchronizer;
import com.huawei.lego.nem.fault.sync.AlarmSynchronizerBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AlarmSyncLauncher
implements IFaultLauncher {
    private static List<AlarmSynchronizerBean> alarmSynchronizerList = Collections.synchronizedList(new ArrayList());
    private static Log logger = LogFactory.getInstance(AlarmSyncLauncher.class);
    private static AlarmSynchronizer synchronizer = null;
    private IAlarmSyncService alarmSyncSrv = null;

    private static void setAlarmSynchronizer(AlarmSynchronizer alarmSynchronizer) {
        synchronizer = alarmSynchronizer;
    }

    @Override
    public void start() {
        logger.info((Object)"[FaultLauncher] begin to start AlarmSyncLauncher.", 1L);
        this.alarmSyncSrv.resetSynStatus();
    }

    @Override
    public void stop() {
        alarmSynchronizerList.clear();
    }

    public static void addAlarmSynchronizer(IAlarmSynchronize service, String productName, String trapoid) {
        logger.info((Object)new StringBuilder().append("add an AlarmSynchronizer: ").append(service.getClass().getName()).append(", productName: ").append(productName).append(", trapoid: ").append(trapoid), 1L);
        AlarmSynchronizerBean serviceBean = new AlarmSynchronizerBean(productName, trapoid, service);
        alarmSynchronizerList.add(serviceBean);
    }

    public static AlarmSynchronizerBean getSynchronizer(long moId) {
        for (AlarmSynchronizerBean bean : alarmSynchronizerList) {
            IAlarmSynchronize alarmSynchronize = bean.getService();
            if (alarmSynchronize.isMyNode(moId)) {
                return bean;
            }
            logger.debug((Object)("Mo is not my mo,MoId: " + moId + ", ProductName: " + bean.getProductName() + ",trapoid:" + bean.getTrapoid()), 1L);
        }
        return null;
    }

    public static List<AlarmSynchronizerBean> getAllSynchronizer() {
        return alarmSynchronizerList;
    }

    public static AlarmSynchronizer getSynchronizer() {
        return synchronizer;
    }

    public void setSynchronizer(AlarmSynchronizer synchronizer) {
        AlarmSyncLauncher.setAlarmSynchronizer(synchronizer);
    }

    public void setAlarmSyncSrv(IAlarmSyncService alarmSyncSrv) {
        this.alarmSyncSrv = alarmSyncSrv;
    }
}

