/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.launcher.impl;

import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.event.ServiceStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.launcher.IFaultLauncher;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class RedundaceDataLauncher
implements IFaultLauncher,
ServiceStatusChangedListener {
    private Log logger = LogFactory.getInstance(RedundaceDataLauncher.class);
    private IAlarmService alarmSrv = null;
    private IRemoteNotifyRuleService notifyRuleSrv = null;

    @Override
    public void start() {
        this.logger.info((Object)"[FaultLauncher] begin to start RedundaceDataLauncher.", 1L);
    }

    @Override
    public void stop() {
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getEventTarget() instanceof IResourceService) {
            try {
                String ip = this.getInstallServerIp();
                this.notifyRuleSrv.updateNotifyRuleSystemIp(ip);
            }
            catch (Exception e) {
                this.logger.error((Object)("getHostAddress error." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            try {
                IResourceService resourceService = (IResourceService)ServiceContext.getInstance().lookup("ResourceApplication/ResourceServiceImpl");
                List moIdList = resourceService.getAllMoId();
                moIdList.add(0L);
                this.alarmSrv.deleteRedundanceInfo(moIdList);
            }
            catch (Exception e) {
                this.logger.error((Object)("delete redundancy data exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    public void setAlarmSrv(IAlarmService alarmSrv) {
        this.alarmSrv = alarmSrv;
    }

    public void setNotifyRuleSrv(IRemoteNotifyRuleService notifyRuleSrv) {
        this.notifyRuleSrv = notifyRuleSrv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInstallServerIp() {
        String current;
        String ips = "";
        String legoinstallPaths = "/monitor/RDInstalled.xml";
        String realPath = "";
        try {
            current = new File("").getCanonicalPath();
        }
        catch (IOException e) {
            this.logger.error((Object)("get current path failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            return ips;
        }
        String legoruntimes = "/LegoRuntime";
        int i = 0;
        String newCurrentPaths = "";
        if (null != current && (i = current.length() - legoruntimes.length()) >= 0) {
            newCurrentPaths = current.substring(0, i);
        }
        realPath = newCurrentPaths + legoinstallPaths;
        SAXReader readers = new SAXReader();
        FileInputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new FileInputStream(realPath);
            CommonUtil.setSecurityFeatures((SAXReader)readers);
            document = readers.read((InputStream)inputStream);
            ips = InetAddress.getLocalHost().getHostAddress();
            this.logger.info((Object)("The default ip is:" + ips), 1L);
            if (null == document) {
                this.logger.error((Object)"The documents is null.", 1L);
                String string = ips;
                return string;
            }
            Node nodes = document.selectSingleNode("//install/httpsip");
            if (null != nodes) {
                ips = nodes.getText();
                this.logger.info((Object)("The lego install ips is:" + ips), 1L);
                String string = ips;
                return string;
            }
            String string = ips;
            return string;
        }
        catch (Exception ee) {
            this.logger.error((Object)("Get install ip fail, errors is:" + ExceptionUtil.getErrorMessage((Throwable)ee)), 1L);
        }
        finally {
            if (null != inputStream) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException ex) {
                    this.logger.error((Object)"Close the inputstream failed, the error is:", (Throwable)ex, 1L);
                }
            }
        }
        return ips;
    }
}

