/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.launcher.impl;

import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.com.south.sdk.model.SnmpV3Param;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.event.ServiceStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import com.huawei.lego.nem.fault.trap.listener.ForceDecodeAlarmListener;
import com.huawei.lego.nem.fault.trap.recv.TrapMsgListener;
import com.huawei.lego.nem.fault.util.snmp.SnmpV2cUtil;
import com.huawei.lego.nem.fault.util.snmp.Snmpv3Util;
import java.util.List;

public class SnmpV3ReceiverLauncher
implements ServiceStatusChangedListener {
    private static boolean isRegister = false;
    private Log logger = LogFactory.getInstance(SnmpV3ReceiverLauncher.class);
    private IAlarmService alarmSrv = null;
    private IFaultGenerateService faultGenerateService = null;

    private static void setRegisterFlag(boolean flag) {
        isRegister = flag;
    }

    private static boolean isRegistered() {
        return isRegister;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        block5: {
            block4: {
                List snmpV3ParamList;
                if (!(event.getEventTarget() instanceof IAlarmService)) break block4;
                if (!SnmpV3ReceiverLauncher.isRegistered()) {
                    ForceDecodeAlarmListener listener = new ForceDecodeAlarmListener();
                    listener.setAlarmService(this.faultGenerateService);
                    listener.register();
                    SnmpV3ReceiverLauncher.setRegisterFlag(true);
                    this.logger.info((Object)"Register ForceDecodeAlarmListener end.", 1L);
                }
                if (null == (snmpV3ParamList = this.alarmSrv.getSnmpV3ParamList())) break block5;
                this.logger.info((Object)("Init v3 param, paramList size:" + snmpV3ParamList.size()), 1L);
                for (SnmpV3Param snmpV3Param : snmpV3ParamList) {
                    Snmpv3Util.addUSMUserEntry(TrapMsgListener.getSnmpTrapListener(), snmpV3Param);
                }
                break block5;
            }
            if (event.getEventTarget() instanceof IResourceService) {
                IResourceService resourceService = (IResourceService)ServiceContext.getInstance().lookup("ResourceApplication/ResourceServiceImpl");
                List nodes = resourceService.getDiscoveredResource();
                this.logger.info((Object)("Init v2 param, nodes size:" + nodes.size()), 1L);
                for (Node node : nodes) {
                    Protocol protocol = node.getManagementProtocol(SnmpPara.class.getName());
                    if (protocol == null) continue;
                    SnmpPara snmpPara = (SnmpPara)protocol;
                    SnmpV2cUtil.addParam(snmpPara, node.getUuid());
                }
            }
        }
    }

    public void setFaultGenerateService(IFaultGenerateService faultGenerateService) {
        this.faultGenerateService = faultGenerateService;
    }

    public void setAlarmSrv(IAlarmService alarmSrv) {
        this.alarmSrv = alarmSrv;
    }
}

