/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.msg;

import com.huawei.lego.core.base.thread.CommonThread;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.msg.FaultListener;
import com.huawei.lego.nem.fault.msg.FaultMsg;
import com.huawei.lego.nem.fault.msg.FaultMsgType;
import com.huawei.lego.nem.fault.msg.listener.AlarmForwardListener;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;

public final class FaultMsgDispatcher {
    private static final int VALUE_10240 = 10240;
    private static FaultMsgDispatcher sInstance = null;
    private Log logger = LogFactory.getInstance(FaultMsgDispatcher.class);
    private boolean isContinueRunning = true;
    private RunnableFuture<Integer> runnableFuture = null;
    private Set<FaultListener> listeners = Collections.synchronizedSet(new HashSet());
    private BlockingQueue<FaultMsg> faultMsgQueue = new LinkedBlockingQueue<FaultMsg>(10240);
    private Object syncLock = new Object();

    private FaultMsgDispatcher() {
    }

    public static synchronized FaultMsgDispatcher getInstance() {
        if (null == sInstance) {
            sInstance = new FaultMsgDispatcher();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class<FaultMsgDispatcher> clazz = FaultMsgDispatcher.class;
        synchronized (FaultMsgDispatcher.class) {
            final FaultMsgDispatcher dispatcher = this;
            CommonThread thread = new CommonThread(){

                @Override
                protected void execute() {
                    dispatcher.execute();
                }
            };
            thread.setThreadName("fault msg dispatch thread");
            this.runnableFuture = ExecutionService.newTaskFor(thread, 0);
            ExecutionService.submitTask(this.runnableFuture);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void stop() {
        this.isContinueRunning = false;
        if (null != this.runnableFuture) {
            this.runnableFuture.cancel(true);
        }
        this.removeAllListener();
    }

    public void execute() {
        while (this.isContinueRunning) {
            try {
                FaultMsg alarmMsg = this.faultMsgQueue.take();
                if (null == alarmMsg) {
                    this.logger.error((Object)"recv a null AlarmMsg object in FaultMsgDispatcher", 1L);
                    continue;
                }
                this.processMsg(alarmMsg.getMsgType(), alarmMsg);
            }
            catch (InterruptedException e) {
                this.logger.info((Object)"interrupt Thread[fault msg dispatch thread].", 1L);
                break;
            }
            catch (Exception e) {
                this.logger.error((Object)("Throwable was caught when in Thread[fault msg dispatch thread]." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    private void processMsg(FaultMsgType msgType, FaultMsg faultMsg) {
        Alarm alarm = faultMsg.getAlarm();
        for (FaultListener listener : this.listeners) {
            if (listener instanceof AlarmForwardListener) {
                ((AlarmForwardListener)listener).setAnnotation(faultMsg.getAnnotation());
            }
            try {
                this.processMessage(msgType, faultMsg, alarm, listener);
            }
            catch (Exception e) {
                this.logger.error((Object)("error occured while processMsg in FaultMsgDispatcher." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    private void processMessage(FaultMsgType msgType, FaultMsg faultMsg, Alarm alarm, FaultListener listener) {
        if (FaultMsgType.RESTORE_ALARM == msgType) {
            listener.processRestoreAlarm(alarm);
        } else if (FaultMsgType.MANUCLEAR_ALARM == msgType) {
            listener.processManuClearAlarm(alarm);
        } else if (FaultMsgType.CONFIRM_ALARM == msgType) {
            listener.processConfirm(alarm);
        } else if (FaultMsgType.UNCONFIRM_ALARM == msgType) {
            listener.processAntiConfirm(alarm);
        } else if (FaultMsgType.EVENT == msgType) {
            listener.processEvent(faultMsg.getEvent());
        } else {
            listener.processAlarm(alarm);
        }
    }

    public synchronized void notity(FaultMsg faultMsg) {
        this.logger.debug((Object)("recv an AlarmMsg in FaultMsgDispatcher: " + faultMsg), 1L);
        this.faultMsgQueue.add(faultMsg);
    }

    public synchronized void notify(List<FaultMsg> faultMsgList) {
        for (FaultMsg faultMsg : faultMsgList) {
            this.logger.debug((Object)("recv an AlarmMsg in FaultMsgDispatcher: " + faultMsg), 1L);
            this.faultMsgQueue.add(faultMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FaultListener listener) {
        Object object = this.syncLock;
        synchronized (object) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                this.logger.debug((Object)("add AlarmMsgListener: " + listener.getClass().getName()), 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FaultListener listener) {
        Object object = this.syncLock;
        synchronized (object) {
            this.listeners.remove(listener);
            this.logger.debug((Object)("remove AlarmMsgListener: " + listener.getClass().getName()), 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListener() {
        Object object = this.syncLock;
        synchronized (object) {
            this.listeners.clear();
            this.logger.debug((Object)"remove all AlarmMsgListener.", 1L);
        }
    }

    public void setListeners(Set<FaultListener> listeners) {
        this.listeners = listeners;
    }
}

