/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.msg.listener;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.DateFormatUtil;
import com.huawei.lego.nem.fault.msg.FaultListener;
import com.huawei.lego.nem.fault.msg.listener.FaultHandlerContainer;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.Event;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class AlarmForwardListener
implements FaultListener {
    private Log logger = LogFactory.getInstance(AlarmForwardListener.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Annotation annotation = null;

    @Override
    public synchronized void processAlarm(Alarm alarm) {
        this.logger.debug((Object)("processAlarm in ProductAlarmListener, entity: " + alarm.getEntity()), 1L);
        this.sendNotifyMsg(alarm);
    }

    @Override
    public void processRestoreAlarm(Alarm restoredAlarm) {
        this.logger.debug((Object)("processRestoreAlarm in ProductAlarmListener, entity: " + restoredAlarm.getEntity()), 1L);
        this.sendNotifyMsg(restoredAlarm);
    }

    @Override
    public synchronized void processConfirm(Alarm alarm) {
    }

    @Override
    public synchronized void processAntiConfirm(Alarm alarm) {
    }

    @Override
    public void processEvent(Event event) {
    }

    @Override
    public void processManuClearAlarm(Alarm alarm) {
        this.logger.debug((Object)("processManuClearAlarm in ProductAlarmListener, entity: " + alarm.getEntity()), 1L);
        this.sendNotifyMsg(alarm);
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    private void sendNotifyMsg(Alarm alarm) {
        StringBuffer bufferv = new StringBuffer();
        bufferv.append("publish alarm in webnms:");
        bufferv.append(alarm.getAlarmName());
        bufferv.append('/');
        bufferv.append(alarm.getSeverity());
        bufferv.append('/');
        bufferv.append(alarm.getMoName());
        bufferv.append('/');
        bufferv.append(DateFormatUtil.format((DateFormat)this.sdf, (Object)alarm.getModTime()));
        this.logger.debug((Object)bufferv.toString(), 1L);
        FaultHandlerContainer.notify(alarm, this.annotation);
    }
}

