/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.msg.listener;

import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.jms.handler.AlarmNotifyRegisteMsgHandler;
import com.huawei.lego.nem.fault.launcher.impl.MsgSubscribeLauncher;
import com.huawei.lego.nem.fault.msg.FaultListener;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.AlarmRegisterDetail;
import com.huawei.lego.nem.fault.sdk.model.AlarmRegisterInfo;
import com.huawei.lego.nem.fault.sdk.model.Event;
import java.util.List;

public class AlarmRegisteListener
implements FaultListener {
    private Log logger = LogFactory.getInstance(AlarmRegisteListener.class);

    @Override
    public synchronized void processAlarm(Alarm alarm) {
        this.logger.debug((Object)("processAlarm in AlarmProductListener, entity: " + alarm.getEntity()), 1L);
        this.sendNotifyMsg(alarm);
    }

    @Override
    public void processRestoreAlarm(Alarm restoredAlarm) {
        this.logger.debug((Object)("processRestoreAlarm in AlarmProductListener, the entity: " + restoredAlarm.getEntity()), 1L);
        this.sendNotifyMsg(restoredAlarm);
    }

    @Override
    public synchronized void processConfirm(Alarm alarms) {
    }

    @Override
    public synchronized void processAntiConfirm(Alarm alarms) {
    }

    @Override
    public void processEvent(Event event) {
    }

    @Override
    public void processManuClearAlarm(Alarm alarm) {
        this.logger.debug((Object)("processManuClearAlarm in AlarmProductListener, entity: " + alarm.getEntity()), 1L);
        this.sendNotifyMsg(alarm);
    }

    private void sendNotifyMsg(Alarm alarm) {
        try {
            AlarmRegisterInfo alarmRegisterInfo = AlarmNotifyRegisteMsgHandler.getAlarmRegisterInfo();
            if (null == alarmRegisterInfo) {
                this.logger.debug((Object)"no register Alarm.", 1L);
                return;
            }
            if (!alarmRegisterInfo.isOnOff()) {
                this.logger.debug((Object)"no transmit Alarm.", 1L);
                return;
            }
            if (alarmRegisterInfo.isAll()) {
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(5020L);
                mu.setObj(alarm);
                mu.setMt(MessageTopic.DATA);
                mu.setSourceAppName(this.getClass().getName());
                MsgSubscribeLauncher.getMc().sendMessage(mu);
                return;
            }
            List alarmList = alarmRegisterInfo.getAlarmRegisterDetail();
            for (AlarmRegisterDetail alarmRegisterDetail : alarmList) {
                if (!alarm.getAlarmId().equalsIgnoreCase(alarmRegisterDetail.getAlarmId())) continue;
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(5020L);
                mu.setObj(alarm);
                mu.setMt(MessageTopic.DATA);
                mu.setSourceAppName(this.getClass().getName());
                MsgSubscribeLauncher.getMc().sendMessage(mu);
            }
        }
        catch (Exception t) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)t), 1L);
        }
    }
}

