/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.msg.listener;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.AlarmDetail;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IFaultHandler;
import com.huawei.lego.nem.fault.util.FaultUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FaultHandlerContainer {
    private static Log logger = LogFactory.getInstance(FaultHandlerContainer.class);
    private static List<IFaultHandler> faultHandlerList = new ArrayList<IFaultHandler>();

    public static void notify(Alarm legoAlarm, Annotation annotation) {
        if (null == faultHandlerList || faultHandlerList.isEmpty()) {
            return;
        }
        try {
            for (IFaultHandler faultHandler : faultHandlerList) {
                LegoAlarm alarm = FaultUtil.alarmToLegoAlarm(legoAlarm);
                AlarmDetail detail = FaultUtil.annotationToAlarmDetail(annotation);
                faultHandler.notify(alarm, detail);
            }
        }
        catch (Exception t) {
            logger.error((Object)("notify product exception." + ExceptionUtil.getErrorMessage((Throwable)t)), 1L);
        }
    }

    public void onBind(IFaultHandler service, Map<String, String> properties) {
        if (null != service) {
            faultHandlerList.add(service);
            logger.info((Object)("onBind:" + service.toString()), 1L);
        } else {
            logger.info((Object)"onBind,service is null.", 1L);
        }
    }

    public void onUnbind(IFaultHandler service, Map<String, String> properties) {
        if (null != service) {
            faultHandlerList.remove(service);
            logger.info((Object)("onUnbind:" + service.toString()), 1L);
        } else {
            logger.info((Object)"onUnbind,service is null.", 1L);
        }
    }
}

