/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.msg.listener;

import com.huawei.lego.cbb.nms.sdk.service.INorthAlarmService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.msg.FaultListener;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.model.NorthFaultMsg;
import com.huawei.lego.nem.fault.util.FaultUtil;

public class NorthBoundListener
implements FaultListener {
    private Log logger = LogFactory.getInstance(NorthBoundListener.class);
    private INorthAlarmService northAlarmSrv = null;

    @Override
    public synchronized void processAlarm(Alarm alarm) {
        this.logger.debug((Object)("processAlarm in NorthBoundListener, entity: " + alarm.getEntity()), 1L);
        this.sendNorthFaultMsg(alarm, FaultEnum.NorthTrapType.FAULT);
    }

    @Override
    public synchronized void processRestoreAlarm(Alarm restoredAlarm) {
        this.logger.debug((Object)("processRestoreAlarm in NorthBoundListener, entity: " + restoredAlarm.getEntity()), 1L);
        this.sendNorthFaultMsg(restoredAlarm, FaultEnum.NorthTrapType.RESTORE);
    }

    @Override
    public synchronized void processManuClearAlarm(Alarm alarm) {
        this.logger.debug((Object)("processManuClearAlarm in NorthBoundListener, entity: " + alarm.getEntity()), 1L);
        this.sendNorthFaultMsg(alarm, FaultEnum.NorthTrapType.RESTORE);
    }

    @Override
    public synchronized void processConfirm(Alarm alarm) {
        this.logger.debug((Object)("processConfirm in NorthBoundListener, entity: " + alarm.getEntity()), 1L);
        this.sendNorthFaultMsg(alarm, FaultEnum.NorthTrapType.CONFIRM);
    }

    @Override
    public synchronized void processAntiConfirm(Alarm alarm) {
        this.logger.debug((Object)("processAntiConfirm in NorthBoundListener, entity: " + alarm.getEntity()), 1L);
        this.sendNorthFaultMsg(alarm, FaultEnum.NorthTrapType.ANTICONFIRM);
    }

    @Override
    public void processEvent(Event event) {
    }

    private void sendNorthFaultMsg(Alarm alarm, FaultEnum.NorthTrapType msgType) {
        try {
            LegoAlarm legoAlarm;
            if (null == this.northAlarmSrv) {
                this.northAlarmSrv = (INorthAlarmService)ServiceContext.getInstance().lookup("slave/northAlarmService");
            }
            if (null != (legoAlarm = FaultUtil.alarmToLegoAlarm(alarm)) && !"1".equals(legoAlarm.getFilterForThirdDevice()) && null != this.northAlarmSrv) {
                this.northAlarmSrv.notifyNorthAlarm(new NorthFaultMsg(msgType, legoAlarm));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("sendNorthFaultMsg failed, msgType: " + msgType + ", entity: " + alarm.getEntity() + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }
}

