/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.persistence;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.msg.FaultMsg;
import com.huawei.lego.nem.fault.persistence.AlarmObject;
import com.huawei.lego.nem.fault.persistence.IFaultPersistence;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.Event;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class FaultPersistence
extends HibernateDaoSupportWrapper
implements IFaultPersistence {
    private static Log logger = LogFactory.getInstance(FaultPersistence.class);

    @Override
    public Alarm getAlarm(String entity) {
        return (Alarm)super.getHibernateTemplate().get(Alarm.class, (Serializable)((Object)entity));
    }

    @Override
    public Annotation getAnnotation(long id) {
        try {
            return (Annotation)super.getHibernateTemplate().get(Annotation.class, (Serializable)Long.valueOf(id));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, null, (long)101L, null, (Log)logger);
            return null;
        }
    }

    @Override
    public void addEvent(Event event) {
        ManagedObject managedObject = (ManagedObject)super.getHibernateTemplate().get(ManagedObject.class, (Serializable)Long.valueOf(event.getMoId()));
        if (null != managedObject) {
            event.setGmt(managedObject.getTimezoneFormat());
        }
        super.getHibernateTemplate().save((Object)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation getAnnotationBySN(String entity, long sequence) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(Annotation.class.getName());
            criteria.add((Criterion)Restrictions.eq((String)"entity", (Object)entity));
            criteria.add((Criterion)Restrictions.eq((String)"sequence", (Object)sequence));
            criteria.addOrder(Order.desc((String)"id"));
            List list = criteria.list();
            if (null == list || list.isEmpty()) {
                Annotation annotation = null;
                return annotation;
            }
            Annotation annotation = (Annotation)list.get(0);
            return annotation;
        }
        catch (Exception e) {
            logger.error((Object)("getAnnotationBySN Throwable" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    private void closeSession(Session session) {
        HibernateUtil.closeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation getAnnotationByTime(String entity, long modTime) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(Annotation.class.getName());
            criteria.add((Criterion)Restrictions.eq((String)"entity", (Object)entity));
            criteria.add((Criterion)Restrictions.eq((String)"modTime", (Object)modTime));
            criteria.addOrder(Order.desc((String)"id"));
            List liste = criteria.list();
            if (null == liste || liste.isEmpty()) {
                Annotation annotation = null;
                return annotation;
            }
            Annotation annotation = (Annotation)liste.get(0);
            return annotation;
        }
        catch (Exception e) {
            logger.error((Object)("get AnnotationByTime Throwable" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation getTheLastAnnotation(String entity) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(Annotation.class.getName());
            criteria.add((Criterion)Restrictions.eq((String)"entity", (Object)entity));
            criteria.addOrder(Order.desc((String)"id"));
            List list = criteria.list();
            if (null == list || list.isEmpty()) {
                Annotation annotation = null;
                return annotation;
            }
            Annotation annotation = (Annotation)list.get(0);
            return annotation;
        }
        catch (Exception e) {
            logger.error((Object)("getAnnotationByTime Throwable" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveOrUpdateAlarms(Collection<AlarmObject> alarmList, Collection<Object> annotationList) {
        Transaction transaction = null;
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            transaction = session.getTransaction();
            transaction.begin();
            for (AlarmObject alarm : alarmList) {
                if (null == alarm || null == alarm.getAlarm()) {
                    logger.debug((Object)"alarm or alarm.getAlarm is null", 1L);
                    continue;
                }
                this.dealAlarm(alarm, session);
            }
            for (Object object : annotationList) {
                this.dealList(object, session);
            }
            transaction.commit();
        }
        catch (Exception t) {
            HibernateUtil.rollbackSession(session);
            logger.error((Object)("saveOrUpdateAlarms failed in AlarmPersistenceImpl." + ExceptionUtil.getErrorMessage((Throwable)t)), 1L);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void dealAlarm(AlarmObject alarm, Session session) throws UnknownHostException {
        if (0L != alarm.getAlarm().getMoId()) {
            alarm.getAlarm().setNmsIp(InetAddress.getLocalHost().getHostAddress());
            alarm.getAlarm().setNmsIp(InetAddress.getLocalHost().getHostAddress());
        }
        if (alarm.isExistInDB()) {
            session.update((Object)alarm.getAlarm());
        } else {
            ManagedObject managedObject;
            String gmt = alarm.getAlarm().getMoId() != 0L ? (null != (managedObject = (ManagedObject)session.get(ManagedObject.class, (Serializable)Long.valueOf(alarm.getAlarm().getMoId()))) ? managedObject.getTimezoneFormat() : "UTC+08:00") : alarm.getAlarm().getGmt();
            alarm.getAlarm().setGmt(gmt);
            session.save((Object)alarm.getAlarm());
        }
    }

    private void dealList(Object object, Session session) {
        if (object instanceof List) {
            List valuelist = (List)object;
            for (FaultMsg faultMsg : valuelist) {
                if (null == faultMsg) continue;
                session.saveOrUpdate((Object)faultMsg.getAnnotation());
            }
        } else if (null != object && object instanceof FaultMsg) {
            session.saveOrUpdate((Object)((FaultMsg)object).getAnnotation());
        }
    }
}

