/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.product;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IAlarmAffirmService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AffirmAlarmProcess {
    private static final Log LOGGER = LogFactory.getInstance(AffirmAlarmProcess.class);
    private static List<IAlarmAffirmService> alarmAffirmServiceList = new ArrayList<IAlarmAffirmService>();

    public static void affirmAlarm(List<LegoAlarm> alarmList) {
        try {
            for (IAlarmAffirmService service : alarmAffirmServiceList) {
                if (null == service) continue;
                service.affirmAlarm(alarmList);
            }
        }
        catch (Exception t) {
            LOGGER.error((Object)("affirmAlarm exception." + ExceptionUtil.getErrorMessage((Throwable)t)), 1L);
        }
    }

    public void onBind(IAlarmAffirmService service, Map<String, String> properties) {
        if (null != service) {
            alarmAffirmServiceList.add(service);
            LOGGER.info((Object)("onBind:" + service.toString()), 1L);
        } else {
            LOGGER.info((Object)"onBind,service is null.", 1L);
        }
    }

    public void onUnbind(IAlarmAffirmService service, Map<String, String> properties) {
        if (null != service) {
            alarmAffirmServiceList.remove(service);
            LOGGER.info((Object)("onUnbind:" + service.toString()), 1L);
        } else {
            LOGGER.info((Object)"onUnbind,service is null.", 1L);
        }
    }
}

