/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.service;

import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.nem.fault.dao.IFaultUserDao;
import com.huawei.lego.nem.fault.jms.handler.UserMoContainer;
import com.huawei.lego.nem.fault.msg.listener.AlarmStatisticListener;
import com.huawei.lego.nem.fault.sdk.model.AlarmCount;
import com.huawei.lego.nem.fault.sdk.model.AlarmStatistic;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.OverAllStatistic;
import com.huawei.lego.nem.fault.sdk.service.IAlarmStatistic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service(Name="statisticService", Desc="", Interface=IAlarmStatistic.class)
public class AlarmStatisticService
extends BaseService
implements IAlarmStatistic {
    private Log logger = LogFactory.getInstance(AlarmStatisticService.class);
    private IFaultUserDao faultUserDao = null;

    public OverAllStatistic getStatisticBySeverity(long userId) {
        OverAllStatistic overallStatistic = new OverAllStatistic();
        try {
            if (-1L != userId) {
                AlarmStatistic lowStatistic = new AlarmStatistic();
                List<Object[]> lowNmsCountUnClear = this.faultUserDao.queryLowNmsAlarmTotal(userId, "clearStatus", 0);
                List<Object[]> lowNmsCountUnConfirm = this.faultUserDao.queryLowNmsAlarmTotal(userId, "confirmStatus", 0);
                this.processNMSAlarm(lowNmsCountUnClear, lowNmsCountUnConfirm, lowStatistic);
                overallStatistic.update(lowStatistic);
            } else {
                this.updateAlarmStatistic(userId, overallStatistic);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("getStatisticBySeverity error, userId: " + userId + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return overallStatistic;
    }

    private void processNMSAlarm(List<Object[]> lowNmsCountUnClear, List<Object[]> lowNmsCountUnConfirm, AlarmStatistic lowStatistic) {
        FaultEnum.AlarmSeverity severity;
        if (null != lowNmsCountUnClear) {
            for (Object[] info : lowNmsCountUnClear) {
                severity = FaultEnum.AlarmSeverity.getSeverity((int)NumberUtil.convertToInteger((Object)info[0].toString()));
                lowStatistic.updateUnClearedCount(severity, NumberUtil.convertToInteger((Object)info[1].toString()).intValue());
            }
        }
        if (null != lowNmsCountUnConfirm) {
            for (Object[] info : lowNmsCountUnConfirm) {
                severity = FaultEnum.AlarmSeverity.getSeverity((int)NumberUtil.convertToInteger((Object)info[0].toString()));
                lowStatistic.updateUnConfirmedCount(severity, NumberUtil.convertToInteger((Object)info[1].toString()).intValue());
            }
        }
    }

    private void updateAlarmStatistic(long userId, OverAllStatistic overallStatistic) {
        Collection<AlarmStatistic> statisticList = AlarmStatisticListener.getAllStatistic(null);
        for (AlarmStatistic statistic : statisticList) {
            if (null == statistic) {
                this.logger.error((Object)("statistic is null in getStatisticBySeverity, userId: " + userId), 1L);
                continue;
            }
            overallStatistic.update(statistic);
        }
    }

    public Map<FaultEnum.AlarmSeverity, List<AlarmCount>> getTopnMo(int topn, long userId) {
        HashMap<FaultEnum.AlarmSeverity, List<AlarmCount>> statisticMap = new HashMap<FaultEnum.AlarmSeverity, List<AlarmCount>>();
        try {
            FaultEnum.AlarmSeverity[] severities;
            Set<Long> moIdList = null;
            if (-1L != userId) {
                moIdList = UserMoContainer.getInstance().getMoIdList(userId);
            }
            Collection<AlarmCount> allCountList = AlarmStatisticListener.getAlarmCount(moIdList);
            for (FaultEnum.AlarmSeverity severity : severities = FaultEnum.AlarmSeverity.getAllSeverity()) {
                List<AlarmCount> countList = this.sortCountList(allCountList, severity, topn);
                statisticMap.put(severity, countList);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("getTopnMo error, userId: " + userId + ", topn: " + topn + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return statisticMap;
    }

    private List<AlarmCount> sortCountList(Collection<AlarmCount> allCountList, final FaultEnum.AlarmSeverity severity, int topn) {
        ArrayList<AlarmCount> tmpList = new ArrayList<AlarmCount>();
        tmpList.addAll(allCountList);
        Collections.sort(tmpList, new Comparator<AlarmCount>(){

            @Override
            public int compare(AlarmCount countA, AlarmCount countB) {
                return countB.getCount(severity) - countA.getCount(severity);
            }
        });
        ArrayList<AlarmCount> countList = new ArrayList<AlarmCount>();
        int tmpSize = tmpList.size();
        if (tmpSize > topn) {
            List tmpCountList = tmpList.subList(0, topn);
            for (AlarmCount count : tmpCountList) {
                countList.add(count);
            }
        } else {
            countList.addAll(tmpList);
        }
        return countList;
    }

    public void setFaultUserDao(IFaultUserDao faultUserDao) {
        this.faultUserDao = faultUserDao;
    }
}

