/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.service;

import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.dao.IAlertNotifyDAO;
import com.huawei.lego.nem.fault.sdk.model.AlertAudioSetting;
import com.huawei.lego.nem.fault.sdk.model.AlertSetting;
import com.huawei.lego.nem.fault.sdk.service.IAlertNotifyService;
import java.util.ArrayList;
import java.util.List;

@Service(Name="alertNotifyService", Desc="", Interface=IAlertNotifyService.class)
public class AlertNotifyServiceImpl
extends BaseService
implements IAlertNotifyService {
    private Log logger = LogFactory.getInstance(AlertNotifyServiceImpl.class);
    private IAlertNotifyDAO alertNotifyDAO = null;
    private List<AlertAudioSetting> settingBuffer;

    public List<AlertAudioSetting> getAllAudioSetting() {
        return this.getAudioSettingList();
    }

    public List<AlertAudioSetting> getAudioSettingList() {
        if (null == this.settingBuffer || this.settingBuffer.isEmpty()) {
            this.settingBuffer = this.getAlertSettingList();
        }
        return this.settingBuffer;
    }

    private List<AlertAudioSetting> getAlertSettingList() {
        ArrayList<AlertAudioSetting> audioSettings = new ArrayList<AlertAudioSetting>();
        List<AlertSetting> settingList = this.alertNotifyDAO.getAlertSettingList();
        for (AlertSetting setting : settingList) {
            if (!(setting instanceof AlertAudioSetting)) continue;
            audioSettings.add((AlertAudioSetting)setting);
        }
        return audioSettings;
    }

    public AlertAudioSetting getAudioSetting(long userId) {
        List<AlertAudioSetting> audioSettings = this.getAllAudioSetting();
        for (AlertAudioSetting setting : audioSettings) {
            if (setting.getUserId() != userId) continue;
            return setting;
        }
        AlertAudioSetting setting = new AlertAudioSetting();
        setting.setUserId(userId);
        setting.setEnabled(true);
        setting.setEnabledCritical(true);
        setting.setAudioCritical(1);
        this.alertNotifyDAO.addAlertSetting((AlertSetting)setting);
        this.settingBuffer = this.getAlertSettingList();
        List<AlertAudioSetting> settings = this.getAllAudioSetting();
        for (AlertAudioSetting sett : settings) {
            if (sett.getUserId() != userId) continue;
            return sett;
        }
        return null;
    }

    public boolean setAudioSetting(AlertAudioSetting setting) {
        if (null == setting) {
            this.logger.info((Object)"set AudioSetting failed, setting is null.", 1L);
            return false;
        }
        boolean result = false;
        AlertAudioSetting oldSetting = this.getAudioSetting(setting.getUserId());
        if (null == oldSetting) {
            result = this.alertNotifyDAO.addAlertSetting((AlertSetting)setting);
        } else {
            setting.setEnabled(oldSetting.isEnabled());
            result = this.alertNotifyDAO.updateAlertSetting((AlertSetting)setting);
        }
        if (result) {
            this.settingBuffer = this.getAlertSettingList();
        }
        return result;
    }

    public boolean modifyAudioStatus(long userId, boolean isEnabled) {
        AlertAudioSetting setting = this.getAudioSetting(userId);
        boolean result = false;
        if (null == setting) {
            setting = new AlertAudioSetting();
            setting.setEnabled(isEnabled);
            setting.setUserId(userId);
            result = this.alertNotifyDAO.addAlertSetting((AlertSetting)setting);
        } else {
            setting.setEnabled(isEnabled);
            result = this.alertNotifyDAO.updateAlertSetting((AlertSetting)setting);
        }
        if (result) {
            this.settingBuffer = this.getAlertSettingList();
        }
        return result;
    }

    public IAlertNotifyDAO getAlertNotifyDAO() {
        return this.alertNotifyDAO;
    }

    public void setAlertNotifyDAO(IAlertNotifyDAO alertNotifyDAO) {
        this.alertNotifyDAO = alertNotifyDAO;
    }
}

