/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.service;

import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.nem.fault.dao.IFaultDao;
import com.huawei.lego.nem.fault.dao.IFaultUserDao;
import com.huawei.lego.nem.fault.product.LinkResServiceContainer;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.LegoEvent;
import com.huawei.lego.nem.fault.sdk.service.FaultQueryInfo;
import com.huawei.lego.nem.fault.sdk.service.IEventService;
import com.huawei.lego.nem.fault.util.FaultUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service(Name="eventService", Desc="", Interface=IEventService.class)
public class EventServiceImpl
extends BaseService
implements IEventService {
    private static final String KEY_DATA = "0";
    private static final String KEY_COUNT = "1";
    private Log logger = LogFactory.getInstance(EventServiceImpl.class);
    private IFaultDao faultDao = null;
    private IFaultUserDao faultUserDao = null;
    private ICommonDao commonDao = null;

    public List<LegoEvent> getEventList(long moId) {
        return this.getEventList(moId, -1, -1);
    }

    public List<LegoEvent> getEventList(long moId, int firstRowIndex, int totalRow) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("source", String.valueOf(moId));
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(firstRowIndex);
        queryInfo.setTotalRow(totalRow);
        queryInfo.setOrderByField("eventId");
        queryInfo.setOrderByAscend(false);
        List<?> eventList = this.faultDao.queryFaults(Event.class, condition, false, queryInfo);
        if (null == eventList) {
            return new ArrayList<LegoEvent>();
        }
        ArrayList<LegoEvent> resultList = new ArrayList<LegoEvent>();
        for (int i = 0; i < eventList.size(); ++i) {
            LegoEvent legoEvent = FaultUtil.eventToLegoEvent((Event)eventList.get(i));
            resultList.add(legoEvent);
        }
        return resultList;
    }

    public LegoEvent getEvent(int id) {
        Event event = null;
        try {
            event = (Event)this.commonDao.get(Event.class, NumberUtil.convertToLong((Object)id));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Exception when getEvent", (long)101L, null, (Log)this.logger);
        }
        if (null == event) {
            throw new LegoCheckedException(1542L);
        }
        return FaultUtil.eventToLegoEvent(event);
    }

    public List<LegoEvent> getEvents(int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        List<?> eventList = null;
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(firstRowIndex);
        queryInfo.setTotalRow(totalRow);
        queryInfo.setOrderByField(orderByField);
        queryInfo.setOrderByAscend(orderByAscend);
        eventList = userId >= 0L ? this.faultUserDao.queryFaults(Event.class, null, false, queryInfo, userId) : this.faultDao.queryFaults(Event.class, null, false, queryInfo);
        ArrayList<LegoEvent> resultList = new ArrayList<LegoEvent>();
        if (null == eventList) {
            return resultList;
        }
        for (int i = 0; i < eventList.size(); ++i) {
            LegoEvent legoEvent = FaultUtil.eventToLegoEvent((Event)eventList.get(i));
            resultList.add(legoEvent);
        }
        return resultList;
    }

    public Map<String, Object> getEventsAndAllCount(int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        List<LegoEvent> eventList = this.getEvents(firstRowIndex, totalRow, orderByField, orderByAscend, userId);
        Integer count = this.getEventCount(userId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(KEY_DATA, eventList);
        resultMap.put(KEY_COUNT, count);
        return resultMap;
    }

    public Integer getEventCount(long userId) {
        if (userId >= 0L) {
            return this.faultUserDao.getFaultCount(Event.class, null, false, userId);
        }
        return this.faultDao.getFaultCount(Event.class, null, false);
    }

    public List<LegoEvent> getAllEvents(String orderByField, boolean orderByAscend, long userId) {
        return this.getEventsByName(null, -1, -1, orderByField, orderByAscend, userId);
    }

    public List<LegoEvent> getEventsByName(String eventSource, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        if (null == eventSource || eventSource.trim().equals("")) {
            return this.getEvents(firstRowIndex, totalRow, orderByField, orderByAscend, userId);
        }
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("moName", eventSource.trim());
        List<?> eventList = null;
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(firstRowIndex);
        queryInfo.setTotalRow(totalRow);
        queryInfo.setOrderByField(orderByField);
        queryInfo.setOrderByAscend(orderByAscend);
        eventList = userId >= 0L ? this.faultUserDao.queryFaults(Event.class, condition, true, queryInfo, userId) : this.faultDao.queryFaults(Event.class, condition, true, queryInfo);
        ArrayList<LegoEvent> resultListh = new ArrayList<LegoEvent>();
        if (null == eventList) {
            return resultListh;
        }
        for (int i = 0; i < eventList.size(); ++i) {
            LegoEvent legoEvent = FaultUtil.eventToLegoEvent((Event)eventList.get(i));
            resultListh.add(legoEvent);
        }
        return resultListh;
    }

    public Map<String, Object> getEventsAndAllCountByName(String eventSource, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        List<LegoEvent> eventList = this.getEventsByName(eventSource, firstRowIndex, totalRow, orderByField, orderByAscend, userId);
        Integer count = this.getEventCountByName(eventSource, userId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(KEY_DATA, eventList);
        resultMap.put(KEY_COUNT, count);
        return resultMap;
    }

    public List<LegoEvent> getAllEventsByName(String eventName, String orderByField, boolean orderByAscend, long userId) {
        return this.getEventsByName(eventName, -1, -1, orderByField, orderByAscend, userId);
    }

    public Integer getEventCountByName(String eventSource, long userId) {
        if (eventSource == null || eventSource.trim().equals("")) {
            return this.getEventCount(userId);
        }
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("moName", eventSource.trim());
        if (userId >= 0L) {
            return this.faultUserDao.getFaultCount(Event.class, condition, true, userId);
        }
        return this.faultDao.getFaultCount(Event.class, condition, true);
    }

    public List<LegoEvent> getEventsByCondition(Map<String, String> condition, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        List<?> eventList = null;
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(firstRowIndex);
        queryInfo.setTotalRow(totalRow);
        queryInfo.setOrderByField(orderByField);
        queryInfo.setOrderByAscend(orderByAscend);
        eventList = userId >= 0L ? this.faultUserDao.queryFaults(Event.class, condition, false, queryInfo, userId) : this.faultDao.queryFaults(Event.class, condition, false, queryInfo);
        ArrayList<LegoEvent> resultListxx = new ArrayList<LegoEvent>();
        if (null == eventList) {
            return resultListxx;
        }
        for (int i = 0; i < eventList.size(); ++i) {
            LegoEvent legoEvent = FaultUtil.eventToLegoEvent((Event)eventList.get(i));
            resultListxx.add(legoEvent);
        }
        return resultListxx;
    }

    public Map<String, Object> getEventsAndAllCountByCondition(Map<String, String> condition, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        List<LegoEvent> eventList = this.getEventsByCondition(condition, firstRowIndex, totalRow, orderByField, orderByAscend, userId);
        Integer count = this.getEventCountByCondition(condition, userId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(KEY_DATA, eventList);
        resultMap.put(KEY_COUNT, count);
        return resultMap;
    }

    public List<LegoEvent> getAllEventsByCondition(Map<String, String> condition, String orderByField, boolean orderByAscend, long userId) {
        return this.getEventsByCondition(condition, -1, -1, orderByField, orderByAscend, userId);
    }

    public Integer getEventCountByCondition(Map<String, String> condition, long userId) {
        if (userId >= 0L) {
            return this.faultUserDao.getFaultCount(Event.class, condition, false, userId);
        }
        return this.faultDao.getFaultCount(Event.class, condition, false);
    }

    public List<LegoEvent> getEventsByIds(List<Integer> ids, String orderField, boolean orderByAscend) {
        List<?> eventList = this.faultDao.getEventsByIds(Event.class, ids, orderField, orderByAscend);
        ArrayList<LegoEvent> resultList = new ArrayList<LegoEvent>();
        if (null == eventList) {
            return resultList;
        }
        for (int i = 0; i < eventList.size(); ++i) {
            LegoEvent legoEvent = FaultUtil.eventToLegoEvent((Event)eventList.get(i));
            resultList.add(legoEvent);
        }
        return resultList;
    }

    public void setFaultDao(IFaultDao faultDao) {
        this.faultDao = faultDao;
    }

    public void setFaultUserDao(IFaultUserDao faultUserDao) {
        this.faultUserDao = faultUserDao;
    }

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }

    public boolean isLinkAlarmRes() {
        return LinkResServiceContainer.isShowLinkRes();
    }
}

