/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.service;

import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.dao.IFaultDefineDAO;
import com.huawei.lego.nem.fault.define.FaultDefineCacher;
import com.huawei.lego.nem.fault.launcher.impl.TrapReceiverLauncher;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.service.IFaultDefineService;
import java.util.ArrayList;
import java.util.List;

@Service(Name="faultDefineService", Desc="", Interface=IFaultDefineService.class)
public class FaultDefineServiceImpl
extends BaseService
implements IFaultDefineService {
    private Log logger = LogFactory.getInstance(FaultDefineServiceImpl.class);
    private IFaultDefineDAO faultDefineDAO = null;

    public boolean registerFaultDefine(List<FaultDefine> faultDefines) {
        if (null == faultDefines) {
            this.logger.info((Object)"batch add FaultDefin failed, faultDefine is null.", 1L);
            return false;
        }
        return this.faultDefineDAO.addFaultDefine(faultDefines);
    }

    public boolean deleteAllFaultDefine() {
        return this.faultDefineDAO.deleteAllFaultDefine();
    }

    public List<FaultDefine> getFaultDefineList(String moMainType, String moSubType, FaultEnum.AlarmType faultType) {
        ArrayList<FaultDefine> faultDefines = new ArrayList<FaultDefine>();
        if (null == moMainType || null == moSubType || null == faultType) {
            this.logger.info((Object)"getFaultDefineList failed, moType or faultType is null.", 1L);
            return faultDefines;
        }
        return this.faultDefineDAO.getFaultDefineList(moMainType, moSubType, faultType);
    }

    public List<FaultDefine> getFaultDefineList(String moMainType, String moSubType, FaultEnum.AlarmSeverity[] severities) {
        ArrayList<FaultDefine> faultDefines = new ArrayList<FaultDefine>();
        if (null == moSubType || null == severities) {
            this.logger.info((Object)"getFaultDefineList failed, moType or severities is null.", 1L);
            return faultDefines;
        }
        return this.faultDefineDAO.getFaultDefineList(moMainType, moSubType, severities);
    }

    public List<FaultDefine> getFaultDefineList(String moMainType, String moSubType, FaultEnum.AlarmSeverity[] severities, FaultEnum.TrapType[] trapTypes) {
        ArrayList<FaultDefine> faultDefines = new ArrayList<FaultDefine>();
        if (null == moSubType || null == severities || null == trapTypes) {
            this.logger.info((Object)"getFaultDefineList failed, moType or severities or trapTypes is null.", 1L);
            return faultDefines;
        }
        return this.faultDefineDAO.getFaultDefineList(moMainType, moSubType, severities, trapTypes);
    }

    public List<FaultDefine> getFaultDefineListByOid(String trapOid, String moMainType, String moSubType) {
        return TrapReceiverLauncher.getFaultDefineListByOid(trapOid, moMainType, moSubType);
    }

    public IFaultDefineDAO getFaultDefineDAO() {
        return this.faultDefineDAO;
    }

    public void setFaultDefineDAO(IFaultDefineDAO faultDefineDAO) {
        this.faultDefineDAO = faultDefineDAO;
    }

    public FaultDefine getFaultDefine(String faultId, String moMainType, String moSubType) {
        return FaultDefineCacher.getFaultDefineByFaultId(faultId, moMainType, moSubType);
    }

    public boolean checkFaultIsExist(String[] alarmInfo) {
        return this.faultDefineDAO.checkFaultIsExist(alarmInfo);
    }
}

