/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.service;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.FaultApplication;
import com.huawei.lego.nem.fault.define.FaultDefineUtil;
import com.huawei.lego.nem.fault.msg.FaultMsgCenter;
import com.huawei.lego.nem.fault.msg.FaultMsgType;
import com.huawei.lego.nem.fault.persistence.IFaultPersistence;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.model.LegoEvent;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import com.huawei.lego.nem.fault.util.FaultUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

@Service(Name="faultGenerateService", Desc="", Interface=IFaultGenerateService.class)
public class FaultGenerateServiceImpl
extends BaseService
implements IFaultGenerateService {
    private static final int NORTH_MOID = 0;
    private ManagedObject legoMo = null;
    private Log logger = LogFactory.getInstance(FaultGenerateServiceImpl.class);
    private IFaultPersistence faultPersistence = null;

    public boolean generateLegoAlarm(LegoAlarm legoAlarm) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("generateLegoAlarm:alarmId:");
        buffer.append(legoAlarm.getAlarmId());
        buffer.append(",entity:");
        buffer.append(legoAlarm.getEntity());
        buffer.append(",clearStatus:");
        buffer.append(legoAlarm.getClearStatus());
        buffer.append(",alarmTime:");
        buffer.append(legoAlarm.getAlarmTime());
        this.logger.debug((Object)buffer.toString(), 1L);
        this.setLegoMoProp(legoAlarm);
        return FaultMsgCenter.sendMessage(FaultMsgType.ALARM, legoAlarm);
    }

    public boolean generateLegoRestoreAlarm(LegoAlarm legoAlarm) {
        if (!this.checkParamsIsValid(legoAlarm)) {
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("generateLegoRestoreAlarm:alarmId:");
        buffer.append(legoAlarm.getAlarmId());
        buffer.append(",entity:");
        buffer.append(legoAlarm.getEntity());
        buffer.append(",clearStatus:");
        buffer.append(legoAlarm.getClearStatus());
        buffer.append(",clearTime:");
        buffer.append(legoAlarm.getClearTime());
        this.logger.debug((Object)buffer.toString(), 1L);
        this.setLegoMoProp(legoAlarm);
        return FaultMsgCenter.sendRestoreMessage(FaultMsgType.RESTORE_ALARM, legoAlarm);
    }

    public boolean generateAlarm(LegoAlarm legoAlarm) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("generateAlarm:alarmId:");
        buffer.append(legoAlarm.getAlarmId());
        buffer.append(",entity:");
        buffer.append(legoAlarm.getEntity());
        buffer.append(",clearStatus:");
        buffer.append(legoAlarm.getClearStatus());
        buffer.append(",alarmTime:");
        buffer.append(legoAlarm.getAlarmTime());
        this.logger.debug((Object)buffer.toString(), 1L);
        return FaultMsgCenter.sendMessage(FaultMsgType.ALARM, legoAlarm);
    }

    public boolean generateRestoreAlarm(LegoAlarm legoAlarm) {
        if (!this.checkParamsIsValid(legoAlarm)) {
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("generateRestoreAlarm:alarmId:");
        buffer.append(legoAlarm.getAlarmId());
        buffer.append(",entity:");
        buffer.append(legoAlarm.getEntity());
        buffer.append(",clearStatus:");
        buffer.append(legoAlarm.getClearStatus());
        buffer.append(",clearTime:");
        buffer.append(legoAlarm.getClearTime());
        this.logger.debug((Object)buffer.toString(), 1L);
        return FaultMsgCenter.sendRestoreMessage(FaultMsgType.RESTORE_ALARM, legoAlarm);
    }

    public boolean generateNorthAlarm(LegoAlarm legoAlarm) {
        if (!this.checkParamsIsValid(legoAlarm)) {
            return false;
        }
        legoAlarm.setMoId(0L);
        if (legoAlarm.getMoName().equals("Management System")) {
            legoAlarm.setMoName(legoAlarm.getMoIP());
        }
        return FaultMsgCenter.sendMessage(FaultMsgType.ALARM, legoAlarm);
    }

    public boolean generateNorthRestoreAlarm(LegoAlarm legoAlarm) {
        if (!this.checkParamsIsValid(legoAlarm)) {
            return false;
        }
        legoAlarm.setMoId(0L);
        if (legoAlarm.getMoName().equals("Management System")) {
            legoAlarm.setMoName(legoAlarm.getMoIP());
        }
        return FaultMsgCenter.sendRestoreMessage(FaultMsgType.RESTORE_ALARM, legoAlarm);
    }

    public boolean generateEvent(LegoEvent legoEvent) {
        try {
            Event event = FaultUtil.legoEventToEvent(legoEvent);
            if (null != event) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("generateEvent:eventId:");
                buffer.append(event.getEventId());
                buffer.append(",eventTime:");
                buffer.append(event.getTime());
                this.logger.info((Object)buffer.toString(), 1L);
                FaultDefineUtil.appendDefineProps(event);
                this.faultPersistence.addEvent(event);
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception occured when generateEvent." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return false;
    }

    private void setLegoMoProp(LegoAlarm legoAlarm) {
        if (null == this.legoMo) {
            FaultApplication faultApp = (FaultApplication)super.getContainer();
            this.legoMo = faultApp.getLegoSystem();
        }
        legoAlarm.setMoId(this.legoMo.getMoId().longValue());
        String installServerIp = this.getInstallServerIp();
        legoAlarm.setMoIP(installServerIp);
        legoAlarm.setNmsIp(installServerIp);
        legoAlarm.setMoName(this.legoMo.getName());
        legoAlarm.setMoUuid(this.legoMo.getUuid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInstallServerIp() {
        String current;
        String ip = "";
        String legoinstallPath = "/monitor/RDInstalled.xml";
        String realPath = "";
        try {
            current = new File(System.getProperty("user.dir")).getCanonicalPath();
        }
        catch (IOException e) {
            this.logger.error((Object)("get current path failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            current = null;
        }
        if (null == current) {
            this.logger.error((Object)"null user.dir", 1L);
            return ip;
        }
        String legoruntime = "/LegoRuntime";
        int i = current.length() - legoruntime.length();
        String newCurrentPath = "";
        if (i >= 0) {
            newCurrentPath = current.substring(0, i);
        }
        realPath = newCurrentPath + legoinstallPath;
        SAXReader reader = new SAXReader();
        FileInputStream inputStream = null;
        Document document = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
            inputStream = new FileInputStream(realPath);
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            document = reader.read((InputStream)inputStream);
            if (null == document) {
                this.logger.error((Object)"The document is null.", 1L);
                String string = ip;
                return string;
            }
            Node floatNode = document.selectSingleNode("//install/floatip");
            if (null != floatNode && null != (ip = floatNode.getText()) && !ip.trim().isEmpty()) {
                this.logger.info((Object)("The lego float ip is:" + ip), 1L);
                String e = ip;
                return e;
            }
            Node httpNode = document.selectSingleNode("//install/httpsip");
            if (null != httpNode) {
                ip = httpNode.getText();
                this.logger.info((Object)("The lego install ip is:" + ip), 1L);
                String string = ip;
                return string;
            }
            String string = ip;
            return string;
        }
        catch (Exception e) {
            this.logger.error((Object)("Get install ip fail, error is:" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            if (null != inputStream) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Close the inputstream failed, error is:", (Throwable)e, 1L);
                }
            }
        }
        return ip;
    }

    private boolean checkParamsIsValid(LegoAlarm alarm) {
        if (null == alarm) {
            this.logger.error((Object)"alarm is null in FaultGenerateService.", 1L);
            return false;
        }
        return true;
    }

    public void setFaultPersistence(IFaultPersistence faultPersistence) {
        this.faultPersistence = faultPersistence;
    }
}

