/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.sync;

import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.core.base.thread.CallableTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.lego.nem.fault.define.FaultDefineCacher;
import com.huawei.lego.nem.fault.launcher.impl.AlarmSyncLauncher;
import com.huawei.lego.nem.fault.msg.FaultMsgCenter;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.AlarmSyncTask;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.model.LegoEvent;
import com.huawei.lego.nem.fault.sync.AlarmSynchronizerBean;
import com.huawei.lego.nem.fault.util.FaultUtil;
import java.util.ArrayList;
import java.util.List;

public class SynchronizeTask<T>
extends CallableTask<Integer> {
    private Log logger = LogFactory.getInstance(SynchronizeTask.class);
    private AlarmSyncTask task;
    private AlarmSynchronizerBean synchronizer;
    private IDiscoveryService discoveryService;
    private IResourceService resService;

    public SynchronizeTask(AlarmSynchronizerBean syncBean, long moId) {
        this.synchronizer = syncBean;
        this.setMoId(moId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        this.logger.info((Object)("call AlarmSynchronize task:" + this.toString()), 1L);
        long moId = 0L;
        try {
            moId = this.getMoId();
            if (null == this.resService.getMOByMoid(Long.valueOf(moId))) {
                this.logger.info((Object)"MO was deleted.", 1L);
                Integer n = 0;
                return n;
            }
            this.discoveryService.lockDeviceBeforeSyncAlarm(Long.valueOf(moId));
            this.logger.info((Object)("AlarmSynchronize Task  lock mo,moid:" + moId), 1L);
            List legoAlarms = this.synchronizer.getService().synchronize(moId);
            int alarmCount = 0;
            if (null == legoAlarms) {
                this.logger.error((Object)("synchronize alarm return null, MoId: " + moId + ", ProductName: " + this.synchronizer.getProductName()), 1L);
            } else {
                alarmCount = legoAlarms.size();
                this.logger.info((Object)("synchronize alarm count: " + alarmCount + ", MoId: " + moId + ", ProductName: " + this.synchronizer.getProductName()), 1L);
                ArrayList<Alarm> alarmList = new ArrayList<Alarm>();
                ArrayList<Event> eventList = new ArrayList<Event>();
                this.setList(legoAlarms, alarmList, eventList, this.synchronizer.getProductName(), this.synchronizer.getTrapoid());
                alarmCount = alarmList.size() + eventList.size();
                this.logger.info((Object)("removeShieldAlarm count: " + alarmCount + ", MoId: " + moId + ", ProductName: " + this.synchronizer.getProductName()), 1L);
                FaultMsgCenter.sendSyncAlarmMsg(this.synchronizer.getProductName(), this.synchronizer.getTrapoid(), alarmList);
                FaultMsgCenter.sendSyncEventMsg(this.synchronizer.getProductName(), this.synchronizer.getTrapoid(), eventList);
            }
            this.task.setResultCount(alarmCount);
            AlarmSyncLauncher.getSynchronizer().updateTask(this.task, 0L);
            this.discoveryService.unlockDeviceAfterSyncAlarm(Long.valueOf(moId));
            this.logger.info((Object)("AlarmSynchronize Task  unlock mo,moid:" + moId), 1L);
            Integer n = alarmCount;
            return n;
        }
        catch (LegoCheckedException e) {
            AlarmSyncLauncher.getSynchronizer().updateTask(this.task, e.getErrorCode());
            this.logger.error((Object)"synchronize LegoCheckedException.", (Throwable)e, 1L);
            throw e;
        }
        catch (Exception e) {
            AlarmSyncLauncher.getSynchronizer().updateTask(this.task, 1551L);
            ExceptionUtil.rethrowException((Throwable)e, (String)"synchronize Exception.", (long)1551L, null, (Log)this.logger);
            Integer n = null;
            return n;
        }
        finally {
            this.discoveryService.unlockDeviceAfterSyncAlarm(Long.valueOf(moId));
        }
    }

    private void setList(List<?> legoAlarms, List<Alarm> alarmList, List<Event> eventList, String productName, String trapoid) {
        for (Object obj : legoAlarms) {
            if (obj instanceof LegoAlarm) {
                LegoAlarm legoAlarm = (LegoAlarm)obj;
                FaultDefine faultDefine = FaultDefineCacher.getFaultDefine(productName, trapoid, legoAlarm.getAlarmId(), legoAlarm.getMoMainType(), legoAlarm.getMoSubType());
                legoAlarm.setFaultDefine(faultDefine);
                Alarm alarm = FaultUtil.legoAlarmToAlarm(legoAlarm);
                alarmList.add(alarm);
                continue;
            }
            if (!(obj instanceof LegoEvent)) continue;
            Event legoEvent = FaultUtil.legoEventToEvent((LegoEvent)obj);
            eventList.add(legoEvent);
        }
    }

    public AlarmSyncTask getTask() {
        return this.task;
    }

    public void setTask(AlarmSyncTask task) {
        this.task = task;
    }

    public void setResService(IResourceService resService) {
        this.resService = resService;
    }

    public void setDiscoveryService(IDiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }
}

