/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.trap;

import com.huawei.lego.core.base.thread.CommonThread;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.AlarmPDU;
import com.huawei.lego.nem.fault.sdk.service.IPDUFilter;
import com.huawei.lego.nem.fault.trap.store.PDUStore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;

public final class PDUDispatcher {
    private static PDUDispatcher sInstance = null;
    private static final int QUEUE_SIZE = 10000;
    private Log logger = LogFactory.getInstance(PDUDispatcher.class);
    private BlockingQueue<AlarmPDU> pduQueue = new LinkedBlockingQueue<AlarmPDU>(10000);
    private List<IPDUFilter> filters = new ArrayList<IPDUFilter>();
    private PDUStore pduStore = new PDUStore();
    private boolean isContinueRunning = true;
    private RunnableFuture<Integer> runnableFuture = null;

    private PDUDispatcher() {
    }

    public static synchronized PDUDispatcher getInstance() {
        if (null == sInstance) {
            sInstance = new PDUDispatcher();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class<PDUDispatcher> clazz = PDUDispatcher.class;
        synchronized (PDUDispatcher.class) {
            final PDUDispatcher pduDispatcher = this;
            CommonThread thread = new CommonThread(){

                @Override
                protected void execute() {
                    pduDispatcher.execute();
                }
            };
            thread.setThreadName("alarm pdu dispatch thread");
            this.runnableFuture = ExecutionService.newTaskFor(thread, 0);
            ExecutionService.submitTask(this.runnableFuture);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void stop() {
        this.isContinueRunning = false;
        if (null != this.runnableFuture) {
            this.runnableFuture.cancel(true);
        }
        this.removeAllPDUFilters();
    }

    public void notifyPDU(AlarmPDU alarmPdu) {
        try {
            if (10000 <= this.pduQueue.size()) {
                this.logger.info((Object)("pduQueue exceeds queue size, current size: " + this.pduQueue.size()), 1L);
                this.pduStore.storePDU(alarmPdu);
                return;
            }
            this.pduQueue.add(alarmPdu);
        }
        catch (Exception e) {
            this.logger.error((Object)("add AlarmPDU to pduQueue failed, store to PDUStore." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            try {
                this.pduStore.storePDU(alarmPdu);
            }
            catch (Exception ex) {
                this.logger.error((Object)("store to PDUStore failed again, AlarmPDU will be discuard: " + alarmPdu.toString() + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
            }
        }
    }

    public void execute() {
        while (this.isContinueRunning) {
            try {
                AlarmPDU alarmPdu = this.pduQueue.take();
                for (IPDUFilter filter : this.filters) {
                    filter.doFilter(alarmPdu);
                }
            }
            catch (InterruptedException e) {
                this.logger.info((Object)"interrupt Thread[alarm pdu dispatch thread].", 1L);
                break;
            }
            catch (Exception e) {
                this.logger.error((Object)("Throwable was caught when in Thread[alarm pdu dispatch thread]." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    public List<IPDUFilter> getPDUFilters() {
        return this.filters;
    }

    public synchronized void registerPDUFilter(IPDUFilter filter) {
        this.filters.add(filter);
    }

    public synchronized void deRegisterPDUFilter(IPDUFilter filter) {
        this.filters.remove(filter);
    }

    public synchronized void removeAllPDUFilters() {
        this.filters.clear();
    }

    public void setFilters(List<IPDUFilter> filters) {
        this.filters = filters;
    }
}

