/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.trap.listener;

import com.huawei.lego.cbb.resource.sdk.service.ICommonService;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import com.huawei.lego.nem.fault.trap.listener.ForceDecodeDefender;
import com.huawei.lego.nem.fault.trap.listener.IForceDecodeAlarmListener;
import java.util.Collection;
import java.util.List;

public class ForceDecodeAlarmListener
implements IForceDecodeAlarmListener {
    private static final int VALUE_2 = 2;
    private IFaultGenerateService alarmService;
    private Log logger = LogFactory.getInstance(ForceDecodeAlarmListener.class);

    @Override
    public void onMessage(String unit) {
        this.logger.info((Object)("##### onMessage: " + unit), 1L);
        this.generateAlarm(unit);
    }

    private String getUuid(String linkIp) {
        try {
            ICommonService commonService = ServiceProvider.getCommonService();
            String sql = "select UUID from T_MANAGEDOBJECT where MOID in (select MOID from TI_NETWORKENTITY where LINKIP = '" + linkIp + "')";
            List list = commonService.findBySql(sql);
            if (!VerifyUtil.isEmpty((Collection)list)) {
                return (String)list.get(0);
            }
            this.logger.debug((Object)("get uuid failue, linkIp = " + linkIp), 1L);
        }
        catch (Exception e) {
            this.logger.error((Object)("get uuid failue, linkIp = " + linkIp + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return null;
    }

    private void generateAlarm(String unit) {
        if (unit == null) {
            this.logger.warn((Object)"Generate alarm failed, unit is null.", 1L);
            return;
        }
        boolean isV2c = false;
        String resouceIp = unit;
        String[] param = unit.split(",");
        if (param.length == 2) {
            resouceIp = param[0];
            isV2c = true;
        }
        String[] alarmParam = new String[]{String.valueOf(resouceIp), String.valueOf("v3")};
        if (isV2c) {
            alarmParam[1] = String.valueOf("v2c");
        }
        String alarmId = "0x000803220101";
        if (null == this.alarmService) {
            this.logger.error((Object)"Generate alarm failed, alarmService is null.", 1L);
            return;
        }
        String uuid = this.getUuid(resouceIp);
        if (null == uuid) {
            return;
        }
        LegoAlarm alarm = new LegoAlarm();
        alarm.setAlarmId(alarmId);
        alarm.setAlarmTime(System.currentTimeMillis());
        alarm.setAlarmParam(alarmParam);
        alarm.setEntity(alarmId + resouceIp);
        alarm.setSourceId(uuid);
        alarm.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
        try {
            this.alarmService.generateLegoAlarm(alarm);
        }
        catch (Exception e) {
            this.logger.error((Object)("alarmService generate LegoRestoreAlarm error." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    public IFaultGenerateService getAlarmService() {
        return this.alarmService;
    }

    public void setAlarmService(IFaultGenerateService alarmService) {
        this.alarmService = alarmService;
    }

    public void register() {
        ForceDecodeDefender.getInstance().registAlarmListener(this);
    }
}

