/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.trap.store;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.AlarmPDU;
import com.huawei.lego.nem.fault.sdk.service.IPDUFilter;
import com.huawei.lego.nem.fault.trap.PDUDispatcher;
import com.huawei.lego.nem.fault.trap.store.PDUStoreUtil;
import java.io.File;
import java.util.List;

public class PDUReader
implements Runnable {
    private static final long CHECK_INTERVAL = 100000L;
    private Log logger = LogFactory.getInstance(PDUReader.class);

    public PDUReader() {
        try {
            boolean isCreate = true;
            File storePath = new File(PDUStoreUtil.getStorePath());
            if (!storePath.exists()) {
                isCreate = storePath.createNewFile();
            }
            if (isCreate) {
                this.deleteAlarmPDUFiles(storePath);
            } else {
                this.logger.error((Object)("create file failed!filename:" + storePath.getName()), 1L);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    CommonUtil.sleep((long)100000L);
                    File storePath = new File(PDUStoreUtil.getStorePath());
                    File[] pduFiles = storePath.listFiles();
                    this.doFilter(pduFiles);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
                continue;
            }
            break;
        }
    }

    private void doFilter(File[] pduFiles) {
        if (pduFiles != null) {
            for (File file : pduFiles) {
                Object pduObj = PDUStoreUtil.readObject(file);
                if (null != pduObj) {
                    AlarmPDU pdu = (AlarmPDU)pduObj;
                    List<IPDUFilter> filters = PDUDispatcher.getInstance().getPDUFilters();
                    for (IPDUFilter filter : filters) {
                        filter.doFilter(pdu);
                    }
                }
                this.deletePDUFile(file);
            }
        }
    }

    private void deletePDUFile(File file) {
        try {
            boolean success = file.delete();
            if (!success && !file.delete()) {
                this.logger.error((Object)("deletePDUFile failed, fileName: " + file.getName()), 1L);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("deletePDUFile failed, fileName: " + file.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    private void deleteAlarmPDUFiles(File storePath) {
        File[] pduFiles = storePath.listFiles();
        if (null != pduFiles) {
            for (File file : pduFiles) {
                this.deletePDUFile(file);
            }
        } else {
            this.logger.error((Object)("Getting pdu files failed. " + storePath.getName()), 1L);
        }
    }
}

