/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.trap.store;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class PDUStoreUtil {
    private static final Log log = LogFactory.getInstance(PDUStoreUtil.class);
    private static final Log LOGGER = LogFactory.getInstance(PDUStoreUtil.class);
    private static String storePath = "";

    private PDUStoreUtil() {
    }

    public static String getStorePath() {
        return storePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeObject(Object obj, String fileName) {
        FileOutputStream fos;
        ObjectOutputStream objectOutputStream;
        block10: {
            block9: {
                boolean state;
                if (!(obj instanceof Serializable)) {
                    LOGGER.error((Object)"Serializable error.", 1L);
                    return;
                }
                File path = new File(storePath);
                if (!path.exists() && !(state = path.mkdir())) {
                    LOGGER.info((Object)("create AlarmPDU StorePath state: " + state), 0L);
                    return;
                }
                objectOutputStream = null;
                fos = null;
                try {
                    File reFile = new File(storePath + fileName);
                    if (!reFile.exists() && !reFile.createNewFile()) {
                        LOGGER.info((Object)"Create AlarmPDU file error.", 0L);
                        CommonUtil.close((Closeable)fos);
                        break block9;
                    }
                    fos = new FileOutputStream(reFile);
                    objectOutputStream = new ObjectOutputStream(fos);
                    objectOutputStream.writeObject(obj);
                    objectOutputStream.flush();
                    LOGGER.info((Object)"Save AlarmPDU file success.", 0L);
                    CommonUtil.close((Closeable)fos);
                    break block10;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Write object to AlarmPDU file error." + ExceptionUtil.getErrorMessage((Throwable)e)), 0L);
                    return;
                }
            }
            CommonUtil.close(objectOutputStream);
            return;
        }
        CommonUtil.close((Closeable)objectOutputStream);
        return;
        finally {
            CommonUtil.close(fos);
            CommonUtil.close(objectOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object readObject(File reFile) {
        Object object;
        if (!reFile.exists()) {
            return null;
        }
        FileInputStream fis = null;
        ObjectInputStream inputStream = null;
        try {
            fis = new FileInputStream(reFile);
            inputStream = new ObjectInputStream(fis);
            object = inputStream.readObject();
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)("Read info from AlarmPDU file error." + ExceptionUtil.getErrorMessage((Throwable)e)), 0L);
            }
            catch (Throwable throwable) {
                CommonUtil.close(fis);
                CommonUtil.close(inputStream);
                throw throwable;
            }
            CommonUtil.close((Closeable)fis);
            CommonUtil.close((Closeable)inputStream);
            return null;
        }
        CommonUtil.close((Closeable)fis);
        CommonUtil.close((Closeable)inputStream);
        return object;
    }

    static {
        String ptmp = "";
        try {
            ptmp = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            log.error((Object)"PDUStoreUtil getCanonicalPath() error!", 102L);
        }
        storePath = ptmp + File.separator + "state/traps" + File.separator;
    }
}

