/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.util;

import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.nem.fault.util.XmlParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class XmlDomParser
extends XmlParser {
    private static DocumentBuilder sDocumentBuilder;
    private Document doc;
    private ClassLoader loader = this.getClass().getClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDomParser(InputStream is) throws SAXException, IOException {
        DocumentBuilder documentBuilder = sDocumentBuilder;
        synchronized (documentBuilder) {
            this.doc = sDocumentBuilder.parse(is);
            this.doc.getDocumentElement().normalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDomParser(File file) throws SAXException, IOException {
        DocumentBuilder documentBuilder = sDocumentBuilder;
        synchronized (documentBuilder) {
            this.doc = sDocumentBuilder.parse(file);
            this.doc.getDocumentElement().normalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDomParser(String filePathRelativeToJar) throws SAXException, IOException {
        DocumentBuilder documentBuilder = sDocumentBuilder;
        synchronized (documentBuilder) {
            if (this.loader == null) {
                throw new FileNotFoundException("file " + filePathRelativeToJar + " can't find because loader is null");
            }
            URL url = this.loader.getResource(filePathRelativeToJar);
            if (url == null) {
                throw new FileNotFoundException("file " + filePathRelativeToJar + " can't find");
            }
            this.doc = sDocumentBuilder.parse(url.toString());
            this.doc.getDocumentElement().normalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDomParser(String filePathRelativeToJar, ClassLoader cl) throws SAXException, IOException {
        DocumentBuilder documentBuilder = sDocumentBuilder;
        synchronized (documentBuilder) {
            URL url = cl.getResource(filePathRelativeToJar);
            if (url == null) {
                throw new FileNotFoundException("file " + filePathRelativeToJar + " can't find");
            }
            this.doc = sDocumentBuilder.parse(url.toString());
            this.doc.getDocumentElement().normalize();
            this.setClassLoader(cl);
        }
    }

    private void setClassLoader(ClassLoader cl) {
        this.loader = cl;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public String getAttributeValueOfElementNode(Node node, String attributeName) {
        if (attributeName != null) {
            Node attributeNode = node.getAttributes().getNamedItem(attributeName);
            return attributeNode.getTextContent();
        }
        return "";
    }

    @Override
    public String getTextContentOfChild(Element parent, String childTagName) {
        String result = null;
        Node node = parent.getFirstChild();
        while (null != node) {
            if (!(node instanceof Element)) {
                node = node.getNextSibling();
                continue;
            }
            Element element = (Element)node;
            String tagName = element.getTagName();
            String content = element.getTextContent();
            if (childTagName.equals(tagName)) {
                result = content.trim();
                break;
            }
            node = node.getNextSibling();
        }
        return result;
    }

    @Override
    public Element treeWalkOfOneElementNode(Element node, String tagName) {
        return this.treeWalkOfOneElementNode(node, tagName, null, null);
    }

    @Override
    public Element treeWalkOfOneElementNode(Element parentNode, String tagName, String attributeName, String attributeValue) {
        NodeList nodeList = parentNode.getElementsByTagName(tagName);
        return this.treeWalkOfOneElementFromNodeList(nodeList, attributeName, attributeValue);
    }

    @Override
    public Element treeWalkOfOneElementNode(String tagName) {
        return this.treeWalkOfOneElementNode(tagName, null, null);
    }

    @Override
    public Element treeWalkOfOneElementNode(String tagName, String attributeName, String attributeValue) {
        NodeList nodeList = this.doc.getElementsByTagName(tagName);
        return this.treeWalkOfOneElementFromNodeList(nodeList, attributeName, attributeValue);
    }

    @Override
    public Collection<Element> getChildren(Element parent, String childTagName) {
        ArrayList<Element> children = new ArrayList<Element>();
        for (Node child = parent.getFirstChild(); null != child; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            children.add(element);
        }
        return children;
    }

    @Override
    public Element getChild(Element parent, String childTagName) {
        Element result = null;
        for (Node child = parent.getFirstChild(); null != child; child = child.getNextSibling()) {
            Element element;
            String tagName;
            if (!(child instanceof Element) || !(tagName = (element = (Element)child).getTagName()).equals(childTagName)) continue;
            result = element;
            break;
        }
        return result;
    }

    @Override
    public Collection<Element> getChildren(Element parent) {
        return this.getChildren(parent, null);
    }

    private Element treeWalkOfOneElementFromNodeList(NodeList nodeList, String attributeName, String attributeValue) {
        Element findNode = null;
        int nodeSize = nodeList.getLength();
        for (int i = 0; i < nodeSize; ++i) {
            Element node = (Element)nodeList.item(i);
            if (null == attributeName || null == attributeValue) {
                findNode = node;
                continue;
            }
            Node attributeNode = node.getAttributes().getNamedItem(attributeName);
            if (null == attributeNode || !attributeValue.equalsIgnoreCase(attributeNode.getTextContent())) continue;
            findNode = node;
        }
        return findNode;
    }

    static {
        DocumentBuilderFactory docBuilderFac = DocumentBuilderFactory.newInstance();
        docBuilderFac.setIgnoringElementContentWhitespace(true);
        try {
            CommonUtil.setSecurityFeatures((DocumentBuilderFactory)docBuilderFac);
            sDocumentBuilder = docBuilderFac.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LogFactory.getInstance(XmlDomParser.class);
        }
    }
}

