/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.framework;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;

public final class AppContext {
    private static final ConcurrentHashMap<String, Object> TABLE = new ConcurrentHashMap();
    private static AppContext instance = new AppContext();
    private static final String APP_HOME_PATH = "beetle.application.home.path";

    private AppContext() {
    }

    public String getAppHome() {
        String appHome = null;
        String fp = System.getProperty(APP_HOME_PATH);
        if (fp != null && !fp.trim().isEmpty()) {
            appHome = this.normalizePath(fp);
        } else {
            String ap = (String)AppContext.getInstance().lookup(APP_HOME_PATH);
            if (ap != null && !ap.trim().isEmpty()) {
                appHome = this.normalizePath(ap);
            }
        }
        if (null != appHome) {
            return appHome;
        }
        return "config/";
    }

    public void close() {
        if (!TABLE.isEmpty()) {
            TABLE.clear();
        }
    }

    public Object lookup(String name) {
        return TABLE.get(name);
    }

    public static AppContext getInstance() {
        return instance;
    }

    private String normalizePath(String path) {
        if (null == path || path.trim().isEmpty()) {
            return null;
        }
        if (this.isUri(path)) {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            return path;
        }
        try {
            path = new File(path).getCanonicalPath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            return path;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isUri(String path) {
        try {
            URI uri = new URI(path);
            return null != uri.getScheme();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

