/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import org.wcc.framework.AppContext;
import org.wcc.framework.AppRuntimeException;

public final class AppProperties {
    private static Properties appPpt = new Properties();

    public static void load() {
        InputStream in = AppProperties.searchProp();
        if (null == in) {
            return;
        }
        try {
            appPpt.load(in);
        }
        catch (IOException e) {
            throw new AppRuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                AppProperties.nop();
            }
        }
    }

    public static void clear() {
        appPpt.clear();
    }

    public static int getAsInt(String key, int defaultValue) {
        String a = AppProperties.get(key);
        if (a == null || a.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(a.trim());
    }

    public static Properties getProperties() {
        return appPpt;
    }

    public static String get(String key) {
        return appPpt.getProperty(key);
    }

    public static String get(String key, String defaultValue) {
        String a = AppProperties.get(key);
        if (a == null) {
            return defaultValue;
        }
        return a;
    }

    public static boolean getAsBoolean(String key, boolean defaultValue) {
        String a = AppProperties.get(key);
        if (a == null || a.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(a.trim());
    }

    public static String getAppHome() {
        return AppContext.getInstance().getAppHome();
    }

    private static InputStream searchProp() {
        InputStream result = null;
        String fp = AppProperties.getAppHome();
        String filenamePath = fp.trim().length() > 0 ? fp + "application.properties" : "config/application.properties";
        File f = new File(filenamePath);
        if (f.exists()) {
            try {
                FileInputStream bis = new FileInputStream(f);
                result = bis;
            }
            catch (FileNotFoundException e) {
                AppProperties.systemErr("Exception: [application.properties] not found");
            }
            catch (Exception ex) {
                AppProperties.nop();
            }
        } else {
            try {
                InputStream is;
                result = is = AppProperties.getResAsStream(filenamePath);
            }
            catch (IOException e) {
                AppProperties.nop();
            }
        }
        return result;
    }

    private static void systemErr(String info) {
        PrintStream ps = System.err;
        ps.println(info);
    }

    private static void nop() {
    }

    private static InputStream getResAsStream(String resource) throws IOException {
        return AppProperties.getResAsStream(Thread.currentThread().getContextClassLoader(), resource);
    }

    private static InputStream getResAsStream(ClassLoader loader, String resource) throws IOException {
        InputStream in = null;
        if (loader != null) {
            in = loader.getResourceAsStream(resource);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(resource);
        }
        if (in == null) {
            URL url = new URL(resource);
            in = url.openStream();
        }
        return in;
    }

    static {
        AppProperties.load();
    }
}

