/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.constant.cloudenum;

import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.FmNetwork;
import com.huawei.ism.drm.galax.sdk.model.PortGroup;
import com.huawei.ism.drm.galax.sdk.model.SecurityGroup;
import com.huawei.ism.drm.galax.sdk.model.VDC;
import com.huawei.ism.drm.galax.sdk.model.VPC;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import java.util.HashMap;
import java.util.Map;

public enum ResTypeEnum {
    CLUSTER_RESOURCE(0, "CLUSTER:"),
    COMPUTE_NODE(1, "HOST:"),
    PORT_GROUP(2, "PORTGROUP:"),
    NETWORK(3, "NETWORK:"),
    SECURITY_GROUP(4, "SECURITYGROUP:"),
    VRG(5, "VRG:"),
    DATASTORE(6, "DATASTORE:"),
    VDC(7, "VDC:"),
    VPC(99, "VPC:");

    private static Map<ResTypeEnum, Class<? extends ManagedObject>> mapResTypeToCls;
    private int resType;
    private String resTag;

    private ResTypeEnum(int type, String tag) {
        this.resType = type;
        this.resTag = tag;
    }

    public int getResType() {
        return this.resType;
    }

    public String getResTag() {
        return this.resTag;
    }

    public static ResTypeEnum getResType(int resType) {
        ResTypeEnum[] types;
        for (ResTypeEnum type : types = ResTypeEnum.values()) {
            if (resType != type.getResType()) continue;
            return type;
        }
        return null;
    }

    public static Class<? extends ManagedObject> getResClass(int resType) {
        ResTypeEnum type = ResTypeEnum.getResType(resType);
        if (null == type) {
            return null;
        }
        return mapResTypeToCls.get((Object)type);
    }

    static {
        mapResTypeToCls = new HashMap<ResTypeEnum, Class<? extends ManagedObject>>();
        mapResTypeToCls.put(CLUSTER_RESOURCE, ComputeCluster.class);
        mapResTypeToCls.put(COMPUTE_NODE, ComputeNode.class);
        mapResTypeToCls.put(PORT_GROUP, PortGroup.class);
        mapResTypeToCls.put(NETWORK, FmNetwork.class);
        mapResTypeToCls.put(SECURITY_GROUP, SecurityGroup.class);
        mapResTypeToCls.put(VPC, VPC.class);
        mapResTypeToCls.put(DATASTORE, DataStore.class);
        mapResTypeToCls.put(VDC, VDC.class);
        mapResTypeToCls.put(VRG, VRG.class);
    }
}

