/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.sdk.model;

import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import java.util.ArrayList;
import java.util.List;

public class PgAlarmInfo {
    private ProtectGroup pg;
    private VRM vrm;
    private String type;
    private String oldDsgId;
    private List<ProtectObject> listDelete = new ArrayList<ProtectObject>();
    private List<GalaxVM> listVmValid = new ArrayList<GalaxVM>();
    private List<GalaxVM> listVmInvalid = new ArrayList<GalaxVM>();
    private List<GalaxVM> listCannotBeProtectedVm = new ArrayList<GalaxVM>();
    private List<ProtectObject> leftMovedPoVm = new ArrayList<ProtectObject>();
    private boolean connected = true;

    public PgAlarmInfo() {
    }

    public PgAlarmInfo(VRM vrm, ProtectGroup pg) {
        this();
        this.vrm = vrm;
        this.pg = pg;
        this.oldDsgId = (String)pg.getProps().get(PgExParamsEnum.PG_DATASTOREGROUP_ID.getValue());
    }

    public VRM getVrm() {
        return this.vrm;
    }

    public void setVrm(VRM vrm) {
        this.vrm = vrm;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public ProtectGroup getPg() {
        return this.pg;
    }

    public void setPg(ProtectGroup pg) {
        this.pg = pg;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOldDsgId() {
        return this.oldDsgId;
    }

    public void setOldDsgId(String oldDsgId) {
        this.oldDsgId = oldDsgId;
    }

    public List<ProtectObject> getListDelete() {
        return this.listDelete;
    }

    public void setListDelete(List<ProtectObject> listDelete) {
        this.listDelete = listDelete;
    }

    public List<GalaxVM> getListVmValid() {
        return this.listVmValid;
    }

    public void setListVmValid(List<GalaxVM> listVmValid) {
        this.listVmValid = listVmValid;
    }

    public List<GalaxVM> getListVmInvalid() {
        return this.listVmInvalid;
    }

    public void setListVmInvalid(List<GalaxVM> listVmInvalid) {
        this.listVmInvalid = listVmInvalid;
    }

    public List<GalaxVM> getListCannotBeProtectedVm() {
        return this.listCannotBeProtectedVm;
    }

    public void setListCannotBeProtectedVm(List<GalaxVM> listCannotBeProtectedVm) {
        this.listCannotBeProtectedVm = listCannotBeProtectedVm;
    }

    public List<ProtectObject> getLeftMovedPoVm() {
        return this.leftMovedPoVm;
    }

    public void setLeftMovedPoVm(List<ProtectObject> leftMovedPoVm) {
        this.leftMovedPoVm = leftMovedPoVm;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.getDeleteAndMovedPoName(sb);
        this.getOtherVmName(sb, "valid", this.listVmValid);
        this.getOtherVmName(sb, "Invalid", this.listVmInvalid);
        this.getOtherVmName(sb, "CannotBeProtected", this.listCannotBeProtectedVm);
        StringBuilder bui = new StringBuilder();
        bui.append("PgAlarmInfo [pgName=").append(this.pg.getName()).append(", type=").append(this.type).append(", oldDsgId=").append(this.oldDsgId).append(sb.toString()).append(", connected=").append(this.connected).append("]");
        return bui.toString();
    }

    private void getDeleteAndMovedPoName(StringBuffer sb) {
        sb.append("The delete pos are ");
        for (ProtectObject po : this.listDelete) {
            sb.append(po.getName()).append("; ");
        }
        sb.append("The moved pos are ");
        for (ProtectObject po : this.leftMovedPoVm) {
            sb.append(po.getName()).append("; ");
        }
    }

    private void getOtherVmName(StringBuffer sb, String name, List<GalaxVM> list) {
        sb.append("The " + name + " vms are ");
        for (GalaxVM vm : list) {
            sb.append(vm.getName()).append("; ");
        }
    }
}

