/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.sdk.pg.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FixLengthProps {
    private Map<String, String> props;
    private int maxLen = 0;

    public FixLengthProps(Map<String, String> props) {
        if (null == props) {
            throw new IllegalArgumentException();
        }
        this.props = props;
    }

    public FixLengthProps(Map<String, String> props, int maxLen) {
        this(props);
        this.maxLen = maxLen;
        this.init();
    }

    private void init() {
        if (this.maxLen <= 0 || this.props.isEmpty()) {
            return;
        }
        HashMap<String, String> oldprops = new HashMap<String, String>(this.props);
        this.props.clear();
        Set entrySet = oldprops.entrySet();
        for (Map.Entry entry : entrySet) {
            this.setProp((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setProp(String key, String value) {
        if (null == value) {
            throw new IllegalArgumentException(key);
        }
        if (this.maxLen <= 0) {
            this.props.put(key, value);
            return;
        }
        int mark = 0;
        String newKey = key;
        while (value.length() > this.maxLen) {
            String temp = value.substring(0, this.maxLen);
            value = value.substring(this.maxLen);
            this.props.put(newKey, temp);
            newKey = key + mark;
            ++mark;
        }
        this.props.put(newKey, value);
    }

    public String getValue(String key) {
        String temp;
        if (this.maxLen <= 0) {
            return this.props.get(key);
        }
        StringBuffer sb = new StringBuffer();
        int mark = 0;
        String newKey = key;
        do {
            if (null != (temp = this.props.get(newKey))) {
                sb.append(temp);
            }
            newKey = key + mark;
            ++mark;
        } while (null != temp && temp.length() >= this.maxLen);
        return sb.toString();
    }
}

