/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.sdk.proxy;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.drm.galax.constant.cloudenum.CloudParamType;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.vrm.model.OsOptionsType;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class VmMgrInfoBase {
    private static final int HASHCODE_KEY = 31;
    private String name;
    private String uuid;
    private String description;
    private String vmType;
    private boolean hostLoc;
    private String location;
    private boolean template;
    private boolean linkClone;
    private String osOption;
    private String vmConfig;
    private String vmUriOrId;
    private String urn;
    private Boolean isMultiDiskSpeedup;
    private String confidentialityLevel;
    private Map<String, List<String>> mapSrcdsurnToLunId = new HashMap<String, List<String>>();
    private Map<String, String> extendParams = new HashMap<String, String>();

    public VmMgrInfoBase() {
    }

    public VmMgrInfoBase(GalaxVM vm) {
        if (null == vm) {
            return;
        }
        this.setVmInfo(vm);
    }

    public VmMgrInfoBase(GalaxVM vm, ResourcepoolVMServiceV2Stub.VMInfo0 vmInfo) {
        if (null == vm) {
            return;
        }
        this.setVmInfo(vm);
        if (!GalaxVM.VMProviderType.FM.getValue().equals(vm.getProviderID()) || null == vmInfo) {
            return;
        }
        this.extendParams.put(CloudParamType.VPC_ID.getValue(), vmInfo.getVpcID());
        this.vmUriOrId = vmInfo.getVmID();
    }

    public Map<String, String> getExtendParams() {
        return this.extendParams;
    }

    public void setExtendParams(Map<String, String> extendParams) {
        this.extendParams = extendParams;
    }

    public String getUrn() {
        return this.urn;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Map<String, List<String>> getMapSrcdsurnToLunId() {
        return this.mapSrcdsurnToLunId;
    }

    public void setMapSrcdsurnToLunId(Map<String, List<String>> mapSrcdsurnToLunId) {
        this.mapSrcdsurnToLunId = mapSrcdsurnToLunId;
    }

    public String getVmType() {
        return this.vmType;
    }

    public void setVmType(String vmType) {
        this.vmType = vmType;
    }

    public boolean isHostLoc() {
        return this.hostLoc;
    }

    public void setHostLoc(boolean hostLoc) {
        this.hostLoc = hostLoc;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOsOption() {
        return this.osOption;
    }

    public void setOsOption(String osOption) {
        this.osOption = osOption;
    }

    public String getVmConfig() {
        return this.vmConfig;
    }

    public void setVmConfig(String vmConfig) {
        this.vmConfig = vmConfig;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    public boolean isLinkClone() {
        return this.linkClone;
    }

    public void setLinkClone(boolean linkClone) {
        this.linkClone = linkClone;
    }

    public String getVmUriOrId() {
        return this.vmUriOrId;
    }

    public void setVmUriOrId(String vmUriOrId) {
        this.vmUriOrId = vmUriOrId;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Boolean getIsMultiDiskSpeedup() {
        return this.isMultiDiskSpeedup;
    }

    public void setIsMultiDiskSpeedup(Boolean isMultiDiskSpeedup) {
        this.isMultiDiskSpeedup = isMultiDiskSpeedup;
    }

    public String generateVmOsType() {
        OsOptionsType osOptions;
        String osType = "--";
        if (GalaxVM.VMProviderType.FC.getValue().equals(this.vmType) && this.isFcOptionValid(osOptions = (OsOptionsType)this.generateVmOsOption())) {
            osType = osOptions.getOsType();
        }
        if (GalaxVM.VMProviderType.FM.getValue().equals(this.vmType) && this.isFmOptionValid((ResourcepoolVMServiceV2Stub.OsOptions)(osOptions = (ResourcepoolVMServiceV2Stub.OsOptions)this.generateVmOsOption()))) {
            osType = osOptions.getOsType();
        }
        return osType;
    }

    private boolean isFcOptionValid(OsOptionsType osOptions) {
        return null != osOptions && !VerifyUtil.isEmpty((String)osOptions.getOsType());
    }

    private boolean isFmOptionValid(ResourcepoolVMServiceV2Stub.OsOptions osOptions) {
        return null != osOptions && !VerifyUtil.isEmpty((String)osOptions.getOsType());
    }

    public String getConfidentialityLevel() {
        return this.confidentialityLevel;
    }

    public void setConfidentialityLevel(String confidentialityLevel) {
        this.confidentialityLevel = confidentialityLevel;
    }

    public abstract Object generateVmConfig();

    public abstract Object generateVmOsOption();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name:").append(this.name);
        sb.append("uuid:").append(this.uuid);
        sb.append("description:").append(this.description);
        sb.append("isMultiDiskSpeedup:").append(this.isMultiDiskSpeedup);
        sb.append("osOption:").append(this.osOption);
        sb.append("vmType:").append(this.vmType);
        sb.append("isHostLoc:").append(this.hostLoc);
        sb.append("location:").append(this.location);
        sb.append("template:").append(this.template);
        sb.append("linkClone:").append(this.linkClone);
        sb.append("vmConfig:").append(this.vmConfig);
        sb.append("vmUriOrId:").append(this.vmUriOrId);
        sb.append("confidentialityLevel:").append(this.confidentialityLevel);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmMgrInfoBase other = (VmMgrInfoBase)obj;
        return !this.isUuidNotEqual(other.getUuid());
    }

    private boolean isUuidNotEqual(String id) {
        return null == id || !this.uuid.equals(id);
    }

    public boolean isPropsSame(VmMgrInfoBase other) {
        if (!this.equals(other)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public String getVmVPCID() {
        return this.extendParams.get(CloudParamType.VPC_ID.getValue());
    }

    protected void setVmInfo(GalaxVM vm) {
        this.name = vm.getName();
        this.uuid = vm.getUuid();
        if (vm.isBindingHost().booleanValue()) {
            this.location = vm.getHostUrn();
            this.hostLoc = true;
        } else {
            this.location = vm.getClusterUrn();
            this.hostLoc = false;
        }
        this.template = vm.isTemplate();
        this.description = vm.getDescription();
        this.osOption = vm.getOsOptions();
        this.vmConfig = vm.getVmConfig();
        this.vmUriOrId = vm.getUri();
        this.linkClone = vm.isLinkClone();
        this.vmType = vm.getProviderID();
        this.confidentialityLevel = vm.getConfidentialityLevel();
        this.urn = vm.getUrn();
        this.isMultiDiskSpeedup = vm.getIsMultiDiskSpeedup();
    }
}

