/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.framework.log;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.wcc.framework.log.LogConfigReader;
import org.wcc.framework.log.LogFormatter;

public final class AppLogger {
    private static final Map<String, AppLogger> LOGGER_CACHE = new HashMap<String, AppLogger>();
    private static final String FQCN = AppLogger.class.getName();
    private transient Logger logger;

    private AppLogger(Class<?> logClass) {
        if (!LogConfigReader.isInited()) {
            LogConfigReader.init();
        }
        this.logger = Logger.getLogger(logClass);
    }

    private AppLogger(String className) {
        if (!LogConfigReader.isInited()) {
            LogConfigReader.init();
        }
        this.logger = Logger.getLogger((String)className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppLogger getInstance(Class<?> logClass) {
        String key = logClass.getName();
        if (LOGGER_CACHE.containsKey(key)) {
            return LOGGER_CACHE.get(key);
        }
        Map<String, AppLogger> map = LOGGER_CACHE;
        synchronized (map) {
            AppLogger al = LOGGER_CACHE.get(key);
            if (al == null) {
                al = new AppLogger(logClass);
                LOGGER_CACHE.put(key, al);
            }
            return al;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppLogger getInstance(String name) {
        if (LOGGER_CACHE.containsKey(name)) {
            return LOGGER_CACHE.get(name);
        }
        Map<String, AppLogger> map = LOGGER_CACHE;
        synchronized (map) {
            AppLogger al = LOGGER_CACHE.get(name);
            if (al == null) {
                al = new AppLogger(name);
                LOGGER_CACHE.put(name, al);
            }
            return al;
        }
    }

    public void info(Object message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.log(FQCN, (Priority)Level.INFO, message, null);
        }
    }

    public void info(String paramString, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)paramString, t);
        }
    }

    public void info(String paramString, Object paramObject) {
        if (this.logger.isInfoEnabled()) {
            String msgStr = LogFormatter.format(paramString, paramObject);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)msgStr, null);
        }
    }

    public void info(String paramString, Object ... argArray) {
        if (this.logger.isInfoEnabled()) {
            String msgStr = LogFormatter.arrayFormat(paramString, argArray);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)msgStr, null);
        }
    }

    public void warn(Object paramString) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.log(FQCN, (Priority)Level.WARN, paramString, null);
        }
    }

    public void warn(String paramString, Object paramObject) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            String msgStr = LogFormatter.format(paramString, paramObject);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)msgStr, null);
        }
    }

    public void warn(String paramString, Object ... argArray) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            String msgStr = LogFormatter.arrayFormat(paramString, argArray);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)msgStr, null);
        }
    }

    public void warn(String paramString, Throwable t) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)paramString, t);
        }
    }

    public void debug(Object paramObject) {
        if (this.logger.isDebugEnabled()) {
            this.logger.log(FQCN, (Priority)Level.DEBUG, paramObject, null);
        }
    }

    public void debug(String paramString, Object paramObject) {
        if (this.logger.isDebugEnabled()) {
            String msgStr = LogFormatter.format(paramString, paramObject);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msgStr, null);
        }
    }

    public void debug(String paramString, Object ... argArray) {
        if (this.logger.isDebugEnabled()) {
            String msgStr = LogFormatter.arrayFormat(paramString, argArray);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msgStr, null);
        }
    }

    public void debug(String paramString, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)paramString, t);
        }
    }

    public void error(Object message) {
        if (message == null) {
            return;
        }
        if (message instanceof Throwable) {
            Throwable t = (Throwable)message;
            this.error(t.getMessage(), t);
        } else {
            this.logger.log(FQCN, (Priority)Level.ERROR, message, null);
        }
    }

    public void error(String paramString, Object paramObject) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            String msgStr = LogFormatter.format(paramString, paramObject);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msgStr, null);
        }
    }

    public void error(String paramString, Object ... argArray) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            String msgStr = LogFormatter.arrayFormat(paramString, argArray);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msgStr, null);
        }
    }

    public void error(String paramString, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)paramString, t);
    }
}

