/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.framework.log;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileSize {
    public static final long KB_COEFFICIENT = 1024L;
    public static final long MB_COEFFICIENT = 0x100000L;
    public static final long GB_COEFFICIENT = 0x40000000L;
    private static final String LENGTH_PART = "([0-9]+)";
    private static final int DOUBLE_GROUP = 1;
    private static final String UNIT_PART = "(|kb|mb|gb)s?";
    private static final int UNIT_GROUP = 2;
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("([0-9]+)\\s*(|kb|mb|gb)s?", 2);
    private final long size;

    public FileSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public static FileSize valueOf(String fileSizeStr) {
        long coefficient;
        String unitStr;
        Matcher matcher = FILE_SIZE_PATTERN.matcher(fileSizeStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("String value [" + fileSizeStr + "] is not in the expected format.");
        }
        String lenStr = matcher.group(1);
        switch (unitStr = matcher.group(2).toLowerCase()) {
            case "": {
                coefficient = 1L;
                break;
            }
            case "kb": {
                coefficient = 1024L;
                break;
            }
            case "mb": {
                coefficient = 0x100000L;
                break;
            }
            case "gb": {
                coefficient = 0x40000000L;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected " + unitStr);
            }
        }
        long lenVal = Long.valueOf(lenStr);
        return new FileSize(lenVal * coefficient);
    }

    public String toString() {
        if (this.size > 0x100000L) {
            return this.size / 0x100000L + " MB";
        }
        if (this.size > 1024L) {
            return this.size / 1024L + " KB";
        }
        return this.size + " Bytes";
    }
}

