/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.framework.log;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class SizeRollingFileAppender
extends RollingFileAppender {
    private static final int INVALID_NUM = -1;
    private long nextRollover = 0L;
    private String logFileName = null;
    private String logFileAttachName = null;
    private String targetFileName = null;

    protected static String getDateTime() {
        Date dateTime = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        return df.format(dateTime);
    }

    protected String getTargetFileName() {
        return this.targetFileName;
    }

    protected void getFileAttach(String fileName) {
        int endPoint = fileName.lastIndexOf(".");
        if (endPoint != -1) {
            this.logFileAttachName = fileName.substring(endPoint);
            this.logFileName = fileName.substring(0, endPoint);
        } else {
            this.logFileAttachName = "";
            this.logFileName = fileName;
        }
    }

    private static int getFileIndex(File file) {
        int fileNum;
        int nStart;
        if (null == file || !file.exists()) {
            return -1;
        }
        String fileName = file.getName();
        int nEnd = fileName.indexOf("]", nStart = fileName.indexOf("["));
        if (nEnd < nStart || nStart == -1 || nEnd == -1) {
            return -1;
        }
        String nameIdx = fileName.substring(nStart + 1, nEnd);
        try {
            fileNum = Integer.parseInt(nameIdx);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return fileNum;
    }

    protected boolean isMatchLogFileName(String fileName, String fileAttachName, String fileFullName) {
        boolean isMatch;
        if (null == fileName || null == fileAttachName || null == fileFullName) {
            LogLog.debug((String)"file head is wrong");
            return false;
        }
        String logFileMatchString = this.getFileMatchString(fileName, fileAttachName, fileFullName);
        logFileMatchString = Normalizer.normalize(logFileMatchString, Normalizer.Form.NFKC);
        try {
            Pattern pattern = Pattern.compile(logFileMatchString);
            Matcher match = pattern.matcher(fileFullName);
            isMatch = match.matches();
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return isMatch;
    }

    protected String getFileMatchString(String fileName, String fileAttachName, String fileFullName) {
        int filePos = fileName.lastIndexOf("/");
        String fileRealName = -1 == filePos ? fileName : fileName.substring(filePos + 1);
        return fileRealName + "\\.\\d{4}-\\d{2}-\\d{2}_\\d{2}-\\d{2}-\\d{2}\\.\\[\\d{1,3}\\]" + fileAttachName;
    }

    protected List<File> getlistLog(File dir, String fileName, String fileAttachName) {
        if (dir == null) {
            LogLog.debug((String)"dir is null");
            return null;
        }
        File[] fs = dir.listFiles();
        if (fs == null) {
            LogLog.error((String)"Log Dir no permission or not exists");
            return null;
        }
        if (fs.length == 0) {
            LogLog.debug((String)"dir length is 0");
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        for (File curFile : fs) {
            if (!this.isMatchLogFileName(fileName, fileAttachName, curFile.getName()) || SizeRollingFileAppender.getFileIndex(curFile) == -1 || curFile.isDirectory()) continue;
            fileList.add(curFile);
        }
        return fileList;
    }

    protected String[] getMaxIdxFileName(List<File> logFile, int maxNum, String fileName, String fileAttachName) {
        String[] nullString = null;
        if (logFile == null) {
            return nullString;
        }
        ArrayList<String> outFileList = new ArrayList<String>();
        for (File curFile : logFile) {
            int fileNum;
            if (!this.isMatchLogFileName(fileName, fileAttachName, curFile.getName()) || (fileNum = SizeRollingFileAppender.getFileIndex(curFile)) == -1 || maxNum > fileNum) continue;
            outFileList.add(curFile.getName());
        }
        String[] outName = new String[outFileList.size()];
        outFileList.toArray(outName);
        return outName;
    }

    protected static String getLogDir(String fileName) throws IOException {
        if (null == fileName) {
            LogLog.debug((String)"No file to find dir");
            return null;
        }
        File f = new File(fileName);
        File fileParent = f.getAbsoluteFile().getParentFile();
        if (null == fileParent) {
            LogLog.debug((String)"this parents file error ");
            return null;
        }
        return fileParent.getCanonicalPath();
    }

    protected boolean deleteOutDateFile(List<File> logFile, int maxNum, String filePath) {
        boolean renameSucceeded = true;
        String[] maxFileName = this.getMaxIdxFileName(logFile, maxNum, this.logFileName, this.logFileAttachName);
        if (null == maxFileName) {
            LogLog.debug((String)"have no dir to get the file");
            this.createNewLogFile();
            return false;
        }
        for (int i = 0; i < maxFileName.length; ++i) {
            File file;
            if (null == maxFileName[i] || !(file = new File(filePath + "/" + maxFileName[i])).exists()) continue;
            renameSucceeded = file.delete();
        }
        return renameSucceeded;
    }

    protected boolean changeFileName(String filePath, List<File> logFiles) {
        boolean renameSucceeded = true;
        int fileNum = -1;
        String addIdxFileName = null;
        Collections.sort(logFiles, new FileComparator());
        File target = null;
        String logNameAttch = null;
        for (File curFile : logFiles) {
            int nStart;
            fileNum = SizeRollingFileAppender.getFileIndex(curFile);
            if (fileNum == -1 || (nStart = (addIdxFileName = curFile.getName()).indexOf(".[")) < 0) continue;
            logNameAttch = addIdxFileName.substring(0, nStart);
            if (!curFile.exists()) continue;
            target = new File(this.getNewNameWithIndex(filePath, logNameAttch, ++fileNum));
            renameSucceeded = curFile.renameTo(target);
        }
        return renameSucceeded;
    }

    public void rollOver() {
    }

    public void initFileName() {
        if (this.logFileName == null || this.logFileAttachName == null) {
            this.getFileAttach(this.fileName);
        }
    }

    public void rollOverDate() {
        String filePath;
        this.initFileName();
        if (this.qw != null) {
            long size = ((CountingQuietWriter)this.qw).getCount();
            this.nextRollover = size + this.maxFileSize;
            LogLog.debug((String)("rolling over count=" + size));
        }
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        if (this.maxBackupIndex <= 0) {
            return;
        }
        try {
            filePath = SizeRollingFileAppender.getLogDir(this.fileName);
        }
        catch (IOException e1) {
            LogLog.debug((String)"IOException:log file path is null!");
            this.createNewLogFile();
            return;
        }
        if (null == filePath) {
            LogLog.debug((String)"No such file dir");
            this.createNewLogFile();
            return;
        }
        File dir = new File(filePath);
        List<File> logFiles = this.getlistLog(dir, this.logFileName, this.logFileAttachName);
        if (null == logFiles) {
            LogLog.debug((String)"No log file!");
            this.createNewLogFile();
            return;
        }
        boolean successed = this.deleteOutDateFile(logFiles, this.maxBackupIndex, filePath);
        if (!successed) {
            LogLog.debug((String)"delete failed.");
            return;
        }
        successed = this.changeFileName(filePath, logFiles);
        if (!successed) {
            LogLog.debug((String)"changeFileName failed.");
        }
        this.renameFileName();
        this.doAfterRename();
    }

    private void createNewLogFile() {
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
        finally {
            this.nextRollover = 0L;
        }
    }

    private void reopenLogFile() {
        try {
            this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error((String)("setFile(" + this.fileName + ", true) call failed."));
        }
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            if (this.closed) {
                return;
            }
            this.fileName = this.logFileName + this.logFileAttachName;
            this.reopenLogFile();
            if (!this.checkEntryConditions()) {
                return;
            }
        }
        this.subAppend(event);
    }

    protected void subAppend(LoggingEvent event) {
        super.subAppend(event);
        if (null == this.fileName || null == this.qw) {
            return;
        }
        long size = ((CountingQuietWriter)this.qw).getCount();
        if (size >= this.maxFileSize && size >= this.nextRollover) {
            this.rollOverDate();
        }
    }

    protected String getNewNameWithIndex(String filePath, String logNameAttch, int numIdx) {
        return filePath + "/" + logNameAttch + ".[" + numIdx + "]" + this.logFileAttachName;
    }

    protected void doAfterRename() {
    }

    protected void renameFileName() {
        this.targetFileName = this.logFileName + "." + SizeRollingFileAppender.getDateTime() + ".[" + 1 + "]" + this.logFileAttachName;
        File target = new File(this.targetFileName);
        this.closeFile();
        File file = new File(this.fileName);
        boolean successed = file.renameTo(target);
        if (successed) {
            this.createNewLogFile();
        } else {
            this.reopenLogFile();
        }
    }

    private static class FileComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 2527533828897494146L;

        private FileComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            return SizeRollingFileAppender.getFileIndex(file1) - SizeRollingFileAppender.getFileIndex(file2);
        }
    }
}

