/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.framework.log;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.SyslogQuietWriter;
import org.apache.log4j.spi.LoggingEvent;
import org.wcc.framework.log.SyslogWriterCopy;

public class SyslogAppender
extends AppenderSkeleton {
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 72;
    public static final int LOG_AUTHPRIV = 80;
    public static final int LOG_FTP = 88;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    protected static final int SYSLOG_HOST_OI = 0;
    protected static final int FACILITY_OI = 1;
    static final String TAB = "    ";
    private static final Map<Integer, String> FACILITY_TO_NAME = new HashMap<Integer, String>();
    private static final Map<String, Integer> NAME_TO_FACILITY = new HashMap<String, Integer>();
    int syslogFacility = 8;
    String facilityStr;
    boolean facilityPrinting = false;
    SyslogQuietWriter sqw;
    String syslogHost;
    private boolean header = false;
    private static ThreadLocal<SimpleDateFormat> threadLocalDateFormat;
    private String localHostname;
    private boolean layoutHeaderChecked = false;
    private String moduleName = "";

    public SyslogAppender() {
        this.initSyslogFacilityStr();
    }

    public SyslogAppender(Layout layout, int syslogFacility) {
        this.layout = layout;
        this.syslogFacility = syslogFacility;
        this.initSyslogFacilityStr();
    }

    public SyslogAppender(Layout layout, String syslogHost, int syslogFacility) {
        this(layout, syslogFacility);
        this.setSyslogHost(syslogHost);
    }

    public SyslogAppender(Layout layout, String syslogHost, int syslogFacility, String moduleName) {
        this(layout, syslogHost, syslogFacility);
        this.setModuleName(moduleName);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public final void setModuleName(String moduleName) {
        this.moduleName = "[" + moduleName + "]";
    }

    public synchronized void close() {
        this.closed = true;
        if (null == this.sqw) {
            return;
        }
        try {
            if (this.layoutHeaderChecked && this.layout != null && this.layout.getFooter() != null) {
                this.sendLayoutMessage(this.layout.getFooter());
            }
            this.sqw.close();
            this.sqw = null;
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
            this.sqw = null;
        }
        catch (IOException e) {
            this.sqw = null;
        }
    }

    private void initSyslogFacilityStr() {
        this.facilityStr = SyslogAppender.getFacilityString(this.syslogFacility);
        if (this.facilityStr == null) {
            this.syslogFacility = 8;
            this.facilityStr = "user:";
        } else {
            this.facilityStr = this.facilityStr + ":";
        }
    }

    public static String getFacilityString(int syslogFacility) {
        String result = FACILITY_TO_NAME.get(syslogFacility);
        if (null != result) {
            result = result.toLowerCase(Locale.ENGLISH);
        }
        return result;
    }

    public static int getFacility(String facilityName) {
        Integer result;
        if (facilityName != null) {
            facilityName = facilityName.trim();
            facilityName = facilityName.toLowerCase(Locale.ENGLISH);
        }
        if (null != (result = NAME_TO_FACILITY.get(facilityName))) {
            return result;
        }
        return -1;
    }

    private void splitPacket(String header, String packet) {
        int byteCount;
        try {
            byteCount = packet.getBytes(Charset.defaultCharset().name()).length;
        }
        catch (UnsupportedEncodingException e) {
            try {
                byteCount = packet.getBytes("ISO-8859-1").length;
            }
            catch (UnsupportedEncodingException ex) {
                LogLog.error((String)("UnsupportedEncodingException. ISO-8859-1 and " + Charset.defaultCharset().name()));
                return;
            }
        }
        String black = " ";
        if (byteCount <= 1019 - this.moduleName.length()) {
            if (packet.startsWith(" ")) {
                black = "";
            }
            if (packet.contains(this.moduleName)) {
                this.sqw.write(black + packet);
            } else {
                this.sqw.write(black + packet + this.moduleName);
            }
        } else {
            int split = header.length() + (packet.length() - header.length()) / 2;
            this.splitPacket(header, packet.substring(0, split) + "...");
            this.splitPacket(header, header + "..." + packet.substring(split));
        }
    }

    public void append(LoggingEvent event) {
        if (!this.isAsSevereAsThreshold((Priority)event.getLevel())) {
            return;
        }
        if (this.sqw == null) {
            this.errorHandler.error("No syslog host is set for SyslogAppedender named \"" + this.name + "\".");
            return;
        }
        if (!this.layoutHeaderChecked) {
            if (this.layout != null && this.layout.getHeader() != null) {
                this.sendLayoutMessage(this.layout.getHeader());
            }
            this.layoutHeaderChecked = true;
        }
        String hdr = this.getPacketHeader(event.timeStamp);
        String packet = this.layout == null ? String.valueOf(event.getMessage()) : this.layout.format(event);
        if (this.facilityPrinting || hdr.length() > 0) {
            StringBuffer buf = new StringBuffer(hdr);
            if (this.facilityPrinting) {
                buf.append(this.facilityStr);
            }
            buf.append(packet);
            packet = buf.toString();
        }
        this.writePacket(event, packet, hdr);
    }

    public void activateOptions() {
        if (this.header) {
            this.getLocalHostname();
        }
        if (this.layout != null && this.layout.getHeader() != null) {
            this.sendLayoutMessage(this.layout.getHeader());
        }
        this.layoutHeaderChecked = true;
    }

    public boolean requiresLayout() {
        return true;
    }

    public final void setSyslogHost(String syslogHost) {
        this.sqw = new SyslogQuietWriter((Writer)new SyslogWriterCopy(syslogHost), this.syslogFacility, this.errorHandler);
        this.syslogHost = syslogHost;
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setFacility(String facilityName) {
        if (facilityName == null) {
            return;
        }
        this.syslogFacility = SyslogAppender.getFacility(facilityName);
        if (this.syslogFacility == -1) {
            this.syslogFacility = 8;
        }
        this.initSyslogFacilityStr();
        if (this.sqw != null) {
            this.sqw.setSyslogFacility(this.syslogFacility);
        }
    }

    public String getFacility() {
        return SyslogAppender.getFacilityString(this.syslogFacility);
    }

    public void setFacilityPrinting(boolean on) {
        this.facilityPrinting = on;
    }

    public boolean getFacilityPrinting() {
        return this.facilityPrinting;
    }

    public final boolean getHeader() {
        return this.header;
    }

    public final void setHeader(boolean val) {
        this.header = val;
    }

    private String getLocalHostname() {
        if (null != this.localHostname) {
            return this.localHostname;
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.localHostname = addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            this.localHostname = "UNKNOWN_HOST";
        }
        return this.localHostname;
    }

    private String getPacketHeader(long timeStamp) {
        if (!this.header) {
            return "";
        }
        StringBuffer buf = new StringBuffer(threadLocalDateFormat.get().format(new Date(timeStamp)));
        if (buf.charAt(4) == '0') {
            buf.setCharAt(4, ' ');
        }
        buf.append(this.getLocalHostname());
        buf.append(' ');
        return buf.toString();
    }

    private void sendLayoutMessage(String msg) {
        if (null == this.sqw) {
            return;
        }
        String packet = msg;
        String hdr = this.getPacketHeader(new Date().getTime());
        if (this.facilityPrinting || hdr.length() > 0) {
            StringBuffer buf = new StringBuffer(hdr);
            if (this.facilityPrinting) {
                buf.append(this.facilityStr);
            }
            buf.append(msg);
            packet = buf.toString();
        }
        this.sqw.setLevel(6);
        this.sqw.write(packet);
    }

    private void writePacket(LoggingEvent event, String packet, String hdr) {
        this.sqw.setLevel(event.getLevel().getSyslogEquivalent());
        if (packet.length() > 256) {
            this.splitPacket(hdr, packet);
        } else {
            this.sqw.write(packet);
        }
        if (null != this.layout && !this.layout.ignoresThrowable()) {
            return;
        }
        String[] s = event.getThrowableStrRep();
        if (null == s) {
            return;
        }
        for (int i = 0; i < s.length; ++i) {
            if (s[i].startsWith("\t")) {
                this.sqw.write(" " + this.moduleName + hdr + TAB + s[i].substring(1));
                continue;
            }
            this.sqw.write(" " + this.moduleName + hdr + s[i]);
        }
    }

    static {
        FACILITY_TO_NAME.put(0, "kern");
        FACILITY_TO_NAME.put(8, "user");
        FACILITY_TO_NAME.put(16, "mail");
        FACILITY_TO_NAME.put(24, "daemon");
        FACILITY_TO_NAME.put(32, "auth");
        FACILITY_TO_NAME.put(40, "syslog");
        FACILITY_TO_NAME.put(48, "lpr");
        FACILITY_TO_NAME.put(56, "news");
        FACILITY_TO_NAME.put(64, "uucp");
        FACILITY_TO_NAME.put(72, "cron");
        FACILITY_TO_NAME.put(80, "authpriv");
        FACILITY_TO_NAME.put(88, "ftp");
        FACILITY_TO_NAME.put(128, "local0");
        FACILITY_TO_NAME.put(136, "local1");
        FACILITY_TO_NAME.put(144, "local2");
        FACILITY_TO_NAME.put(152, "local3");
        FACILITY_TO_NAME.put(160, "local4");
        FACILITY_TO_NAME.put(168, "local5");
        FACILITY_TO_NAME.put(176, "local6");
        FACILITY_TO_NAME.put(184, "local7");
        NAME_TO_FACILITY.put("kern", 0);
        NAME_TO_FACILITY.put("user", 8);
        NAME_TO_FACILITY.put("mail", 16);
        NAME_TO_FACILITY.put("daemon", 24);
        NAME_TO_FACILITY.put("auth", 32);
        NAME_TO_FACILITY.put("syslog", 40);
        NAME_TO_FACILITY.put("lpr", 48);
        NAME_TO_FACILITY.put("news", 56);
        NAME_TO_FACILITY.put("uucp", 64);
        NAME_TO_FACILITY.put("cron", 72);
        NAME_TO_FACILITY.put("authpriv", 80);
        NAME_TO_FACILITY.put("ftp", 88);
        NAME_TO_FACILITY.put("local0", 128);
        NAME_TO_FACILITY.put("local1", 136);
        NAME_TO_FACILITY.put("local2", 144);
        NAME_TO_FACILITY.put("local3", 152);
        NAME_TO_FACILITY.put("local4", 160);
        NAME_TO_FACILITY.put("local5", 168);
        NAME_TO_FACILITY.put("local6", 176);
        NAME_TO_FACILITY.put("local7", 184);
        threadLocalDateFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("MMM dd HH:mm:ss ", Locale.ENGLISH);
            }
        };
    }
}

