/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.framework.log;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import org.apache.log4j.helpers.LogLog;

public class SyslogWriterCopy
extends Writer {
    private static final int SYSLOG_PORT = 514;
    private final int port;
    private InetAddress address;
    private DatagramSocket ds;

    public SyslogWriterCopy(String syslogHost) {
        if (syslogHost == null) {
            throw new NullPointerException("syslogHost");
        }
        String host = syslogHost;
        int urlPort = -1;
        if (host.indexOf("[") != -1 || host.indexOf(58) == host.lastIndexOf(58)) {
            try {
                URL url = new URL("http://" + host);
                if (url.getHost() != null && "".equals(url.getHost())) {
                    host = url.getHost();
                    urlPort = url.getPort();
                    if (host.startsWith("[") && host.endsWith("]")) {
                        host = host.substring(1, host.length() - 1);
                    }
                }
            }
            catch (MalformedURLException e) {
                LogLog.error((String)"Malformed URL: will attempt to interpret as InetAddress.", (Throwable)e);
            }
        }
        if (urlPort == -1) {
            urlPort = 514;
        }
        this.port = urlPort;
        try {
            this.address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            LogLog.error((String)("Could not find " + host + ". All logging will FAIL."), (Throwable)e);
        }
        try {
            this.ds = new DatagramSocket(0, InetAddress.getByName("localhost"));
        }
        catch (SocketException e) {
            LogLog.error((String)("Could not instantiate DatagramSocket to " + host + ". All logging will FAIL."), (Throwable)e);
        }
        catch (UnknownHostException e) {
            LogLog.error((String)("UnknownHost exception ,host info:" + host));
        }
    }

    @Override
    public void write(char[] buf, int off, int len) throws IOException {
        this.write(new String(buf, off, len));
    }

    @Override
    public void write(String string) throws IOException {
        byte[] bytes;
        if (null == this.ds || null == this.address) {
            return;
        }
        try {
            bytes = string.getBytes(Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            try {
                bytes = string.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException ex) {
                LogLog.error((String)("UnsupportedEncodingException. ISO-8859-1 and " + Charset.defaultCharset().name()));
                return;
            }
        }
        int bytesLength = bytes.length;
        if (bytesLength >= 1024) {
            bytesLength = 1024;
        }
        DatagramPacket packet = new DatagramPacket(bytes, bytesLength, this.address, this.port);
        this.ds.send(packet);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (this.ds != null) {
            this.ds.close();
        }
    }
}

